/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractMerge
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;
    private static final OnRefOnly V_1_1 = OnRefOnly.newOnRef("v1_1");
    private static final OnRefOnly V_1_2 = OnRefOnly.newOnRef("v1_2");
    private static final OnRefOnly V_1_4 = OnRefOnly.newOnRef("v1_4");
    private static final OnRefOnly V_2_1 = OnRefOnly.newOnRef("v2_1");
    private static final OnRefOnly V_2_2 = OnRefOnly.newOnRef("v2_2");
    private static final OnRefOnly V_3_1 = OnRefOnly.newOnRef("v3_1");
    private static final OnRefOnly V_4_1 = OnRefOnly.newOnRef("v4_1");
    private static final OnRefOnly V_5_1 = OnRefOnly.newOnRef("v5_1");
    private static final OnRefOnly VALUE_1 = OnRefOnly.newOnRef("value1");
    private static final OnRefOnly VALUE_2 = OnRefOnly.newOnRef("value2");
    private static final OnRefOnly VALUE_3 = OnRefOnly.newOnRef("value3");
    private static final OnRefOnly VALUE_4 = OnRefOnly.newOnRef("value4");
    private static final OnRefOnly VALUE_5 = OnRefOnly.newOnRef("value5");
    private static final OnRefOnly VALUE_6 = OnRefOnly.newOnRef("value6");
    private Hash initialHash;
    private Hash firstCommit;
    private Hash thirdCommit;
    private List<Commit> commits;

    protected AbstractMerge(VersionStore store) {
        super(store);
    }

    @BeforeEach
    protected void setupCommits() throws VersionStoreException {
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        this.initialHash = this.commit("Default common ancestor").toBranch(branch);
        this.firstCommit = this.commit("First Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).put("t3", (Content)V_3_1).toBranch(branch);
        Content t1 = this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t1"}));
        this.commit("Second Commit").put("t1", (Content)V_1_2.withId(t1)).delete("t2").delete("t3").put("t4", (Content)V_4_1).toBranch(branch);
        this.thirdCommit = this.commit("Third Commit").put("t2", (Content)V_2_2).unchanged("t4").toBranch(branch);
        this.commits = this.commitsList((Ref)branch, false).subList(0, 3);
    }

    private MetadataRewriter<CommitMeta> createMetadataRewriter(final String suffix) {
        return new MetadataRewriter<CommitMeta>(){

            public CommitMeta rewriteSingle(CommitMeta metadata) {
                return CommitMeta.fromMessage((String)(metadata.getMessage() + suffix));
            }

            public CommitMeta squash(List<CommitMeta> metadata) {
                return CommitMeta.fromMessage((String)metadata.stream().map(cm -> cm.getMessage() + suffix).collect(Collectors.joining("\n-----------------------------------\n")));
            }
        };
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoEmptyBranch3Commits(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"mergeIntoEmptyBranch3Commits");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        this.doMergeIntoEmpty(individualCommits, newBranch, metadataRewriter);
        if (individualCommits) {
            this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)newBranch, Optional.empty())).isEqualTo((Object)this.thirdCommit);
            AbstractMerge.assertCommitMeta(this.soft, this.commitsList((Ref)newBranch, false).subList(0, 3), this.commits, metadataRewriter);
        } else {
            Assertions.assertThat((Object)this.store().hashOnReference((NamedRef)newBranch, Optional.empty())).isNotEqualTo((Object)this.thirdCommit);
            ((ObjectAssert)this.soft.assertThat(this.commitsList((Ref)newBranch, false)).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).asString().contains((CharSequence[])this.commits.stream().map(Commit::getCommitMeta).map(CommitMeta::getMessage).toArray(String[]::new));
        }
    }

    private void doMergeIntoEmpty(boolean individualCommits, BranchName newBranch, MetadataRewriter<CommitMeta> metadataRewriter) throws ReferenceNotFoundException, ReferenceConflictException {
        this.store().merge(this.thirdCommit, newBranch, Optional.of(this.initialHash), metadataRewriter, individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false);
        this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}), ContentKey.of((String[])new String[]{"t4"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{"t4"}), (Object)((Object)V_4_1)));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void compareDryAndEffectiveMergeResults(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"compareDryAndEffectiveMergeResults");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        MergeResult dryMergeResult = this.store().merge(this.firstCommit, newBranch, Optional.of(this.initialHash), metadataRewriter, individualCommits, Collections.emptyMap(), MergeType.NORMAL, true, true);
        this.soft.assertThat((Object)dryMergeResult).extracting(new Function[]{MergeResult::wasApplied, MergeResult::wasSuccessful, MergeResult::getCommonAncestor, MergeResult::getTargetBranch, MergeResult::getEffectiveTargetHash, MergeResult::getExpectedHash}).containsExactly(new Object[]{false, true, this.initialHash, newBranch, this.initialHash, this.initialHash});
        MergeResult mergeResult = this.store().merge(this.firstCommit, newBranch, Optional.of(this.initialHash), metadataRewriter, individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, true);
        Hash head = this.store().getNamedRef(newBranch.getName(), GetNamedRefsParams.DEFAULT).getHash();
        this.soft.assertThat(mergeResult.getSourceCommits()).satisfiesAnyOf(new ThrowingConsumer[]{l -> Assertions.assertThat((List)l).isEmpty(), l -> Assertions.assertThat((List)l).extracting(new Function[]{Commit::getHash, c -> c.getCommitMeta().getMessage(), c -> AbstractMerge.operationsWithoutContentId(c.getOperations())}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{this.firstCommit, "First Commit", Arrays.asList(Put.of((ContentKey)ContentKey.of((String[])new String[]{"t1"}), (Content)V_1_1), Put.of((ContentKey)ContentKey.of((String[])new String[]{"t2"}), (Content)V_2_1), Put.of((ContentKey)ContentKey.of((String[])new String[]{"t3"}), (Content)V_3_1))})})});
        this.soft.assertThat(mergeResult.getTargetCommits()).isNull();
        this.soft.assertThat(mergeResult.getDetails()).containsKeys((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"})});
        ((ObjectAssert)this.soft.assertThat((Object)mergeResult).isEqualTo((Object)MergeResult.builder().wasApplied(true).wasSuccessful(true).commonAncestor(this.initialHash).resultantTargetHash(head).targetBranch(newBranch).effectiveTargetHash(this.initialHash).expectedHash(this.initialHash).addAllSourceCommits((Iterable)mergeResult.getSourceCommits()).putAllDetails(mergeResult.getDetails()).build())).isEqualTo((Object)MergeResult.builder().from(dryMergeResult).wasApplied(true).resultantTargetHash(mergeResult.getResultantTargetHash()).build());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoEmptyBranch1Commit(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"mergeIntoEmptyBranch1Commit");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        this.store().merge(this.firstCommit, newBranch, Optional.of(this.initialHash), metadataRewriter, individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false);
        this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}), ContentKey.of((String[])new String[]{"t4"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_1), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_1), (Object)ContentKey.of((String[])new String[]{"t3"}), (Object)((Object)V_3_1)));
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)newBranch, Optional.empty())).isEqualTo((Object)this.firstCommit);
        List<Commit> mergedCommit = this.commitsList((Ref)newBranch, false).subList(0, 1);
        AbstractMerge.assertCommitMeta(this.soft, mergedCommit, this.commits.subList(2, 3), metadataRewriter);
        ((ListAssert)this.soft.assertThat((Object)mergedCommit.get(0)).extracting(Commit::getCommitMeta).extracting(CommitMeta::getParentCommitHashes).asInstanceOf(InstanceOfAssertFactories.list(Hash.class))).hasSize(1);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoEmptyBranchModifying(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"mergeIntoEmptyBranchModifying");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter(", merged");
        this.doMergeIntoEmpty(individualCommits, newBranch, metadataRewriter);
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)newBranch, Optional.empty())).isNotEqualTo((Object)this.thirdCommit);
        List<Commit> mergedCommits = this.commitsList((Ref)newBranch, false);
        if (individualCommits) {
            AbstractMerge.assertCommitMeta(this.soft, mergedCommits.subList(0, 3), this.commits, metadataRewriter);
        } else {
            ((ObjectAssert)this.soft.assertThat(mergedCommits).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).asString().contains((CharSequence[])this.commits.stream().map(Commit::getCommitMeta).map(CommitMeta::getMessage).toArray(String[]::new));
            ((ListAssert)((ObjectAssert)this.soft.assertThat(mergedCommits).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getParentCommitHashes).asInstanceOf(InstanceOfAssertFactories.list(String.class))).containsExactly((Object[])new String[]{mergedCommits.get(1).getHash().asString(), this.commits.get(0).getHash().asString()});
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoNonConflictingBranch(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_2");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        Hash newCommit = this.commit("Unrelated commit").put("t5", (Content)V_5_1).toBranch(newBranch);
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        MergeResult result = this.store().merge(this.thirdCommit, newBranch, Optional.empty(), metadataRewriter, individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false);
        this.soft.assertThat((Object)result.getResultantTargetHash()).isNotEqualTo((Object)this.thirdCommit);
        this.soft.assertThat(result.getSourceCommits()).satisfiesAnyOf(new ThrowingConsumer[]{l -> Assertions.assertThat((List)l).isEmpty(), l -> Assertions.assertThat((List)l).hasSize(3)});
        this.soft.assertThat((Object)result).extracting(new Function[]{MergeResult::getCommonAncestor, MergeResult::wasSuccessful, MergeResult::wasApplied}).containsExactly(new Object[]{this.initialHash, true, true});
        this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}), ContentKey.of((String[])new String[]{"t4"}), ContentKey.of((String[])new String[]{"t5"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{"t4"}), (Object)((Object)V_4_1), (Object)ContentKey.of((String[])new String[]{"t5"}), (Object)((Object)V_5_1)));
        List<Commit> commits = this.commitsList((Ref)newBranch, false);
        if (individualCommits) {
            this.soft.assertThat(commits).satisfiesExactly(new ThrowingConsumer[]{c0 -> Assertions.assertThat((Object)c0).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).isEqualTo((Object)"Third Commit"), c1 -> Assertions.assertThat((Object)c1).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).isEqualTo((Object)"Second Commit"), c2 -> Assertions.assertThat((Object)c2).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).isEqualTo((Object)"First Commit"), c3 -> Assertions.assertThat((Object)c3).extracting(Commit::getHash).isEqualTo((Object)newCommit), c4 -> Assertions.assertThat((Object)c4).extracting(Commit::getHash).isEqualTo((Object)this.initialHash)});
        } else {
            this.soft.assertThat(commits).satisfiesExactly(new ThrowingConsumer[]{c0 -> Assertions.assertThat((Object)c0).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).asString().contains(new CharSequence[]{"Third Commit", "Second Commit", "First Commit"}), c3 -> Assertions.assertThat((Object)c3).extracting(Commit::getHash).isEqualTo((Object)newCommit), c4 -> Assertions.assertThat((Object)c4).extracting(Commit::getHash).isEqualTo((Object)this.initialHash)});
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void nonEmptyFastForwardMerge(boolean individualCommits) throws VersionStoreException {
        ContentKey key = ContentKey.of((String[])new String[]{"t1"});
        BranchName etl = BranchName.of((String)"etl");
        BranchName review = BranchName.of((String)"review");
        this.store().create((NamedRef)etl, Optional.of(this.initialHash));
        this.store().create((NamedRef)review, Optional.of(this.initialHash));
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        Hash etl1 = this.store().commit(etl, Optional.empty(), CommitMeta.fromMessage((String)"commit 1"), Collections.singletonList(Put.of((ContentKey)key, (Content)VALUE_1)));
        Content v = this.store().getValue((Ref)etl, key);
        MergeResult mergeResult1 = this.store().merge(this.store().hashOnReference((NamedRef)etl, Optional.empty()), review, Optional.empty(), metadataRewriter, individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false);
        this.soft.assertThat((Object)mergeResult1.getResultantTargetHash()).isEqualTo((Object)etl1);
        Hash etl2 = this.store().commit(etl, Optional.empty(), CommitMeta.fromMessage((String)"commit 2"), Collections.singletonList(Put.of((ContentKey)key, (Content)VALUE_2.withId(v))));
        MergeResult mergeResult2 = this.store().merge(this.store().hashOnReference((NamedRef)etl, Optional.empty()), review, Optional.empty(), metadataRewriter, individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false);
        this.soft.assertThat((Object)mergeResult2.getResultantTargetHash()).isEqualTo((Object)etl2);
        this.soft.assertThat((Object)AbstractMerge.contentWithoutId(this.store().getValue((Ref)review, key))).isEqualTo((Object)VALUE_2);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeWithCommonAncestor(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_2");
        this.store().create((NamedRef)newBranch, Optional.of(this.firstCommit));
        Hash newCommit = this.commit("Unrelated commit").put("t5", (Content)V_5_1).toBranch(newBranch);
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        this.store().merge(this.thirdCommit, newBranch, Optional.empty(), metadataRewriter, individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false);
        this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}), ContentKey.of((String[])new String[]{"t4"}), ContentKey.of((String[])new String[]{"t5"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{"t4"}), (Object)((Object)V_4_1), (Object)ContentKey.of((String[])new String[]{"t5"}), (Object)((Object)V_5_1)));
        List<Commit> commits = this.commitsList((Ref)newBranch, false);
        if (individualCommits) {
            ((ListAssert)this.soft.assertThat(commits).hasSize(5)).satisfiesExactly(new ThrowingConsumer[]{c -> Assertions.assertThat((String)c.getCommitMeta().getMessage()).isEqualTo("Third Commit"), c -> Assertions.assertThat((String)c.getCommitMeta().getMessage()).isEqualTo("Second Commit"), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)newCommit), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)this.firstCommit), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)this.initialHash)});
        } else {
            ((ListAssert)this.soft.assertThat(commits).hasSize(4)).satisfiesExactly(new ThrowingConsumer[]{c -> Assertions.assertThat((String)c.getCommitMeta().getMessage()).contains(new CharSequence[]{"Second Commit", "Third Commit"}), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)newCommit), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)this.firstCommit), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)this.initialHash)});
            ((ListAssert)((ObjectAssert)this.soft.assertThat(commits).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getParentCommitHashes).asInstanceOf(InstanceOfAssertFactories.list(String.class))).containsExactly((Object[])new String[]{newCommit.asString(), this.thirdCommit.asString()});
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeWithConflictingKeys(boolean individualCommits) throws VersionStoreException {
        BranchName mergeInto = BranchName.of((String)"foofoo");
        BranchName mergeFrom = BranchName.of((String)"barbar");
        this.store().create((NamedRef)mergeInto, Optional.of(this.initialHash));
        this.store().create((NamedRef)mergeFrom, Optional.of(this.initialHash));
        ContentKey conflictingKey1 = ContentKey.of((String[])new String[]{"some_key1"});
        ContentKey conflictingKey2 = ContentKey.of((String[])new String[]{"some_key2"});
        ContentKey key3 = ContentKey.of((String[])new String[]{"some_key3"});
        ContentKey key4 = ContentKey.of((String[])new String[]{"some_key4"});
        this.store().commit(mergeInto, Optional.empty(), CommitMeta.fromMessage((String)"commit 1"), Collections.singletonList(Put.of((ContentKey)conflictingKey1, (Content)VALUE_1)));
        this.store().commit(mergeFrom, Optional.empty(), CommitMeta.fromMessage((String)"commit 2"), Arrays.asList(Put.of((ContentKey)conflictingKey1, (Content)VALUE_2), Put.of((ContentKey)key3, (Content)VALUE_5)));
        Hash mergeIntoHead = this.store().commit(mergeInto, Optional.empty(), CommitMeta.fromMessage((String)"commit 3"), Arrays.asList(Put.of((ContentKey)conflictingKey2, (Content)VALUE_3), Put.of((ContentKey)key4, (Content)VALUE_6)));
        Hash mergeFromHash = this.store().commit(mergeFrom, Optional.empty(), CommitMeta.fromMessage((String)"commit 4"), Collections.singletonList(Put.of((ContentKey)conflictingKey2, (Content)VALUE_4)));
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge(mergeFromHash, mergeInto, Optional.empty(), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false)).isInstanceOf(ReferenceConflictException.class)).hasMessageContaining("The following keys have been changed in conflict:").hasMessageContaining(conflictingKey1.toString()).hasMessageContaining(conflictingKey2.toString());
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge(mergeFromHash, mergeInto, Optional.empty(), this.createMetadataRewriter(""), individualCommits, Collections.singletonMap(conflictingKey2, MergeType.DROP), MergeType.NORMAL, false, false)).isInstanceOf(ReferenceConflictException.class)).hasMessageContaining("The following keys have been changed in conflict:").hasMessageContaining(conflictingKey1.toString()).hasMessageNotContaining(conflictingKey2.toString());
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge(mergeFromHash, mergeInto, Optional.empty(), this.createMetadataRewriter(""), individualCommits, Collections.singletonMap(conflictingKey1, MergeType.NORMAL), MergeType.DROP, false, false)).isInstanceOf(ReferenceConflictException.class)).hasMessageContaining("The following keys have been changed in conflict:").hasMessageContaining(conflictingKey1.toString()).hasMessageNotContaining(conflictingKey2.toString());
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge(mergeFromHash, mergeInto, Optional.empty(), this.createMetadataRewriter(""), individualCommits, Collections.singletonMap(conflictingKey1, MergeType.FORCE), MergeType.NORMAL, false, false)).isInstanceOf(ReferenceConflictException.class)).hasMessageContaining("The following keys have been changed in conflict:").hasMessageNotContaining(conflictingKey1.toString()).hasMessageContaining(conflictingKey2.toString());
        Supplier<Hash> mergeIntoHeadSupplier = () -> {
            try {
                return this.store.getNamedRef(mergeInto.getName(), GetNamedRefsParams.DEFAULT).getHash();
            }
            catch (ReferenceNotFoundException e) {
                throw new RuntimeException(e);
            }
        };
        this.soft.assertThat((Object)mergeIntoHeadSupplier.get()).isEqualTo((Object)mergeIntoHead);
        this.store().merge(mergeFromHash, mergeInto, Optional.empty(), this.createMetadataRewriter(", merge-force-1"), individualCommits, (Map)ImmutableMap.of((Object)conflictingKey1, (Object)MergeType.FORCE, (Object)conflictingKey2, (Object)MergeType.DROP), MergeType.NORMAL, false, false);
        ((MapAssert)((MapAssert)((MapAssert)this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store.getValues((Ref)mergeIntoHeadSupplier.get(), Arrays.asList(conflictingKey1, conflictingKey2, key3, key4)))).containsEntry((Object)conflictingKey1, (Object)VALUE_2)).containsEntry((Object)conflictingKey2, (Object)VALUE_3)).containsEntry((Object)key3, (Object)VALUE_5)).containsEntry((Object)key4, (Object)VALUE_6);
        this.store().assign((NamedRef)mergeInto, Optional.empty(), mergeIntoHead);
        this.store().merge(mergeFromHash, mergeInto, Optional.empty(), this.createMetadataRewriter(", merge-all-force"), individualCommits, Collections.emptyMap(), MergeType.FORCE, false, false);
        ((MapAssert)((MapAssert)((MapAssert)this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store.getValues((Ref)mergeIntoHeadSupplier.get(), Arrays.asList(conflictingKey1, conflictingKey2, key3, key4)))).containsEntry((Object)conflictingKey1, (Object)VALUE_2)).containsEntry((Object)conflictingKey2, (Object)VALUE_4)).containsEntry((Object)key3, (Object)VALUE_5)).containsEntry((Object)key4, (Object)VALUE_6);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoConflictingBranch(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_3");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        this.commit("Another commit").put("t1", (Content)V_1_4).toBranch(newBranch);
        this.soft.assertThatThrownBy(() -> this.store().merge(this.thirdCommit, newBranch, Optional.of(this.initialHash), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false)).isInstanceOf(ReferenceConflictException.class);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoNonExistingBranch(boolean individualCommits) {
        BranchName newBranch = BranchName.of((String)"bar_5");
        this.soft.assertThatThrownBy(() -> this.store().merge(this.thirdCommit, newBranch, Optional.of(this.initialHash), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false)).isInstanceOf(ReferenceNotFoundException.class);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoNonExistingReference(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_6");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        this.soft.assertThatThrownBy(() -> this.store().merge(Hash.of((String)"1234567890abcdef"), newBranch, Optional.of(this.initialHash), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false)).isInstanceOf(ReferenceNotFoundException.class);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeEmptyCommit(boolean individualCommits) throws VersionStoreException {
        BranchName source = BranchName.of((String)"source");
        BranchName target = BranchName.of((String)"target");
        this.store().create((NamedRef)source, Optional.of(this.initialHash));
        this.store().create((NamedRef)target, Optional.of(this.initialHash));
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
        Hash targetHead = this.store().commit(target, Optional.empty(), CommitMeta.fromMessage((String)"target 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)VALUE_1)));
        targetHead = this.store().commit(target, Optional.of(targetHead), CommitMeta.fromMessage((String)"target 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)VALUE_1)));
        Hash sourceHead = this.store().commit(source, Optional.empty(), CommitMeta.fromMessage((String)"source 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)VALUE_2)));
        sourceHead = this.store().commit(source, Optional.of(sourceHead), CommitMeta.fromMessage((String)"source 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)VALUE_2)));
        this.store().merge(sourceHead, target, Optional.ofNullable(targetHead), this.createMetadataRewriter(", merge-drop"), individualCommits, (Map)ImmutableMap.of((Object)key1, (Object)MergeType.DROP, (Object)key2, (Object)MergeType.DROP), MergeType.NORMAL, false, false);
        try (PaginationIterator iterator = this.store().getCommits((Ref)target, true);){
            Hash newTargetHead = ((Commit)iterator.next()).getHash();
            Assertions.assertThat((Object)newTargetHead).isEqualTo((Object)targetHead);
        }
    }

    @Test
    public void mergeFromAndIntoHead() throws Exception {
        BranchName branch = BranchName.of((String)"source");
        this.store().create((NamedRef)branch, Optional.of(this.initialHash));
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
        Hash commit1 = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"commit 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)VALUE_1)));
        Hash commit2 = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"commit 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)VALUE_2)));
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge(commit2, branch, Optional.of(commit1), this.createMetadataRewriter(""), false, Collections.emptyMap(), MergeType.NORMAL, false, false));
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge(commit1, branch, Optional.of(commit2), this.createMetadataRewriter(""), false, Collections.emptyMap(), MergeType.NORMAL, false, false));
    }
}

