/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractDiff
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;
    public static final OnRefOnly V_1 = OnRefOnly.newOnRef("v1");
    public static final OnRefOnly V_2 = OnRefOnly.newOnRef("v2");
    public static final OnRefOnly V_2_A = OnRefOnly.newOnRef("v2a");
    public static final OnRefOnly V_3 = OnRefOnly.newOnRef("v3");
    public static final OnRefOnly V_1_A = OnRefOnly.newOnRef("v1a");

    protected AbstractDiff(VersionStore store) {
        super(store);
    }

    @Test
    protected void checkDiff() throws VersionStoreException {
        BranchName branch = BranchName.of((String)"checkDiff");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash initial = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        ContentKey k1 = ContentKey.of((String[])new String[]{"k1"});
        ContentKey k2 = ContentKey.of((String[])new String[]{"k2"});
        ContentKey k3 = ContentKey.of((String[])new String[]{"k3"});
        ContentKey k1a = ContentKey.of((String[])new String[]{"k1a"});
        Hash firstCommit = this.commit("First Commit").put("k1", (Content)V_1).put("k2", (Content)V_2).toBranch(branch);
        Content k2content = this.store().getValue((Ref)branch, k2);
        Hash secondCommit = this.commit("Second Commit").put("k2", (Content)V_2_A.withId(k2content)).put("k3", (Content)V_3).put("k1a", (Content)V_1_A).toBranch(branch);
        List<Diff> startToSecond = this.diffAsList(initial, secondCommit);
        this.soft.assertThat(AbstractDiff.diffsWithoutContentId(startToSecond)).containsExactlyInAnyOrder((Object[])new Diff[]{Diff.of((ContentKey)k1, Optional.empty(), Optional.of(V_1)), Diff.of((ContentKey)k2, Optional.empty(), Optional.of(V_2_A)), Diff.of((ContentKey)k3, Optional.empty(), Optional.of(V_3)), Diff.of((ContentKey)k1a, Optional.empty(), Optional.of(V_1_A))});
        List<Diff> secondToStart = this.diffAsList(secondCommit, initial);
        this.soft.assertThat(AbstractDiff.diffsWithoutContentId(secondToStart)).containsExactlyInAnyOrder((Object[])new Diff[]{Diff.of((ContentKey)k1, Optional.of(V_1), Optional.empty()), Diff.of((ContentKey)k2, Optional.of(V_2_A), Optional.empty()), Diff.of((ContentKey)k3, Optional.of(V_3), Optional.empty()), Diff.of((ContentKey)k1a, Optional.of(V_1_A), Optional.empty())});
        List<Diff> firstToSecond = this.diffAsList(firstCommit, secondCommit);
        this.soft.assertThat(AbstractDiff.diffsWithoutContentId(firstToSecond)).containsExactlyInAnyOrder((Object[])new Diff[]{Diff.of((ContentKey)k1a, Optional.empty(), Optional.of(V_1_A)), Diff.of((ContentKey)k2, Optional.of(V_2), Optional.of(V_2_A)), Diff.of((ContentKey)k3, Optional.empty(), Optional.of(V_3))});
        List<Diff> secondToFirst = this.diffAsList(secondCommit, firstCommit);
        this.soft.assertThat(AbstractDiff.diffsWithoutContentId(secondToFirst)).containsExactlyInAnyOrder((Object[])new Diff[]{Diff.of((ContentKey)k1a, Optional.of(V_1_A), Optional.empty()), Diff.of((ContentKey)k2, Optional.of(V_2_A), Optional.of(V_2)), Diff.of((ContentKey)k3, Optional.of(V_3), Optional.empty())});
        this.soft.assertThat(this.diffAsList(firstCommit, firstCommit)).isEmpty();
        if (this.store().getClass().getName().endsWith("VersionStoreImpl")) {
            this.soft.assertThat(this.diffAsList(initial, secondCommit, ContentKey.of((String[])new String[]{"k"}), ContentKey.of((String[])new String[]{"l"}), null, null)).extracting(Diff::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{k1, k2, k3, k1a});
            this.soft.assertThat(this.diffAsList(initial, secondCommit, ContentKey.of((String[])new String[]{"k"}), null, null, null)).extracting(Diff::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{k1, k2, k3, k1a});
            this.soft.assertThat(this.diffAsList(initial, secondCommit, null, k2, null, null)).extracting(Diff::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{k1, k2, k1a});
            this.soft.assertThat(this.diffAsList(initial, secondCommit, k1a, k2, null, null)).extracting(Diff::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{k1a, k2});
            this.soft.assertThat(this.diffAsList(initial, secondCommit, k2, k2, null, null)).extracting(Diff::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{k2});
            this.soft.assertThat(this.diffAsList(initial, secondCommit, ContentKey.of((String[])new String[]{"k4"}), ContentKey.of((String[])new String[]{"l"}), null, null)).isEmpty();
            this.soft.assertThat(this.diffAsList(initial, secondCommit, null, null, ContentKey.of((String[])new String[]{"k1"}), null)).extracting(Diff::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{k1});
            this.soft.assertThat(this.diffAsList(initial, secondCommit, null, null, ContentKey.of((String[])new String[]{"k"}), null)).extracting(Diff::getKey).isEmpty();
            this.soft.assertThat(this.diffAsList(initial, secondCommit, null, null, ContentKey.of((String[])new String[]{"x"}), null)).isEmpty();
        }
        this.soft.assertThat(this.diffAsList(initial, secondCommit, null, null, null, k -> k1.equals(k) || k3.equals(k))).extracting(Diff::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{k1, k3});
        this.soft.assertThat(this.diffAsList(initial, secondCommit, null, null, null, k -> false)).isEmpty();
    }

    private List<Diff> diffAsList(Hash initial, Hash secondCommit) throws ReferenceNotFoundException {
        return this.diffAsList(initial, secondCommit, null, null, null, null);
    }

    private List<Diff> diffAsList(Hash initial, Hash secondCommit, ContentKey minKey, ContentKey maxKey, ContentKey prefixKey, Predicate<ContentKey> keyPredicate) throws ReferenceNotFoundException {
        try (PaginationIterator diffStream = this.store().getDiffs((Ref)initial, (Ref)secondCommit, null, minKey, maxKey, prefixKey, keyPredicate);){
            ArrayList<Diff> r = new ArrayList<Diff>();
            diffStream.forEachRemaining(r::add);
            ArrayList<Diff> arrayList = r;
            return arrayList;
        }
    }
}

