/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Namespace;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractEntries
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected AbstractEntries(VersionStore store) {
        super(store);
    }

    @Test
    public void entriesWrongParameters() {
        Assumptions.assumeThat((String)this.store().getClass().getName()).endsWith((CharSequence)"VersionStoreImpl");
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.keysAsList((Ref)this.store().noAncestorHash(), ContentKey.of((String[])new String[]{"foo"}), ContentKey.of((String[])new String[]{"foo"}), ContentKey.of((String[])new String[]{"foo"}), null)).withMessageContaining("Combining prefixKey with either minKey or maxKey is not supported.");
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.keysAsList((Ref)this.store().noAncestorHash(), null, ContentKey.of((String[])new String[]{"foo"}), ContentKey.of((String[])new String[]{"foo"}), null)).withMessageContaining("Combining prefixKey with either minKey or maxKey is not supported.");
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.keysAsList((Ref)this.store().noAncestorHash(), ContentKey.of((String[])new String[]{"foo"}), null, ContentKey.of((String[])new String[]{"foo"}), null)).withMessageContaining("Combining prefixKey with either minKey or maxKey is not supported.");
    }

    @Test
    public void entriesRanges() throws Exception {
        Assumptions.assumeThat((String)this.store().getClass().getName()).endsWith((CharSequence)"VersionStoreImpl");
        BranchName branch = BranchName.of((String)"foo");
        ContentKey key1 = ContentKey.of((String[])new String[]{"k1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"k2"});
        ContentKey key2a = ContentKey.of((String[])new String[]{"k2", "a"});
        ContentKey key2b = ContentKey.of((String[])new String[]{"k2", "a\u03c0"});
        ContentKey key2c = ContentKey.of((String[])new String[]{"k2", "\u03c0a"});
        ContentKey key2d = ContentKey.of((String[])new String[]{"k2", "aa"});
        ContentKey key23 = ContentKey.of((String[])new String[]{"k2", "k3"});
        ContentKey key23a = ContentKey.of((String[])new String[]{"k2", "k3", "a"});
        ContentKey key23b = ContentKey.of((String[])new String[]{"k2", "k3", "b"});
        ContentKey key3 = ContentKey.of((String[])new String[]{"k3"});
        this.store().create((NamedRef)branch, Optional.empty()).getHash();
        Hash initialCommit = this.commit("Initial Commit").put(key1, (Content)OnRefOnly.newOnRef("v1")).put(key2, (Content)Namespace.of((ContentKey)key2)).put(key23, (Content)Namespace.of((ContentKey)key23)).put(key2a, (Content)OnRefOnly.newOnRef("v2a")).put(key2b, (Content)OnRefOnly.newOnRef("v2b")).put(key2c, (Content)OnRefOnly.newOnRef("v2c")).put(key2d, (Content)OnRefOnly.newOnRef("v2d")).put(key23a, (Content)OnRefOnly.newOnRef("v23a")).put(key23b, (Content)OnRefOnly.newOnRef("v23b")).put(key3, (Content)OnRefOnly.newOnRef("v3")).toBranch(branch);
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, null, null, null, null)).map(KeyEntry::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{key1, key2, key2a, key2b, key2c, key2d, key23, key23a, key23b, key3});
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, key23, null, null, null)).map(KeyEntry::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{key23, key23a, key23b, key3, key2c});
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, null, null, key23, null)).map(KeyEntry::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{key23, key23a, key23b});
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, null, key23, null, null)).map(KeyEntry::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{key1, key2, key2a, key2b, key2d, key23});
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, key23, key23a, null, null)).map(KeyEntry::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{key23, key23a});
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, null, null, ContentKey.of((String[])new String[]{"k"}), null)).map(KeyEntry::getKey).isEmpty();
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, null, ContentKey.of((String[])new String[]{"k"}), null, null)).map(KeyEntry::getKey).isEmpty();
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, null, null, ContentKey.of((String[])new String[]{"x"}), null)).map(KeyEntry::getKey).isEmpty();
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, null, null, null, k -> k.toPathString().startsWith(key2.toPathString()))).map(KeyEntry::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{key2, key2a, key2b, key2c, key2d, key23, key23a, key23b});
    }

    List<KeyEntry> keysAsList(Ref ref, ContentKey minKey, ContentKey maxKey, ContentKey prefixKey, Predicate<ContentKey> contentKeyPredicate) throws Exception {
        try (PaginationIterator keys = this.store().getKeys(ref, null, false, minKey, maxKey, prefixKey, contentKeyPredicate);){
            ArrayList arrayList = Lists.newArrayList((Iterator)keys);
            return arrayList;
        }
    }
}

