/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.error.ReferenceConflicts;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeConflictException;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.ResultType;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.tests.StorageAssertions;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractMerge
extends AbstractNestedVersionStore {
    public static final BranchName MAIN_BRANCH = BranchName.of((String)"foo");
    @InjectSoftAssertions
    protected SoftAssertions soft;
    private static final OnRefOnly V_1_1 = OnRefOnly.newOnRef("v1_1");
    private static final OnRefOnly V_1_2 = OnRefOnly.newOnRef("v1_2");
    private static final OnRefOnly V_1_4 = OnRefOnly.newOnRef("v1_4");
    private static final OnRefOnly V_2_1 = OnRefOnly.newOnRef("v2_1");
    private static final OnRefOnly V_2_2 = OnRefOnly.newOnRef("v2_2");
    private static final OnRefOnly V_3_1 = OnRefOnly.newOnRef("v3_1");
    private static final OnRefOnly V_4_1 = OnRefOnly.newOnRef("v4_1");
    private static final OnRefOnly V_5_1 = OnRefOnly.newOnRef("v5_1");
    private static final OnRefOnly VALUE_1 = OnRefOnly.newOnRef("value1");
    private static final OnRefOnly VALUE_2 = OnRefOnly.newOnRef("value2");
    private static final OnRefOnly VALUE_3 = OnRefOnly.newOnRef("value3");
    private static final OnRefOnly VALUE_4 = OnRefOnly.newOnRef("value4");
    private static final OnRefOnly VALUE_5 = OnRefOnly.newOnRef("value5");
    private static final OnRefOnly VALUE_6 = OnRefOnly.newOnRef("value6");
    private Hash initialHash;
    private Hash firstCommit;
    private Hash thirdCommit;
    private List<Commit> commits;

    protected AbstractMerge(VersionStore store) {
        super(store);
    }

    @BeforeEach
    protected void setupCommits() throws VersionStoreException {
        this.store().create((NamedRef)MAIN_BRANCH, Optional.empty());
        this.initialHash = this.commit("Default common ancestor").toBranch(MAIN_BRANCH);
        this.firstCommit = this.commit("First Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).put("t3", (Content)V_3_1).toBranch(MAIN_BRANCH);
        Content t1 = this.store().getValue((Ref)MAIN_BRANCH, ContentKey.of((String[])new String[]{"t1"})).content();
        this.commit("Second Commit").put("t1", (Content)V_1_2.withId(t1)).delete("t2").delete("t3").put("t4", (Content)V_4_1).toBranch(MAIN_BRANCH);
        this.thirdCommit = this.commit("Third Commit").put("t2", (Content)V_2_2).unchanged("t4").toBranch(MAIN_BRANCH);
        this.commits = this.commitsList((Ref)MAIN_BRANCH, false).subList(0, 3);
    }

    private MetadataRewriter<CommitMeta> createMetadataRewriter(final String suffix) {
        return new MetadataRewriter<CommitMeta>(){

            public CommitMeta rewriteSingle(CommitMeta metadata) {
                return CommitMeta.fromMessage((String)(metadata.getMessage() + suffix));
            }

            public CommitMeta squash(List<CommitMeta> metadata) {
                return CommitMeta.fromMessage((String)metadata.stream().map(cm -> cm.getMessage() + suffix).collect(Collectors.joining("\n-----------------------------------\n")));
            }
        };
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeKeyBehaviorValidation(boolean dryRun) throws Exception {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isTrue();
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        BranchName targetBranch = BranchName.of((String)"mergeKeyBehaviorValidation");
        this.store().create((NamedRef)targetBranch, Optional.of(this.firstCommit));
        ContentKey keyNotUsed = ContentKey.of((String[])new String[]{"not", "used"});
        ContentKey keyUnused = ContentKey.of((String[])new String[]{"un", "used"});
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((NamedRef)MAIN_BRANCH, this.thirdCommit, targetBranch, Optional.empty(), metadataRewriter, false, (Map)ImmutableMap.of((Object)keyNotUsed, (Object)MergeKeyBehavior.of((ContentKey)keyNotUsed, (MergeBehavior)MergeBehavior.DROP), (Object)keyUnused, (Object)MergeKeyBehavior.of((ContentKey)keyUnused, (MergeBehavior)MergeBehavior.DROP)), MergeBehavior.NORMAL, dryRun, false)).withMessage("Not all merge key behaviors specified in the request have been used. The following keys were not used: [not.used, un.used]");
        ContentKey keyT3 = ContentKey.of((String[])new String[]{"t3"});
        for (MergeBehavior mergeBehavior : new MergeBehavior[]{MergeBehavior.DROP, MergeBehavior.FORCE}) {
            this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((NamedRef)MAIN_BRANCH, this.thirdCommit, targetBranch, Optional.empty(), metadataRewriter, false, (Map)ImmutableMap.of((Object)keyT3, (Object)MergeKeyBehavior.of((ContentKey)keyT3, (MergeBehavior)mergeBehavior, (Content)V_3_1, (Content)V_1_1)), MergeBehavior.NORMAL, dryRun, false)).withMessage("MergeKeyBehavior.resolvedContent must be null for MergeBehavior.%s for t3", new Object[]{mergeBehavior});
        }
        Content c11 = this.store().getValue((Ref)this.firstCommit, ContentKey.of((String[])new String[]{"t1"})).content();
        for (MergeBehavior mergeBehavior : new MergeBehavior[]{MergeBehavior.NORMAL, MergeBehavior.FORCE}) {
            StorageAssertions checkpoint = this.storageCheckpoint();
            ((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((NamedRef)MAIN_BRANCH, this.thirdCommit, targetBranch, Optional.empty(), metadataRewriter, false, (Map)ImmutableMap.of((Object)keyT3, (Object)MergeKeyBehavior.of((ContentKey)keyT3, (MergeBehavior)mergeBehavior, (Content)c11, null)), MergeBehavior.NORMAL, dryRun, false)).describedAs("MergeBehavior.%s", new Object[]{mergeBehavior})).hasMessage("The following keys have been changed in conflict: 't3'").asInstanceOf(InstanceOfAssertFactories.type(MergeConflictException.class))).extracting(MergeConflictException::getMergeResult).extracting(new Function[]{MergeResult::wasApplied, MergeResult::wasSuccessful, r -> r.getDetails().get(keyT3)}).containsExactly(new Object[]{false, false, MergeResult.KeyDetails.keyDetails((MergeBehavior)mergeBehavior, (Conflict)Conflict.conflict((Conflict.ConflictType)Conflict.ConflictType.VALUE_DIFFERS, (ContentKey)keyT3, (String)"values of existing and expected content for key 't3' are different"))});
            checkpoint.assertNoWrites();
            this.soft.assertAll();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeResolveConflict(boolean individualCommits) throws VersionStoreException {
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        BranchName sourceBranch = BranchName.of((String)"mergeResolveConflict");
        this.store().create((NamedRef)sourceBranch, Optional.of(this.thirdCommit));
        ContentKey key2 = ContentKey.of((String[])new String[]{"t2"});
        Content contentT2 = this.store().getValue((Ref)MAIN_BRANCH, key2).content();
        Hash targetHead = this.commit("on-target-commit").put("t2", (Content)OnRefOnly.onRef("v2_2-target", contentT2.getId())).toBranch(MAIN_BRANCH);
        Hash sourceHead = this.commit("on-source-commit").put("t2", (Content)OnRefOnly.onRef("v2_2-source", contentT2.getId())).toBranch(sourceBranch);
        contentT2 = this.store().getValue((Ref)MAIN_BRANCH, key2).content();
        this.soft.assertThatThrownBy(() -> this.store().merge((NamedRef)sourceBranch, sourceHead, MAIN_BRANCH, Optional.empty(), metadataRewriter, individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, false)).isInstanceOf(MergeConflictException.class);
        OnRefOnly resolvedContent = OnRefOnly.onRef("resolved", contentT2.getId());
        OnRefOnly wrongExpectedContent = OnRefOnly.onRef("wrong", contentT2.getId());
        if (!this.isNewStorageModel()) {
            this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((NamedRef)sourceBranch, sourceHead, MAIN_BRANCH, Optional.empty(), metadataRewriter, individualCommits, Collections.singletonMap(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.NORMAL, (Content)wrongExpectedContent, (Content)resolvedContent)), MergeBehavior.NORMAL, false, false)).withMessage("MergeKeyBehavior.resolvedContent and MergeKeyBehavior.expectedTargetContent are not supported for this storage model");
            return;
        }
        if (individualCommits) {
            this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((NamedRef)sourceBranch, sourceHead, MAIN_BRANCH, Optional.empty(), metadataRewriter, individualCommits, Collections.singletonMap(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.NORMAL, (Content)wrongExpectedContent, (Content)resolvedContent)), MergeBehavior.NORMAL, false, false)).withMessage("MergeKeyBehavior.expectedTargetContent and MergeKeyBehavior.resolvedContent are only supported for squashing merge/transplant operations.");
            return;
        }
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((NamedRef)sourceBranch, sourceHead, MAIN_BRANCH, Optional.empty(), metadataRewriter, individualCommits, Collections.singletonMap(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.NORMAL, (Content)wrongExpectedContent, (Content)resolvedContent)), MergeBehavior.NORMAL, false, false)).isInstanceOf(ReferenceConflictException.class)).asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).containsExactly((Object[])new Conflict[]{Conflict.conflict((Conflict.ConflictType)Conflict.ConflictType.VALUE_DIFFERS, (ContentKey)key2, (String)"values of existing and expected content for key 't2' are different")});
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((NamedRef)sourceBranch, sourceHead, MAIN_BRANCH, Optional.empty(), metadataRewriter, individualCommits, Collections.singletonMap(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.NORMAL, null, (Content)resolvedContent)), MergeBehavior.NORMAL, false, false)).withMessage("MergeKeyBehavior.resolvedContent requires setting MergeKeyBehavior.expectedTarget as well for key t2");
        MergeResult result = this.store().merge((NamedRef)sourceBranch, sourceHead, MAIN_BRANCH, Optional.empty(), metadataRewriter, individualCommits, Collections.singletonMap(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.NORMAL, (Content)contentT2, (Content)resolvedContent)), MergeBehavior.NORMAL, false, false);
        ReferenceInfo branch = this.store().getNamedRef(MAIN_BRANCH.getName(), GetNamedRefsParams.DEFAULT);
        this.soft.assertThat((Object)result).extracting(new Function[]{MergeResult::wasApplied, MergeResult::wasSuccessful, MergeResult::getResultantTargetHash, MergeResult::getCommonAncestor, MergeResult::getEffectiveTargetHash}).containsExactly(new Object[]{true, true, branch.getHash(), this.thirdCommit, targetHead});
        Content mergedContent = this.store().getValue((Ref)MAIN_BRANCH, key2).content();
        this.soft.assertThat((Object)mergedContent).isEqualTo((Object)resolvedContent);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoEmptyBranch3Commits(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"mergeIntoEmptyBranch3Commits");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        this.doMergeIntoEmpty(individualCommits, newBranch, metadataRewriter, true);
        if (individualCommits) {
            this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)newBranch, Optional.empty())).isEqualTo((Object)this.thirdCommit);
            AbstractMerge.assertCommitMeta(this.soft, this.commitsList((Ref)newBranch, false).subList(0, 3), this.commits, metadataRewriter);
        } else {
            Assertions.assertThat((Object)this.store().hashOnReference((NamedRef)newBranch, Optional.empty())).isNotEqualTo((Object)this.thirdCommit);
            ((ObjectAssert)this.soft.assertThat(this.commitsList((Ref)newBranch, false)).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).asString().contains((CharSequence[])this.commits.stream().map(Commit::getCommitMeta).map(CommitMeta::getMessage).toArray(String[]::new));
        }
    }

    private void doMergeIntoEmpty(boolean individualCommits, BranchName newBranch, MetadataRewriter<CommitMeta> metadataRewriter, boolean expectFastForward) throws ReferenceNotFoundException, ReferenceConflictException {
        MergeResult result = this.store().merge((NamedRef)MAIN_BRANCH, this.thirdCommit, newBranch, Optional.of(this.initialHash), metadataRewriter, individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
        this.checkAddedCommits(individualCommits, this.initialHash, (MergeResult<Commit>)result, expectFastForward);
        this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}), ContentKey.of((String[])new String[]{"t4"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{"t4"}), (Object)((Object)V_4_1)));
    }

    private void checkAddedCommits(boolean individualCommits, Hash targetHead, MergeResult<Commit> result, boolean expectFastForward) {
        if (individualCommits) {
            if (expectFastForward) {
                this.soft.assertThat(result.getCreatedCommits()).isEmpty();
            } else {
                ((ListAssert)this.soft.assertThat(result.getCreatedCommits()).hasSize(3)).satisfiesExactly(new ThrowingConsumer[]{c -> {
                    this.soft.assertThat((Object)c.getParentHash()).isEqualTo((Object)targetHead);
                    this.soft.assertThat(c.getCommitMeta().getMessage()).contains(new CharSequence[]{"First Commit"});
                    ((ListAssert)this.soft.assertThat(c.getOperations()).hasSize(3)).satisfiesExactlyInAnyOrder(new ThrowingConsumer[]{o -> {
                        this.soft.assertThat(o).isInstanceOf(Put.class);
                        this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t1"}));
                        this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_1_1);
                    }, o -> {
                        this.soft.assertThat(o).isInstanceOf(Put.class);
                        this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t2"}));
                        this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_2_1);
                    }, o -> {
                        this.soft.assertThat(o).isInstanceOf(Put.class);
                        this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t3"}));
                        this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_3_1);
                    }});
                }, c -> {
                    this.soft.assertThat((Object)c.getParentHash()).isEqualTo((Object)((Commit)result.getCreatedCommits().get(0)).getHash());
                    this.soft.assertThat(c.getCommitMeta().getMessage()).contains(new CharSequence[]{"Second Commit"});
                    ((ListAssert)this.soft.assertThat(c.getOperations()).hasSize(4)).satisfiesExactlyInAnyOrder(new ThrowingConsumer[]{o -> {
                        this.soft.assertThat(o).isInstanceOf(Put.class);
                        this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t1"}));
                        this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_1_2);
                    }, o -> ((ObjectAssert)this.soft.assertThat(o).asInstanceOf(InstanceOfAssertFactories.type(Delete.class))).extracting(Operation::getKey).isEqualTo((Object)ContentKey.of((String[])new String[]{"t2"})), o -> ((ObjectAssert)this.soft.assertThat(o).asInstanceOf(InstanceOfAssertFactories.type(Delete.class))).extracting(Operation::getKey).isEqualTo((Object)ContentKey.of((String[])new String[]{"t3"})), o -> {
                        this.soft.assertThat(o).isInstanceOf(Put.class);
                        this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t4"}));
                        this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_4_1);
                    }});
                }, c -> {
                    this.soft.assertThat((Object)c.getParentHash()).isEqualTo((Object)((Commit)result.getCreatedCommits().get(1)).getHash());
                    this.soft.assertThat(c.getCommitMeta().getMessage()).contains(new CharSequence[]{"Third Commit"});
                    ((ListAssert)this.soft.assertThat(c.getOperations()).hasSize(1)).satisfiesExactlyInAnyOrder(new ThrowingConsumer[]{o -> {
                        this.soft.assertThat(o).isInstanceOf(Put.class);
                        this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t2"}));
                        this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_2_2);
                    }});
                }});
            }
        } else {
            ((ObjectAssert)this.soft.assertThat(result.getCreatedCommits()).singleElement()).satisfies(new ThrowingConsumer[]{c -> {
                this.soft.assertThat((Object)c.getParentHash()).isEqualTo((Object)targetHead);
                ((StringAssert)((StringAssert)this.soft.assertThat(c.getCommitMeta().getMessage()).contains(new CharSequence[]{"First Commit"})).contains(new CharSequence[]{"Second Commit"})).contains(new CharSequence[]{"Third Commit"});
                ((ListAssert)((ListAssert)((ListAssert)((ListAssert)this.soft.assertThat(c.getOperations()).hasSizeBetween(3, 4)).anySatisfy(o -> {
                    if (c.getOperations() != null && c.getOperations().size() == 4) {
                        this.soft.assertThat(o).isInstanceOf(Delete.class);
                        this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t3"}));
                    }
                })).anySatisfy(o -> {
                    this.soft.assertThat(o).isInstanceOf(Put.class);
                    this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t1"}));
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_1_2);
                })).anySatisfy(o -> {
                    this.soft.assertThat(o).isInstanceOf(Put.class);
                    this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t2"}));
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_2_2);
                })).anySatisfy(o -> {
                    this.soft.assertThat(o).isInstanceOf(Put.class);
                    this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t4"}));
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_4_1);
                });
            }});
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void compareDryAndEffectiveMergeResults(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"compareDryAndEffectiveMergeResults");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        Hash origHead = this.store().getNamedRef(newBranch.getName(), GetNamedRefsParams.DEFAULT).getHash();
        MergeResult dryMergeResult = this.store().merge((NamedRef)MAIN_BRANCH, this.firstCommit, newBranch, Optional.of(this.initialHash), metadataRewriter, individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, true, true);
        this.soft.assertThat((Object)dryMergeResult).extracting(new Function[]{MergeResult::wasApplied, MergeResult::wasSuccessful, MergeResult::getCommonAncestor, MergeResult::getTargetBranch, MergeResult::getEffectiveTargetHash, MergeResult::getExpectedHash}).containsExactly(new Object[]{false, true, this.initialHash, newBranch, this.initialHash, this.initialHash});
        this.soft.assertThat((Object)this.store().getNamedRef(newBranch.getName(), GetNamedRefsParams.DEFAULT).getHash()).isEqualTo((Object)origHead);
        MergeResult mergeResult = this.store().merge((NamedRef)MAIN_BRANCH, this.firstCommit, newBranch, Optional.of(this.initialHash), metadataRewriter, individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, true);
        Hash head = this.store().getNamedRef(newBranch.getName(), GetNamedRefsParams.DEFAULT).getHash();
        this.soft.assertThat((Object)head).isNotEqualTo((Object)origHead);
        this.soft.assertThat(mergeResult.getSourceCommits()).satisfiesAnyOf(new ThrowingConsumer[]{l -> Assertions.assertThat((List)l).isEmpty(), l -> Assertions.assertThat((List)l).extracting(new Function[]{Commit::getHash, c -> c.getCommitMeta().getMessage(), c -> AbstractMerge.operationsWithoutContentId(c.getOperations())}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{this.firstCommit, "First Commit", Arrays.asList(Put.of((ContentKey)ContentKey.of((String[])new String[]{"t1"}), (Content)V_1_1), Put.of((ContentKey)ContentKey.of((String[])new String[]{"t2"}), (Content)V_2_1), Put.of((ContentKey)ContentKey.of((String[])new String[]{"t3"}), (Content)V_3_1))})})});
        this.soft.assertThat(mergeResult.getTargetCommits()).isNull();
        this.soft.assertThat(mergeResult.getCreatedCommits()).isEmpty();
        this.soft.assertThat(mergeResult.getDetails()).containsKeys((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"})});
        ((ObjectAssert)this.soft.assertThat((Object)mergeResult).isEqualTo((Object)MergeResult.builder().resultType(ResultType.MERGE).sourceRef((NamedRef)MAIN_BRANCH).wasApplied(true).wasSuccessful(true).commonAncestor(this.initialHash).resultantTargetHash(head).targetBranch(newBranch).effectiveTargetHash(this.initialHash).expectedHash(this.initialHash).addAllSourceCommits((Iterable)mergeResult.getSourceCommits()).addAllCreatedCommits((Iterable)mergeResult.getCreatedCommits()).putAllDetails(mergeResult.getDetails()).build())).isEqualTo((Object)MergeResult.builder().from(dryMergeResult).wasApplied(true).resultantTargetHash(mergeResult.getResultantTargetHash()).build());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoEmptyBranch1Commit(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"mergeIntoEmptyBranch1Commit");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        MergeResult result = this.store().merge((NamedRef)MAIN_BRANCH, this.firstCommit, newBranch, Optional.of(this.initialHash), metadataRewriter, individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
        this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}), ContentKey.of((String[])new String[]{"t4"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_1), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_1), (Object)ContentKey.of((String[])new String[]{"t3"}), (Object)((Object)V_3_1)));
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)newBranch, Optional.empty())).isEqualTo((Object)this.firstCommit);
        this.soft.assertThat(result.getCreatedCommits()).isEmpty();
        List<Commit> mergedCommit = this.commitsList((Ref)newBranch, false).subList(0, 1);
        AbstractMerge.assertCommitMeta(this.soft, mergedCommit, this.commits.subList(2, 3), metadataRewriter);
        ((ListAssert)this.soft.assertThat((Object)mergedCommit.get(0)).extracting(Commit::getCommitMeta).extracting(CommitMeta::getParentCommitHashes).asInstanceOf(InstanceOfAssertFactories.list(Hash.class))).hasSize(1);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoEmptyBranchModifying(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"mergeIntoEmptyBranchModifying");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter(", merged");
        this.doMergeIntoEmpty(individualCommits, newBranch, metadataRewriter, false);
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)newBranch, Optional.empty())).isNotEqualTo((Object)this.thirdCommit);
        List<Commit> mergedCommits = this.commitsList((Ref)newBranch, false);
        if (individualCommits) {
            AbstractMerge.assertCommitMeta(this.soft, mergedCommits.subList(0, 3), this.commits, metadataRewriter);
        } else {
            ((ObjectAssert)this.soft.assertThat(mergedCommits).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).asString().contains((CharSequence[])this.commits.stream().map(Commit::getCommitMeta).map(CommitMeta::getMessage).toArray(String[]::new));
            ((ListAssert)((ObjectAssert)this.soft.assertThat(mergedCommits).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getParentCommitHashes).asInstanceOf(InstanceOfAssertFactories.list(String.class))).containsExactly((Object[])new String[]{mergedCommits.get(1).getHash().asString(), this.commits.get(0).getHash().asString()});
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoNonConflictingBranch(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_2");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        Hash newCommit = this.commit("Unrelated commit").put("t5", (Content)V_5_1).toBranch(newBranch);
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        MergeResult result = this.store().merge((NamedRef)MAIN_BRANCH, this.thirdCommit, newBranch, Optional.empty(), metadataRewriter, individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
        this.soft.assertThat((Object)result.getResultantTargetHash()).isNotEqualTo((Object)this.thirdCommit);
        this.soft.assertThat(result.getSourceCommits()).satisfiesAnyOf(new ThrowingConsumer[]{l -> Assertions.assertThat((List)l).isEmpty(), l -> Assertions.assertThat((List)l).hasSize(3)});
        this.soft.assertThat((Object)result).extracting(new Function[]{MergeResult::getCommonAncestor, MergeResult::wasSuccessful, MergeResult::wasApplied}).containsExactly(new Object[]{this.initialHash, true, true});
        this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}), ContentKey.of((String[])new String[]{"t4"}), ContentKey.of((String[])new String[]{"t5"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{"t4"}), (Object)((Object)V_4_1), (Object)ContentKey.of((String[])new String[]{"t5"}), (Object)((Object)V_5_1)));
        List<Commit> commits = this.commitsList((Ref)newBranch, false);
        if (individualCommits) {
            this.soft.assertThat(commits).satisfiesExactly(new ThrowingConsumer[]{c0 -> Assertions.assertThat((Object)c0).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).isEqualTo((Object)"Third Commit"), c1 -> Assertions.assertThat((Object)c1).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).isEqualTo((Object)"Second Commit"), c2 -> Assertions.assertThat((Object)c2).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).isEqualTo((Object)"First Commit"), c3 -> Assertions.assertThat((Object)c3).extracting(Commit::getHash).isEqualTo((Object)newCommit), c4 -> Assertions.assertThat((Object)c4).extracting(Commit::getHash).isEqualTo((Object)this.initialHash)});
        } else {
            this.soft.assertThat(commits).satisfiesExactly(new ThrowingConsumer[]{c0 -> Assertions.assertThat((Object)c0).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).asString().contains(new CharSequence[]{"Third Commit", "Second Commit", "First Commit"}), c3 -> Assertions.assertThat((Object)c3).extracting(Commit::getHash).isEqualTo((Object)newCommit), c4 -> Assertions.assertThat((Object)c4).extracting(Commit::getHash).isEqualTo((Object)this.initialHash)});
        }
        if (individualCommits) {
            ((ListAssert)this.soft.assertThat(result.getCreatedCommits()).hasSize(3)).satisfiesExactly(new ThrowingConsumer[]{commit -> {
                this.soft.assertThat((Object)commit.getParentHash()).isEqualTo((Object)newCommit);
                this.soft.assertThat(commit.getCommitMeta().getMessage()).isEqualTo("First Commit");
            }, commit -> {
                this.soft.assertThat((Object)commit.getParentHash()).isEqualTo((Object)((Commit)result.getCreatedCommits().get(0)).getHash());
                this.soft.assertThat(commit.getCommitMeta().getMessage()).isEqualTo("Second Commit");
            }, commit -> {
                this.soft.assertThat((Object)commit.getParentHash()).isEqualTo((Object)((Commit)result.getCreatedCommits().get(1)).getHash());
                this.soft.assertThat(commit.getCommitMeta().getMessage()).isEqualTo("Third Commit");
            }});
        } else {
            ((ObjectAssert)this.soft.assertThat(result.getCreatedCommits()).singleElement()).extracting(Commit::getParentHash).isEqualTo((Object)newCommit);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void nonEmptyFastForwardMerge(boolean individualCommits) throws VersionStoreException {
        ContentKey key = ContentKey.of((String[])new String[]{"t1"});
        BranchName etl = BranchName.of((String)"etl");
        BranchName review = BranchName.of((String)"review");
        this.store().create((NamedRef)etl, Optional.of(this.initialHash));
        this.store().create((NamedRef)review, Optional.of(this.initialHash));
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        CommitResult etl1 = this.store().commit(etl, Optional.empty(), CommitMeta.fromMessage((String)"commit 1"), Collections.singletonList(Put.of((ContentKey)key, (Content)VALUE_1)));
        Content v = this.store().getValue((Ref)etl, key).content();
        MergeResult mergeResult1 = this.store().merge((NamedRef)etl, this.store().hashOnReference((NamedRef)etl, Optional.empty()), review, Optional.empty(), metadataRewriter, individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
        this.soft.assertThat((Object)mergeResult1.getResultantTargetHash()).isEqualTo((Object)etl1.getCommitHash());
        this.soft.assertThat(mergeResult1.getCreatedCommits()).isEmpty();
        CommitResult etl2 = this.store().commit(etl, Optional.empty(), CommitMeta.fromMessage((String)"commit 2"), Collections.singletonList(Put.of((ContentKey)key, (Content)VALUE_2.withId(v))));
        MergeResult mergeResult2 = this.store().merge((NamedRef)etl, this.store().hashOnReference((NamedRef)etl, Optional.empty()), review, Optional.empty(), metadataRewriter, individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
        this.soft.assertThat((Object)mergeResult2.getResultantTargetHash()).isEqualTo((Object)etl2.getCommitHash());
        this.soft.assertThat(mergeResult2.getCreatedCommits()).isEmpty();
        this.soft.assertThat((Object)AbstractMerge.contentWithoutId(this.store().getValue((Ref)review, key))).isEqualTo((Object)VALUE_2);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeWithCommonAncestor(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_2");
        this.store().create((NamedRef)newBranch, Optional.of(this.firstCommit));
        Hash newCommit = this.commit("Unrelated commit").put("t5", (Content)V_5_1).toBranch(newBranch);
        MetadataRewriter<CommitMeta> metadataRewriter = this.createMetadataRewriter("");
        MergeResult result = this.store().merge((NamedRef)MAIN_BRANCH, this.thirdCommit, newBranch, Optional.empty(), metadataRewriter, individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
        this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}), ContentKey.of((String[])new String[]{"t4"}), ContentKey.of((String[])new String[]{"t5"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{"t4"}), (Object)((Object)V_4_1), (Object)ContentKey.of((String[])new String[]{"t5"}), (Object)((Object)V_5_1)));
        List<Commit> commits = this.commitsList((Ref)newBranch, true);
        if (individualCommits) {
            ((ListAssert)this.soft.assertThat(commits).hasSize(5)).satisfiesExactly(new ThrowingConsumer[]{c -> Assertions.assertThat((String)c.getCommitMeta().getMessage()).isEqualTo("Third Commit"), c -> Assertions.assertThat((String)c.getCommitMeta().getMessage()).isEqualTo("Second Commit"), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)newCommit), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)this.firstCommit), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)this.initialHash)});
            ((ListAssert)this.soft.assertThat(result.getCreatedCommits()).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{c -> Assertions.assertThat((Object)c).isEqualTo(commits.get(1)), c -> Assertions.assertThat((Object)c).isEqualTo(commits.get(0))});
        } else {
            ((ListAssert)this.soft.assertThat(commits).hasSize(4)).satisfiesExactly(new ThrowingConsumer[]{c -> Assertions.assertThat((String)c.getCommitMeta().getMessage()).contains(new CharSequence[]{"Second Commit", "Third Commit"}), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)newCommit), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)this.firstCommit), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)this.initialHash)});
            ((ObjectAssert)this.soft.assertThat(result.getCreatedCommits()).singleElement()).isEqualTo((Object)commits.get(0));
            ((ListAssert)((ObjectAssert)this.soft.assertThat(commits).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getParentCommitHashes).asInstanceOf(InstanceOfAssertFactories.list(String.class))).containsExactly((Object[])new String[]{newCommit.asString(), this.thirdCommit.asString()});
        }
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "false,true", "true,false", "true,true"})
    protected void mergeWithConflictingKeys(boolean individualCommits, boolean dryRun) throws VersionStoreException {
        BranchName mergeInto = BranchName.of((String)"foofoo");
        BranchName mergeFrom = BranchName.of((String)"barbar");
        this.store().create((NamedRef)mergeInto, Optional.of(this.initialHash));
        this.store().create((NamedRef)mergeFrom, Optional.of(this.initialHash));
        ContentKey conflictingKey1 = ContentKey.of((String[])new String[]{"some_key1"});
        ContentKey conflictingKey2 = ContentKey.of((String[])new String[]{"some_key2"});
        ContentKey key3 = ContentKey.of((String[])new String[]{"some_key3"});
        ContentKey key4 = ContentKey.of((String[])new String[]{"some_key4"});
        this.store().commit(mergeInto, Optional.empty(), CommitMeta.fromMessage((String)"commit 1"), Collections.singletonList(Put.of((ContentKey)conflictingKey1, (Content)VALUE_1)));
        this.store().commit(mergeFrom, Optional.empty(), CommitMeta.fromMessage((String)"commit 2"), Arrays.asList(Put.of((ContentKey)conflictingKey1, (Content)VALUE_2), Put.of((ContentKey)key3, (Content)VALUE_5)));
        Hash mergeIntoHead = this.store().commit(mergeInto, Optional.empty(), CommitMeta.fromMessage((String)"commit 3"), Arrays.asList(Put.of((ContentKey)conflictingKey2, (Content)VALUE_3), Put.of((ContentKey)key4, (Content)VALUE_6))).getCommitHash();
        Hash mergeFromHash = this.store().commit(mergeFrom, Optional.empty(), CommitMeta.fromMessage((String)"commit 4"), Collections.singletonList(Put.of((ContentKey)conflictingKey2, (Content)VALUE_4))).getCommitHash();
        StorageAssertions checkpoint = this.storageCheckpoint();
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((NamedRef)mergeFrom, mergeFromHash, mergeInto, Optional.empty(), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, dryRun, false)).isInstanceOf(ReferenceConflictException.class)).hasMessageContaining("The following keys have been changed in conflict:").hasMessageContaining(conflictingKey1.toString()).hasMessageContaining(conflictingKey2.toString());
        if (dryRun) {
            checkpoint.assertNoWrites();
        }
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((NamedRef)mergeFrom, mergeFromHash, mergeInto, Optional.empty(), this.createMetadataRewriter(""), individualCommits, Collections.singletonMap(conflictingKey2, MergeKeyBehavior.of((ContentKey)conflictingKey2, (MergeBehavior)MergeBehavior.DROP)), MergeBehavior.NORMAL, dryRun, false)).isInstanceOf(ReferenceConflictException.class)).hasMessageContaining("The following keys have been changed in conflict:").hasMessageContaining(conflictingKey1.toString()).hasMessageNotContaining(conflictingKey2.toString());
        if (dryRun) {
            checkpoint.assertNoWrites();
        }
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((NamedRef)mergeFrom, mergeFromHash, mergeInto, Optional.empty(), this.createMetadataRewriter(""), individualCommits, Collections.singletonMap(conflictingKey1, MergeKeyBehavior.of((ContentKey)conflictingKey1, (MergeBehavior)MergeBehavior.NORMAL)), MergeBehavior.DROP, dryRun, false)).isInstanceOf(ReferenceConflictException.class)).hasMessageContaining("The following keys have been changed in conflict:").hasMessageContaining(conflictingKey1.toString()).hasMessageNotContaining(conflictingKey2.toString());
        if (dryRun) {
            checkpoint.assertNoWrites();
        }
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((NamedRef)mergeFrom, mergeFromHash, mergeInto, Optional.empty(), this.createMetadataRewriter(""), individualCommits, Collections.singletonMap(conflictingKey1, MergeKeyBehavior.of((ContentKey)conflictingKey1, (MergeBehavior)MergeBehavior.FORCE)), MergeBehavior.NORMAL, dryRun, false)).isInstanceOf(ReferenceConflictException.class)).hasMessageContaining("The following keys have been changed in conflict:").hasMessageNotContaining(conflictingKey1.toString()).hasMessageContaining(conflictingKey2.toString());
        if (dryRun) {
            checkpoint.assertNoWrites();
        }
        Supplier<Hash> mergeIntoHeadSupplier = () -> {
            try {
                return this.store.getNamedRef(mergeInto.getName(), GetNamedRefsParams.DEFAULT).getHash();
            }
            catch (ReferenceNotFoundException e) {
                throw new RuntimeException(e);
            }
        };
        this.soft.assertThat((Object)mergeIntoHeadSupplier.get()).isEqualTo((Object)mergeIntoHead);
        MergeResult result = this.store().merge((NamedRef)mergeFrom, mergeFromHash, mergeInto, Optional.empty(), this.createMetadataRewriter(", merge-force-1"), individualCommits, (Map)ImmutableMap.of((Object)conflictingKey1, (Object)MergeKeyBehavior.of((ContentKey)conflictingKey1, (MergeBehavior)MergeBehavior.FORCE), (Object)conflictingKey2, (Object)MergeKeyBehavior.of((ContentKey)conflictingKey2, (MergeBehavior)MergeBehavior.DROP)), MergeBehavior.NORMAL, false, false);
        ((MapAssert)((MapAssert)((MapAssert)this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store.getValues((Ref)mergeIntoHeadSupplier.get(), Arrays.asList(conflictingKey1, conflictingKey2, key3, key4)))).containsEntry((Object)conflictingKey1, (Object)VALUE_2)).containsEntry((Object)conflictingKey2, (Object)VALUE_3)).containsEntry((Object)key3, (Object)VALUE_5)).containsEntry((Object)key4, (Object)VALUE_6);
        ((ObjectAssert)this.soft.assertThat(result.getCreatedCommits()).singleElement()).satisfies(new ThrowingConsumer[]{commit -> {
            if (individualCommits) {
                this.soft.assertThat(commit.getCommitMeta().getMessage()).isEqualTo("commit 2, merge-force-1");
            } else {
                ((StringAssert)this.soft.assertThat(commit.getCommitMeta().getMessage()).contains(new CharSequence[]{"commit 2, merge-force-1"})).contains(new CharSequence[]{"commit 4, merge-force-1"});
            }
            this.soft.assertThat((Object)commit.getParentHash()).isEqualTo((Object)mergeIntoHead);
            this.soft.assertThat(commit.getOperations()).satisfiesExactlyInAnyOrder(new ThrowingConsumer[]{op -> {
                this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)conflictingKey1);
                this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_2);
            }, op -> {
                this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)key3);
                this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_5);
            }});
        }});
        this.store().assign((NamedRef)mergeInto, Optional.empty(), mergeIntoHead);
        MergeResult result2 = this.store().merge((NamedRef)mergeFrom, mergeFromHash, mergeInto, Optional.empty(), this.createMetadataRewriter(", merge-all-force"), individualCommits, Collections.emptyMap(), MergeBehavior.FORCE, false, false);
        ((MapAssert)((MapAssert)((MapAssert)this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store.getValues((Ref)mergeIntoHeadSupplier.get(), Arrays.asList(conflictingKey1, conflictingKey2, key3, key4)))).containsEntry((Object)conflictingKey1, (Object)VALUE_2)).containsEntry((Object)conflictingKey2, (Object)VALUE_4)).containsEntry((Object)key3, (Object)VALUE_5)).containsEntry((Object)key4, (Object)VALUE_6);
        if (individualCommits) {
            ((ListAssert)this.soft.assertThat(result2.getCreatedCommits()).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{commit -> {
                this.soft.assertThat(commit.getCommitMeta().getMessage()).isEqualTo("commit 2, merge-all-force");
                this.soft.assertThat((Object)commit.getParentHash()).isEqualTo((Object)mergeIntoHead);
                this.soft.assertThat(commit.getOperations()).satisfiesExactlyInAnyOrder(new ThrowingConsumer[]{op -> {
                    this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)conflictingKey1);
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_2);
                }, op -> {
                    this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)key3);
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_5);
                }});
            }, commit -> {
                this.soft.assertThat(commit.getCommitMeta().getMessage()).isEqualTo("commit 4, merge-all-force");
                this.soft.assertThat((Object)commit.getParentHash()).isEqualTo((Object)((Commit)result2.getCreatedCommits().get(0)).getHash());
                ((ObjectAssert)this.soft.assertThat(commit.getOperations()).singleElement()).satisfies(new ThrowingConsumer[]{op -> {
                    this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)conflictingKey2);
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_4);
                }});
            }});
        } else {
            ((ObjectAssert)this.soft.assertThat(result2.getCreatedCommits()).singleElement()).satisfies(new ThrowingConsumer[]{commit -> {
                ((StringAssert)this.soft.assertThat(commit.getCommitMeta().getMessage()).contains(new CharSequence[]{"commit 2, merge-all-force"})).contains(new CharSequence[]{"commit 4, merge-all-force"});
                this.soft.assertThat((Object)commit.getParentHash()).isEqualTo((Object)mergeIntoHead);
                this.soft.assertThat(commit.getOperations()).satisfiesExactlyInAnyOrder(new ThrowingConsumer[]{op -> {
                    this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)conflictingKey1);
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_2);
                }, op -> {
                    this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)conflictingKey2);
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_4);
                }, op -> {
                    this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)key3);
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_5);
                }});
            }});
        }
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "false,true", "true,false", "true,true"})
    protected void mergeIntoConflictingBranch(boolean individualCommits, boolean dryRun) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_3");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        this.commit("Another commit").put("t1", (Content)V_1_4).toBranch(newBranch);
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().merge((NamedRef)MAIN_BRANCH, this.thirdCommit, newBranch, Optional.of(this.initialHash), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, dryRun, false)).isInstanceOf(ReferenceConflictException.class);
        if (dryRun) {
            checkpoint.assertNoWrites();
        }
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "false,true", "true,false", "true,true"})
    protected void mergeIntoNonExistingBranch(boolean individualCommits, boolean dryRun) {
        BranchName newBranch = BranchName.of((String)"bar_5");
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().merge((NamedRef)MAIN_BRANCH, this.thirdCommit, newBranch, Optional.of(this.initialHash), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, dryRun, false)).isInstanceOf(ReferenceNotFoundException.class);
        checkpoint.assertNoWrites();
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "false,true", "true,false", "true,true"})
    protected void mergeIntoNonExistingReference(boolean individualCommits, boolean dryRun) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_6");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().merge((NamedRef)MAIN_BRANCH, Hash.of((String)"1234567890abcdef"), newBranch, Optional.of(this.initialHash), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, dryRun, false)).isInstanceOf(ReferenceNotFoundException.class);
        checkpoint.assertNoWrites();
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "false,true", "true,false", "true,true"})
    protected void mergeEmptyCommit(boolean individualCommits, boolean dryRun) throws VersionStoreException {
        BranchName source = BranchName.of((String)"source");
        BranchName target = BranchName.of((String)"target");
        this.store().create((NamedRef)source, Optional.of(this.initialHash));
        this.store().create((NamedRef)target, Optional.of(this.initialHash));
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
        Hash targetHead = this.store().commit(target, Optional.empty(), CommitMeta.fromMessage((String)"target 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)VALUE_1))).getCommitHash();
        targetHead = this.store().commit(target, Optional.of(targetHead), CommitMeta.fromMessage((String)"target 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)VALUE_1))).getCommitHash();
        Hash sourceHead = this.store().commit(source, Optional.empty(), CommitMeta.fromMessage((String)"source 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)VALUE_2))).getCommitHash();
        sourceHead = this.store().commit(source, Optional.of(sourceHead), CommitMeta.fromMessage((String)"source 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)VALUE_2))).getCommitHash();
        this.store().merge((NamedRef)source, sourceHead, target, Optional.ofNullable(targetHead), this.createMetadataRewriter(", merge-drop"), individualCommits, (Map)ImmutableMap.of((Object)key1, (Object)MergeKeyBehavior.of((ContentKey)key1, (MergeBehavior)MergeBehavior.DROP), (Object)key2, (Object)MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.DROP)), MergeBehavior.NORMAL, dryRun, false);
        try (PaginationIterator iterator = this.store().getCommits((Ref)target, true);){
            Hash newTargetHead = ((Commit)iterator.next()).getHash();
            Assertions.assertThat((Object)newTargetHead).isEqualTo((Object)targetHead);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void mergeFromAndIntoHead(boolean dryRun) throws Exception {
        BranchName branch = BranchName.of((String)"source");
        this.store().create((NamedRef)branch, Optional.of(this.initialHash));
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
        Hash commit1 = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"commit 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)VALUE_1))).getCommitHash();
        Hash commit2 = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"commit 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)VALUE_2))).getCommitHash();
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((NamedRef)branch, commit2, branch, Optional.of(commit1), this.createMetadataRewriter(""), false, Collections.emptyMap(), MergeBehavior.NORMAL, dryRun, false));
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((NamedRef)branch, commit1, branch, Optional.of(commit2), this.createMetadataRewriter(""), false, Collections.emptyMap(), MergeBehavior.NORMAL, dryRun, false));
    }
}

