/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.tests.AbstractVersionStoreTestBase;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractMergeKeyBehaviors
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;
    static ContentKey keyInitial = ContentKey.of((String[])new String[]{"initial"});
    static ContentKey keyTarget1 = ContentKey.of((String[])new String[]{"target1"});
    static ContentKey keySource1 = ContentKey.of((String[])new String[]{"source1"});
    static ContentKey keyCommon1 = ContentKey.of((String[])new String[]{"common1"});
    static ContentKey keyCommon2 = ContentKey.of((String[])new String[]{"common2"});
    static IcebergTable initialTable = IcebergTable.of((String)"initial", (long)1L, (int)2, (int)3, (int)4);
    static IcebergTable targetTable1 = IcebergTable.of((String)"target1", (long)1L, (int)2, (int)3, (int)4);
    static IcebergTable sourceTable1 = IcebergTable.of((String)"source1", (long)1L, (int)2, (int)3, (int)4);
    static IcebergTable commonTable1onTarget = IcebergTable.of((String)"common1onTarget", (long)1L, (int)2, (int)3, (int)4);
    static IcebergTable commonTable2onTarget = IcebergTable.of((String)"common2onTarget", (long)1L, (int)2, (int)3, (int)4);
    static IcebergTable commonTable1onSource = IcebergTable.of((String)"common1onSource", (long)1L, (int)2, (int)3, (int)4);
    static IcebergTable commonTable2onSource = IcebergTable.of((String)"common2onSource", (long)1L, (int)2, (int)3, (int)4);

    protected AbstractMergeKeyBehaviors(VersionStore store) {
        super(store);
    }

    static Stream<Arguments> mergeKeyBehavior() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{ImmutableMap.of((Object)keyCommon1, (Object)MergeKeyBehavior.of((ContentKey)keyCommon1, (MergeBehavior)MergeBehavior.DROP), (Object)keyCommon2, (Object)MergeKeyBehavior.of((ContentKey)keyCommon2, (MergeBehavior)MergeBehavior.DROP)), MergeBehavior.NORMAL, ImmutableMap.of((Object)keyInitial, (Object)initialTable, (Object)keyTarget1, (Object)targetTable1, (Object)keySource1, (Object)sourceTable1, (Object)keyCommon1, (Object)commonTable1onTarget, (Object)keyCommon2, (Object)commonTable2onTarget)}), Arguments.arguments((Object[])new Object[]{ImmutableMap.of((Object)keyCommon1, (Object)MergeKeyBehavior.of((ContentKey)keyCommon1, (MergeBehavior)MergeBehavior.FORCE), (Object)keyCommon2, (Object)MergeKeyBehavior.of((ContentKey)keyCommon2, (MergeBehavior)MergeBehavior.FORCE)), MergeBehavior.NORMAL, ImmutableMap.of((Object)keyInitial, (Object)initialTable, (Object)keyTarget1, (Object)targetTable1, (Object)keySource1, (Object)sourceTable1, (Object)keyCommon1, (Object)commonTable1onSource, (Object)keyCommon2, (Object)commonTable2onSource)}), Arguments.arguments((Object[])new Object[]{ImmutableMap.of((Object)keyCommon1, (Object)MergeKeyBehavior.of((ContentKey)keyCommon1, (MergeBehavior)MergeBehavior.DROP), (Object)keyCommon2, (Object)MergeKeyBehavior.of((ContentKey)keyCommon2, (MergeBehavior)MergeBehavior.FORCE)), MergeBehavior.NORMAL, ImmutableMap.of((Object)keyInitial, (Object)initialTable, (Object)keyTarget1, (Object)targetTable1, (Object)keySource1, (Object)sourceTable1, (Object)keyCommon1, (Object)commonTable1onTarget, (Object)keyCommon2, (Object)commonTable2onSource)}), Arguments.arguments((Object[])new Object[]{ImmutableMap.of((Object)keyCommon1, (Object)MergeKeyBehavior.of((ContentKey)keyCommon1, (MergeBehavior)MergeBehavior.DROP), (Object)keyCommon2, (Object)MergeKeyBehavior.of((ContentKey)keyCommon2, (MergeBehavior)MergeBehavior.DROP)), MergeBehavior.NORMAL, ImmutableMap.of((Object)keyInitial, (Object)initialTable, (Object)keyTarget1, (Object)targetTable1, (Object)keySource1, (Object)sourceTable1, (Object)keyCommon1, (Object)commonTable1onTarget, (Object)keyCommon2, (Object)commonTable2onTarget)}), Arguments.arguments((Object[])new Object[]{ImmutableMap.of((Object)keyCommon1, (Object)MergeKeyBehavior.of((ContentKey)keyCommon1, (MergeBehavior)MergeBehavior.FORCE), (Object)keyCommon2, (Object)MergeKeyBehavior.of((ContentKey)keyCommon2, (MergeBehavior)MergeBehavior.FORCE)), MergeBehavior.NORMAL, ImmutableMap.of((Object)keyInitial, (Object)initialTable, (Object)keyTarget1, (Object)targetTable1, (Object)keySource1, (Object)sourceTable1, (Object)keyCommon1, (Object)commonTable1onSource, (Object)keyCommon2, (Object)commonTable2onSource)}), Arguments.arguments((Object[])new Object[]{ImmutableMap.of((Object)keyCommon1, (Object)MergeKeyBehavior.of((ContentKey)keyCommon1, (MergeBehavior)MergeBehavior.DROP), (Object)keyCommon2, (Object)MergeKeyBehavior.of((ContentKey)keyCommon2, (MergeBehavior)MergeBehavior.FORCE), (Object)keySource1, (Object)MergeKeyBehavior.of((ContentKey)keySource1, (MergeBehavior)MergeBehavior.DROP)), MergeBehavior.NORMAL, ImmutableMap.of((Object)keyInitial, (Object)initialTable, (Object)keyTarget1, (Object)targetTable1, (Object)keyCommon1, (Object)commonTable1onTarget, (Object)keyCommon2, (Object)commonTable2onSource)}), Arguments.arguments((Object[])new Object[]{ImmutableMap.of((Object)keyCommon1, (Object)MergeKeyBehavior.of((ContentKey)keyCommon1, (MergeBehavior)MergeBehavior.DROP), (Object)keyCommon2, (Object)MergeKeyBehavior.of((ContentKey)keyCommon2, (MergeBehavior)MergeBehavior.FORCE)), MergeBehavior.DROP, ImmutableMap.of((Object)keyInitial, (Object)initialTable, (Object)keyTarget1, (Object)targetTable1, (Object)keyCommon1, (Object)commonTable1onTarget, (Object)keyCommon2, (Object)commonTable2onSource)}), Arguments.arguments((Object[])new Object[]{ImmutableMap.of(), MergeBehavior.FORCE, ImmutableMap.of((Object)keyInitial, (Object)initialTable, (Object)keyTarget1, (Object)targetTable1, (Object)keySource1, (Object)sourceTable1, (Object)keyCommon1, (Object)commonTable1onSource, (Object)keyCommon2, (Object)commonTable2onSource)}), Arguments.arguments((Object[])new Object[]{ImmutableMap.of((Object)keySource1, (Object)MergeKeyBehavior.of((ContentKey)keySource1, (MergeBehavior)MergeBehavior.DROP)), MergeBehavior.FORCE, ImmutableMap.of((Object)keyInitial, (Object)initialTable, (Object)keyTarget1, (Object)targetTable1, (Object)keyCommon1, (Object)commonTable1onSource, (Object)keyCommon2, (Object)commonTable2onSource)}));
    }

    @ParameterizedTest
    @MethodSource(value={"mergeKeyBehavior"})
    void mergeKeyBehavior(Map<ContentKey, MergeKeyBehavior> mergeKeyBehaviors, MergeBehavior defaultMergeBehavior, Map<ContentKey, Content> expectedContentsAfter) throws Exception {
        BranchName targetName = BranchName.of((String)"target");
        Hash target = this.store().create((NamedRef)targetName, Optional.empty()).getHash();
        List<ContentKey> allKeys = Arrays.asList(keyInitial, keyTarget1, keySource1, keyCommon1, keyCommon2);
        target = this.store().commit(targetName, Optional.of(target), CommitMeta.fromMessage((String)"initial"), Collections.singletonList(Put.of((ContentKey)keyInitial, (Content)initialTable))).getCommitHash();
        BranchName sourceName = BranchName.of((String)"source");
        Hash source = this.store().create((NamedRef)sourceName, Optional.of(target)).getHash();
        target = this.store().commit(targetName, Optional.of(target), CommitMeta.fromMessage((String)"target 2"), Arrays.asList(Put.of((ContentKey)keyTarget1, (Content)targetTable1), Put.of((ContentKey)keyCommon1, (Content)commonTable1onTarget), Put.of((ContentKey)keyCommon2, (Content)commonTable2onTarget))).getCommitHash();
        source = this.store().commit(sourceName, Optional.of(source), CommitMeta.fromMessage((String)"source 2"), Arrays.asList(Put.of((ContentKey)keySource1, (Content)sourceTable1), Put.of((ContentKey)keyCommon1, (Content)commonTable1onSource), Put.of((ContentKey)keyCommon2, (Content)commonTable2onSource))).getCommitHash();
        MergeResult mergeResult = this.store().merge((NamedRef)sourceName, source, targetName, Optional.of(target), AbstractVersionStoreTestBase.METADATA_REWRITER, false, mergeKeyBehaviors, defaultMergeBehavior, false, false);
        this.soft.assertThat((Object)mergeResult).extracting(new Function[]{MergeResult::wasApplied, MergeResult::wasSuccessful}).containsExactly(new Object[]{true, true});
        this.soft.assertThat((Object)mergeResult.getResultantTargetHash()).isNotEqualTo((Object)target);
        target = mergeResult.getResultantTargetHash();
        Map<ContentKey, Content> contentsOnTargetAfter = this.store().getValues((Ref)target, allKeys).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ImmutableIcebergTable)((ContentResult)e.getValue()).content()).withId(null)));
        this.soft.assertThat(contentsOnTargetAfter).containsExactlyInAnyOrderEntriesOf(expectedContentsAfter);
    }
}

