/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.tests.AbstractVersionStoreTestBase;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractNoNamespaceValidation {
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected abstract VersionStore store();

    @Test
    void commit() throws Exception {
        BranchName branch = BranchName.of((String)"noNamespaceValidation");
        this.store().create((NamedRef)branch, Optional.empty());
        this.soft.assertThatCode(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"commit"), Collections.singletonList(Put.of((ContentKey)ContentKey.of((String[])new String[]{"name", "spaced", "table"}), (Content)OnRefOnly.newOnRef("foo"))))).doesNotThrowAnyException();
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "false,true", "true,false", "true,true"})
    void mergeTransplant(boolean merge, boolean individual) throws Exception {
        BranchName root = BranchName.of((String)"root");
        BranchName branch = BranchName.of((String)"branch");
        this.store().create((NamedRef)root, Optional.empty());
        CommitResult rootHead = this.store().commit(root, Optional.empty(), CommitMeta.fromMessage((String)"common ancestor"), Collections.singletonList(Put.of((ContentKey)ContentKey.of((String[])new String[]{"dummy"}), (Content)OnRefOnly.newOnRef("dummy"))));
        this.store().create((NamedRef)branch, Optional.of(rootHead.getCommitHash()));
        this.soft.assertThatCode(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"commit"), Collections.singletonList(Put.of((ContentKey)ContentKey.of((String[])new String[]{"name", "spaced", "table"}), (Content)OnRefOnly.newOnRef("foo"))))).doesNotThrowAnyException();
        Hash commit1 = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        this.soft.assertThatCode(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"commit"), Collections.singletonList(Put.of((ContentKey)ContentKey.of((String[])new String[]{"another", "table"}), (Content)OnRefOnly.newOnRef("bar"))))).doesNotThrowAnyException();
        Hash commit2 = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        this.soft.assertThatCode(() -> {
            if (merge) {
                this.store().merge((NamedRef)branch, commit2, root, Optional.empty(), AbstractVersionStoreTestBase.METADATA_REWRITER, individual, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
            } else {
                this.store().transplant((NamedRef)branch, root, Optional.empty(), Arrays.asList(commit1, commit2), AbstractVersionStoreTestBase.METADATA_REWRITER, individual, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
            }
        }).doesNotThrowAnyException();
    }
}

