/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Streams;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceCreatedResult;
import org.projectnessie.versioned.ReferenceDeletedResult;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractReferences
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected AbstractReferences(VersionStore store) {
        super(store);
    }

    @Test
    public void createAndDeleteBranch() throws Exception {
        List namedRefs;
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash hash = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        this.soft.assertThat((Object)hash).isNotNull();
        BranchName anotherBranch = BranchName.of((String)"bar");
        ReferenceCreatedResult referenceCreatedResult = this.store().create((NamedRef)anotherBranch, Optional.of(hash));
        this.soft.assertThat((Object)referenceCreatedResult.getHash()).isEqualTo((Object)hash);
        this.soft.assertThat((Object)referenceCreatedResult.getNamedRef()).isEqualTo((Object)anotherBranch);
        Hash commitHash = this.commit("Some Commit").toBranch(anotherBranch);
        this.soft.assertThat((Object)commitHash).isNotEqualTo((Object)referenceCreatedResult.getHash());
        BranchName anotherAnotherBranch = BranchName.of((String)"baz");
        referenceCreatedResult = this.store().create((NamedRef)anotherAnotherBranch, Optional.of(commitHash));
        this.soft.assertThat((Object)referenceCreatedResult.getHash()).isEqualTo((Object)commitHash);
        this.soft.assertThat((Object)referenceCreatedResult.getNamedRef()).isEqualTo((Object)anotherAnotherBranch);
        try (PaginationIterator str = this.store().getNamedRefs(GetNamedRefsParams.DEFAULT, null);){
            namedRefs = Streams.stream((Iterator)str).filter(this::filterMainBranch).collect(Collectors.toList());
        }
        this.soft.assertThat(namedRefs).containsExactlyInAnyOrder((Object[])new ReferenceInfo[]{ReferenceInfo.of((Hash)hash, (NamedRef)branch), ReferenceInfo.of((Hash)commitHash, (NamedRef)anotherBranch), ReferenceInfo.of((Hash)commitHash, (NamedRef)anotherAnotherBranch)});
        this.soft.assertThat(this.commitsList((Ref)branch, false)).isEmpty();
        this.soft.assertThat(this.commitsList((Ref)anotherBranch, false)).hasSize(1);
        this.soft.assertThat(this.commitsList((Ref)anotherAnotherBranch, false)).hasSize(1);
        this.soft.assertThat(this.commitsList((Ref)hash, false)).isEmpty();
        this.soft.assertThat(this.commitsList((Ref)commitHash, false)).hasSize(1);
        this.soft.assertThatThrownBy(() -> this.store().create((NamedRef)branch, Optional.empty())).isInstanceOf(ReferenceAlreadyExistsException.class);
        this.soft.assertThatThrownBy(() -> this.store().create((NamedRef)branch, Optional.of(hash))).isInstanceOf(ReferenceAlreadyExistsException.class);
        ReferenceDeletedResult referenceDeletedResult = this.store().delete((NamedRef)branch, Optional.of(hash));
        this.soft.assertThat((Object)referenceDeletedResult.getHash()).isEqualTo((Object)hash);
        this.soft.assertThat((Object)referenceDeletedResult.getNamedRef()).isEqualTo((Object)branch);
        this.soft.assertThatThrownBy(() -> this.store().hashOnReference((NamedRef)branch, Optional.empty())).isInstanceOf(ReferenceNotFoundException.class);
        try (PaginationIterator str = this.store().getNamedRefs(GetNamedRefsParams.DEFAULT, null);){
            this.soft.assertThat(Streams.stream((Iterator)str).filter(this::filterMainBranch)).hasSize(2);
        }
        this.soft.assertThatThrownBy(() -> this.store().delete((NamedRef)branch, Optional.of(hash))).isInstanceOf(ReferenceNotFoundException.class);
    }

    @Test
    public void createAndDeleteTag() throws Exception {
        List namedRefs;
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash initialHash = this.store().hashOnReference((NamedRef)branch, Optional.empty());
        Hash commitHash = this.commit("Some commit").toBranch(branch);
        TagName tag = TagName.of((String)"tag");
        ReferenceCreatedResult referenceCreatedResult = this.store().create((NamedRef)tag, Optional.of(initialHash));
        this.soft.assertThat((Object)referenceCreatedResult.getHash()).isEqualTo((Object)initialHash);
        this.soft.assertThat((Object)referenceCreatedResult.getNamedRef()).isEqualTo((Object)tag);
        TagName anotherTag = TagName.of((String)"another-tag");
        referenceCreatedResult = this.store().create((NamedRef)anotherTag, Optional.of(commitHash));
        this.soft.assertThat((Object)referenceCreatedResult.getHash()).isEqualTo((Object)commitHash);
        this.soft.assertThat((Object)referenceCreatedResult.getNamedRef()).isEqualTo((Object)anotherTag);
        this.soft.assertThatThrownBy(() -> this.store().create((NamedRef)tag, Optional.of(initialHash))).isInstanceOf(ReferenceAlreadyExistsException.class);
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)tag, Optional.empty())).isEqualTo((Object)initialHash);
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)anotherTag, Optional.empty())).isEqualTo((Object)commitHash);
        try (PaginationIterator str = this.store().getNamedRefs(GetNamedRefsParams.DEFAULT, null);){
            namedRefs = Streams.stream((Iterator)str).filter(this::filterMainBranch).collect(Collectors.toList());
        }
        this.soft.assertThat(namedRefs).containsExactlyInAnyOrder((Object[])new ReferenceInfo[]{ReferenceInfo.of((Hash)commitHash, (NamedRef)branch), ReferenceInfo.of((Hash)initialHash, (NamedRef)tag), ReferenceInfo.of((Hash)commitHash, (NamedRef)anotherTag)});
        this.soft.assertThat(this.commitsList((Ref)tag, false)).isEmpty();
        this.soft.assertThat(this.commitsList((Ref)initialHash, false)).isEmpty();
        this.soft.assertThat(this.commitsList((Ref)anotherTag, false)).hasSize(1);
        this.soft.assertThat(this.commitsList((Ref)commitHash, false)).hasSize(1);
        ReferenceDeletedResult referenceDeletedResult = this.store().delete((NamedRef)tag, Optional.of(initialHash));
        this.soft.assertThat((Object)referenceDeletedResult.getHash()).isEqualTo((Object)initialHash);
        this.soft.assertThat((Object)referenceDeletedResult.getNamedRef()).isEqualTo((Object)tag);
        this.soft.assertThatThrownBy(() -> this.store().hashOnReference((NamedRef)tag, Optional.empty())).isInstanceOf(ReferenceNotFoundException.class);
        try (PaginationIterator str = this.store().getNamedRefs(GetNamedRefsParams.DEFAULT, null);){
            this.soft.assertThat(Streams.stream((Iterator)str).filter(this::filterMainBranch)).hasSize(2);
        }
        this.soft.assertThatThrownBy(() -> this.store().delete((NamedRef)tag, Optional.of(initialHash))).isInstanceOf(ReferenceNotFoundException.class);
    }

    @Test
    void getNamedRef() throws VersionStoreException {
        BranchName branch = BranchName.of((String)"getNamedRef");
        Hash hashFromCreate = this.store().create((NamedRef)branch, Optional.empty()).getHash();
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)branch, Optional.empty())).isEqualTo((Object)hashFromCreate);
        Hash firstCommitHash = this.commit("First Commit").toBranch(branch);
        this.soft.assertThat((Object)this.store().getNamedRef(branch.getName(), GetNamedRefsParams.DEFAULT)).extracting(new Function[]{ReferenceInfo::getHash, ReferenceInfo::getNamedRef}).containsExactly(new Object[]{firstCommitHash, branch});
        Hash secondCommitHash = this.commit("Second Commit").toBranch(branch);
        Hash thirdCommitHash = this.commit("Third Commit").toBranch(branch);
        BranchName branchName = BranchName.of((String)("getNamedRef_branch_" + secondCommitHash.asString()));
        TagName tagName = TagName.of((String)("getNamedRef_tag_" + thirdCommitHash.asString()));
        this.store().create((NamedRef)branchName, Optional.of(secondCommitHash));
        this.store().create((NamedRef)tagName, Optional.of(thirdCommitHash));
        this.soft.assertThat((Object)this.store().getNamedRef(branchName.getName(), GetNamedRefsParams.DEFAULT)).extracting(new Function[]{ReferenceInfo::getHash, ReferenceInfo::getNamedRef}).containsExactly(new Object[]{secondCommitHash, branchName});
        this.soft.assertThat((Object)this.store().getNamedRef(tagName.getName(), GetNamedRefsParams.DEFAULT)).extracting(new Function[]{ReferenceInfo::getHash, ReferenceInfo::getNamedRef}).containsExactly(new Object[]{thirdCommitHash, tagName});
        this.soft.assertThat((Object)this.store().getNamedRef(branchName.getName(), GetNamedRefsParams.DEFAULT)).extracting(new Function[]{ReferenceInfo::getHash, ReferenceInfo::getNamedRef}).containsExactly(new Object[]{secondCommitHash, branchName});
        this.soft.assertThatThrownBy(() -> this.store().getNamedRef("unknown-ref", GetNamedRefsParams.DEFAULT)).isInstanceOf(ReferenceNotFoundException.class);
        this.soft.assertThatThrownBy(() -> this.store().getNamedRef("1234567890abcdef", GetNamedRefsParams.DEFAULT)).isInstanceOf(ReferenceNotFoundException.class);
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().getNamedRef(branchName.getName(), (GetNamedRefsParams)GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)"does-not-exist")).branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.BASE_REFERENCE_RELATED_AND_COMMIT_META).build())).isInstanceOf(ReferenceNotFoundException.class)).hasMessageContaining("'does-not-exist");
    }

    @Test
    void listBranchesOrTags() throws Exception {
        HashSet<BranchName> branches = new HashSet<BranchName>();
        HashSet<BranchName> tags = new HashSet<BranchName>();
        for (int i = 0; i < 10; ++i) {
            BranchName r = BranchName.of((String)((char)(97 + i) + "-b"));
            this.store().create((NamedRef)r, Optional.empty());
            branches.add(r);
            r = TagName.of((String)((char)(97 + i) + "-t"));
            this.store().create((NamedRef)r, Optional.empty());
            tags.add(r);
        }
        try (PaginationIterator refs = this.store().getNamedRefs((GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.BARE).tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.OMIT).build(), null);){
            ((AbstractListAssert)this.soft.assertThat((List)Lists.newArrayList((Iterator)refs)).extracting(ReferenceInfo::getNamedRef).hasSize(branches.size() + 1)).containsAll(branches);
        }
        refs = this.store().getNamedRefs((GetNamedRefsParams)GetNamedRefsParams.builder().branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.OMIT).tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.BARE).build(), null);
        try {
            this.soft.assertThat((List)Lists.newArrayList((Iterator)refs)).extracting(ReferenceInfo::getNamedRef).containsExactlyInAnyOrderElementsOf(tags);
        }
        finally {
            if (refs != null) {
                refs.close();
            }
        }
        refs = this.store().getNamedRefs(GetNamedRefsParams.DEFAULT, null);
        try {
            ((AbstractListAssert)((AbstractListAssert)this.soft.assertThat((List)Lists.newArrayList((Iterator)refs)).extracting(ReferenceInfo::getNamedRef).hasSize(branches.size() + tags.size() + 1)).containsAll(branches)).containsAll(tags);
        }
        finally {
            if (refs != null) {
                refs.close();
            }
        }
    }
}

