/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.tests.StorageAssertions;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractTransplant
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;
    private static final String T_1 = "t1";
    private static final String T_2 = "t2";
    private static final String T_3 = "t3";
    private static final String T_4 = "t4";
    private static final String T_5 = "t5";
    private static final OnRefOnly V_1_1 = OnRefOnly.newOnRef("v1_1");
    private static final OnRefOnly V_1_2 = OnRefOnly.newOnRef("v1_2");
    private static final OnRefOnly V_1_4 = OnRefOnly.newOnRef("v1_4");
    private static final OnRefOnly V_2_2 = OnRefOnly.newOnRef("v2_2");
    private static final OnRefOnly V_2_1 = OnRefOnly.newOnRef("v2_1");
    private static final OnRefOnly V_3_1 = OnRefOnly.newOnRef("v3_1");
    private static final OnRefOnly V_4_1 = OnRefOnly.newOnRef("v4_1");
    private static final OnRefOnly V_5_1 = OnRefOnly.newOnRef("v5_1");
    private static final BranchName sourceBranch = BranchName.of((String)"foo");
    private Hash initialHash;
    private Hash firstCommit;
    private Hash secondCommit;
    private Hash thirdCommit;
    private List<Commit> commits;

    protected AbstractTransplant(VersionStore store) {
        super(store);
    }

    private MetadataRewriter<CommitMeta> createMetadataRewriter(final String suffix) {
        return new MetadataRewriter<CommitMeta>(){

            public CommitMeta rewriteSingle(CommitMeta metadata) {
                return CommitMeta.fromMessage((String)metadata.getMessage());
            }

            public CommitMeta squash(List<CommitMeta> metadata) {
                return CommitMeta.fromMessage((String)metadata.stream().map(cm -> cm.getMessage() + suffix).collect(Collectors.joining("\n-----------------------------------\n")));
            }
        };
    }

    @BeforeEach
    protected void setupCommits() throws VersionStoreException {
        this.store().create((NamedRef)sourceBranch, Optional.empty());
        this.initialHash = this.store().hashOnReference((NamedRef)sourceBranch, Optional.empty());
        this.firstCommit = this.commit("Initial Commit").put(T_1, (Content)V_1_1).put(T_2, (Content)V_2_1).put(T_3, (Content)V_3_1).toBranch(sourceBranch);
        Content t1 = this.store().getValue((Ref)sourceBranch, ContentKey.of((String[])new String[]{T_1})).content();
        this.secondCommit = this.commit("Second Commit").put(T_1, (Content)V_1_2.withId(t1)).delete(T_2).delete(T_3).put(T_4, (Content)V_4_1).toBranch(sourceBranch);
        this.thirdCommit = this.commit("Third Commit").put(T_2, (Content)V_2_2).unchanged(T_4).toBranch(sourceBranch);
        this.commits = this.commitsList((Ref)sourceBranch, false);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantOnEmptyBranch(boolean individualCommits) throws VersionStoreException {
        this.checkTransplantOnEmptyBranch(this.createMetadataRewriter(""), individualCommits);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantOnEmptyBranchModify(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = this.checkTransplantOnEmptyBranch(this.createMetadataRewriter(""), individualCommits);
        if (!individualCommits) {
            ((ObjectAssert)Assertions.assertThat(this.commitsList((Ref)newBranch, false)).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).asString().contains((CharSequence[])this.commits.stream().map(Commit::getCommitMeta).map(CommitMeta::getMessage).toArray(String[]::new));
        }
    }

    private BranchName checkTransplantOnEmptyBranch(MetadataRewriter<CommitMeta> commitMetaModify, boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_1");
        Hash targetHead = this.store().create((NamedRef)newBranch, Optional.empty()).getHash();
        MergeResult result = this.store().transplant((NamedRef)sourceBranch, newBranch, Optional.of(this.initialHash), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), commitMetaModify, individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
        if (individualCommits) {
            this.soft.assertThat(result.getCreatedCommits()).isEmpty();
        } else {
            this.checkSquashedCommit(targetHead, (MergeResult<Commit>)result);
        }
        this.soft.assertThat(AbstractTransplant.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{T_1}), ContentKey.of((String[])new String[]{T_2}), ContentKey.of((String[])new String[]{T_3}), ContentKey.of((String[])new String[]{T_4}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{T_1}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{T_2}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{T_4}), (Object)((Object)V_4_1)));
        if (individualCommits) {
            AbstractTransplant.assertCommitMeta(this.soft, this.commitsList((Ref)newBranch, false).subList(0, 3), this.commits, commitMetaModify);
        }
        return newBranch;
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantWithPreviousCommit(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_2");
        this.store().create((NamedRef)newBranch, Optional.empty());
        Hash targetHead = this.commit("Unrelated commit").put(T_5, (Content)V_5_1).toBranch(newBranch);
        MergeResult result = this.store().transplant((NamedRef)sourceBranch, newBranch, Optional.of(this.initialHash), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
        if (individualCommits) {
            this.checkRebasedCommits(targetHead, (MergeResult<Commit>)result);
        } else {
            this.checkSquashedCommit(targetHead, (MergeResult<Commit>)result);
        }
        Assertions.assertThat(AbstractTransplant.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{T_1}), ContentKey.of((String[])new String[]{T_2}), ContentKey.of((String[])new String[]{T_3}), ContentKey.of((String[])new String[]{T_4}), ContentKey.of((String[])new String[]{T_5}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{T_1}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{T_2}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{T_4}), (Object)((Object)V_4_1), (Object)ContentKey.of((String[])new String[]{T_5}), (Object)((Object)V_5_1)));
    }

    private void checkSquashedCommit(Hash targetHead, MergeResult<Commit> result) {
        ((ObjectAssert)this.soft.assertThat(result.getCreatedCommits()).singleElement()).satisfies(new ThrowingConsumer[]{c -> {
            this.soft.assertThat((Object)c.getParentHash()).isEqualTo((Object)targetHead);
            ((StringAssert)((StringAssert)this.soft.assertThat(c.getCommitMeta().getMessage()).contains(new CharSequence[]{"Initial Commit"})).contains(new CharSequence[]{"Second Commit"})).contains(new CharSequence[]{"Third Commit"});
            ((ListAssert)((ListAssert)((ListAssert)((ListAssert)this.soft.assertThat(c.getOperations()).hasSizeBetween(3, 4)).anySatisfy(o -> {
                if (c.getOperations() != null && c.getOperations().size() == 4) {
                    this.soft.assertThat(o).isInstanceOf(Delete.class);
                    this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{T_3}));
                }
            })).anySatisfy(o -> {
                this.soft.assertThat(o).isInstanceOf(Put.class);
                this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{T_1}));
                this.soft.assertThat((Object)AbstractTransplant.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_1_2);
            })).anySatisfy(o -> {
                this.soft.assertThat(o).isInstanceOf(Put.class);
                this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{T_2}));
                this.soft.assertThat((Object)AbstractTransplant.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_2_2);
            })).anySatisfy(o -> {
                this.soft.assertThat(o).isInstanceOf(Put.class);
                this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{T_4}));
                this.soft.assertThat((Object)AbstractTransplant.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_4_1);
            });
        }});
    }

    private void checkRebasedCommits(Hash targetHead, MergeResult<Commit> result) {
        ((ListAssert)this.soft.assertThat(result.getCreatedCommits()).hasSize(3)).satisfiesExactly(new ThrowingConsumer[]{c -> {
            this.soft.assertThat((Object)c.getParentHash()).isEqualTo((Object)targetHead);
            this.soft.assertThat(c.getCommitMeta().getMessage()).isEqualTo("Initial Commit");
            ((ListAssert)this.soft.assertThat(c.getOperations()).hasSize(3)).satisfiesExactlyInAnyOrder(new ThrowingConsumer[]{o -> {
                this.soft.assertThat(o).isInstanceOf(Put.class);
                this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{T_1}));
                this.soft.assertThat((Object)AbstractTransplant.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_1_1);
            }, o -> {
                this.soft.assertThat(o).isInstanceOf(Put.class);
                this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{T_2}));
                this.soft.assertThat((Object)AbstractTransplant.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_2_1);
            }, o -> {
                this.soft.assertThat(o).isInstanceOf(Put.class);
                this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{T_3}));
                this.soft.assertThat((Object)AbstractTransplant.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_3_1);
            }});
        }, c -> {
            this.soft.assertThat((Object)c.getParentHash()).isEqualTo((Object)((Commit)result.getCreatedCommits().get(0)).getHash());
            this.soft.assertThat(c.getCommitMeta().getMessage()).isEqualTo("Second Commit");
            ((ListAssert)this.soft.assertThat(c.getOperations()).hasSize(4)).satisfiesExactlyInAnyOrder(new ThrowingConsumer[]{o -> {
                this.soft.assertThat(o).isInstanceOf(Put.class);
                this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{T_1}));
                this.soft.assertThat((Object)AbstractTransplant.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_1_2);
            }, o -> ((ObjectAssert)this.soft.assertThat(o).asInstanceOf(InstanceOfAssertFactories.type(Delete.class))).extracting(Operation::getKey).isEqualTo((Object)ContentKey.of((String[])new String[]{T_2})), o -> ((ObjectAssert)this.soft.assertThat(o).asInstanceOf(InstanceOfAssertFactories.type(Delete.class))).extracting(Operation::getKey).isEqualTo((Object)ContentKey.of((String[])new String[]{T_3})), o -> {
                this.soft.assertThat(o).isInstanceOf(Put.class);
                this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{T_4}));
                this.soft.assertThat((Object)AbstractTransplant.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_4_1);
            }});
        }, c -> {
            this.soft.assertThat((Object)c.getParentHash()).isEqualTo((Object)((Commit)result.getCreatedCommits().get(1)).getHash());
            this.soft.assertThat(c.getCommitMeta().getMessage()).isEqualTo("Third Commit");
            ((ListAssert)this.soft.assertThat(c.getOperations()).hasSize(1)).satisfiesExactlyInAnyOrder(new ThrowingConsumer[]{o -> {
                this.soft.assertThat(o).isInstanceOf(Put.class);
                this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{T_2}));
                this.soft.assertThat((Object)AbstractTransplant.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_2_2);
            }});
        }});
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "false,true", "true,false", "true,true"})
    protected void checkTransplantWithConflictingCommit(boolean individualCommits, boolean dryRun) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_3");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.commit("Another commit").put(T_1, (Content)V_1_4).toBranch(newBranch);
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().transplant((NamedRef)sourceBranch, newBranch, Optional.of(this.initialHash), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, dryRun, false)).isInstanceOf(ReferenceConflictException.class);
        if (dryRun) {
            checkpoint.assertNoWrites();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantWithDelete(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_4");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.commit("Another commit").put(T_1, (Content)V_1_4).toBranch(newBranch);
        this.commit("Another commit").delete(T_1).toBranch(newBranch);
        this.store().transplant((NamedRef)sourceBranch, newBranch, Optional.of(this.initialHash), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
        this.soft.assertThat(AbstractTransplant.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{T_1}), ContentKey.of((String[])new String[]{T_2}), ContentKey.of((String[])new String[]{T_3}), ContentKey.of((String[])new String[]{T_4}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{T_1}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{T_2}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{T_4}), (Object)((Object)V_4_1)));
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "false,true", "true,false", "true,true"})
    protected void checkTransplantOnNonExistingBranch(boolean individualCommits, boolean dryRun) {
        BranchName newBranch = BranchName.of((String)"bar_5");
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().transplant((NamedRef)sourceBranch, newBranch, Optional.of(this.initialHash), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, dryRun, false)).isInstanceOf(ReferenceNotFoundException.class);
        checkpoint.assertNoWrites();
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "false,true", "true,false", "true,true"})
    protected void checkTransplantWithNonExistingCommit(boolean individualCommits, boolean dryRun) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_6");
        this.store().create((NamedRef)newBranch, Optional.empty());
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().transplant((NamedRef)sourceBranch, newBranch, Optional.of(this.initialHash), Collections.singletonList(Hash.of((String)"1234567890abcdef")), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, dryRun, false)).isInstanceOf(ReferenceNotFoundException.class);
        checkpoint.assertNoWrites();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void checkTransplantWithNoExpectedHash(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_7");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.commit("Another commit").put(T_5, (Content)V_5_1).toBranch(newBranch);
        Content t5 = this.store().getValue((Ref)newBranch, ContentKey.of((String[])new String[]{T_5})).content();
        this.commit("Another commit").put(T_5, (Content)V_1_4.withId(t5)).toBranch(newBranch);
        this.store().transplant((NamedRef)sourceBranch, newBranch, Optional.empty(), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
        this.soft.assertThat(AbstractTransplant.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{T_1}), ContentKey.of((String[])new String[]{T_2}), ContentKey.of((String[])new String[]{T_3}), ContentKey.of((String[])new String[]{T_4}), ContentKey.of((String[])new String[]{T_5}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{T_1}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{T_2}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{T_4}), (Object)((Object)V_4_1), (Object)ContentKey.of((String[])new String[]{T_5}), (Object)((Object)V_1_4)));
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "false,true", "true,false", "true,true"})
    protected void checkTransplantWithCommitsInWrongOrder(boolean individualCommits, boolean dryRun) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_8");
        this.store().create((NamedRef)newBranch, Optional.empty());
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().transplant((NamedRef)sourceBranch, newBranch, Optional.empty(), Arrays.asList(this.secondCommit, this.firstCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, dryRun, false));
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "false,true", "true,false", "true,true"})
    protected void checkInvalidBranchHash(boolean individualCommits, boolean dryRun) throws VersionStoreException {
        BranchName anotherBranch = BranchName.of((String)"bar");
        this.store().create((NamedRef)anotherBranch, Optional.empty());
        Hash unrelatedCommit = this.commit("Another Commit").put(T_1, (Content)V_1_1).put(T_2, (Content)V_2_1).put(T_3, (Content)V_3_1).toBranch(anotherBranch);
        BranchName newBranch = BranchName.of((String)"bar_1");
        this.store().create((NamedRef)newBranch, Optional.empty());
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().transplant((NamedRef)sourceBranch, newBranch, Optional.of(unrelatedCommit), Arrays.asList(this.firstCommit, this.secondCommit, this.thirdCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, dryRun, false)).isInstanceOf(ReferenceNotFoundException.class);
        checkpoint.assertNoWrites();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void transplantBasic(boolean individualCommits) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_2");
        this.store().create((NamedRef)newBranch, Optional.empty());
        Hash targetHead = this.commit("Unrelated commit").put(T_5, (Content)V_5_1).toBranch(newBranch);
        MergeResult result = this.store().transplant((NamedRef)sourceBranch, newBranch, Optional.of(this.initialHash), Arrays.asList(this.firstCommit, this.secondCommit), this.createMetadataRewriter(""), individualCommits, Collections.emptyMap(), MergeBehavior.NORMAL, false, false);
        if (individualCommits) {
            ((ListAssert)this.soft.assertThat(result.getCreatedCommits()).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{c -> {
                this.soft.assertThat((Object)c.getParentHash()).isEqualTo((Object)targetHead);
                this.soft.assertThat(c.getCommitMeta().getMessage()).isEqualTo("Initial Commit");
            }, c -> {
                this.soft.assertThat((Object)c.getParentHash()).isEqualTo((Object)((Commit)result.getCreatedCommits().get(0)).getHash());
                this.soft.assertThat(c.getCommitMeta().getMessage()).isEqualTo("Second Commit");
            }});
        } else {
            ((ObjectAssert)this.soft.assertThat(result.getCreatedCommits()).singleElement()).satisfies(new ThrowingConsumer[]{c -> {
                this.soft.assertThat((Object)c.getParentHash()).isEqualTo((Object)targetHead);
                ((StringAssert)this.soft.assertThat(c.getCommitMeta().getMessage()).contains(new CharSequence[]{"Initial Commit"})).contains(new CharSequence[]{"Second Commit"});
            }});
        }
        this.soft.assertThat(AbstractTransplant.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{T_1}), ContentKey.of((String[])new String[]{T_4}), ContentKey.of((String[])new String[]{T_5}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{T_1}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{T_4}), (Object)((Object)V_4_1), (Object)ContentKey.of((String[])new String[]{T_5}), (Object)((Object)V_5_1)));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void transplantEmptyCommit(boolean individualCommits) throws VersionStoreException {
        BranchName source = BranchName.of((String)"source");
        BranchName target = BranchName.of((String)"target");
        this.store().create((NamedRef)source, Optional.of(this.initialHash));
        this.store().create((NamedRef)target, Optional.of(this.initialHash));
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
        Hash targetHead = this.store().commit(target, Optional.empty(), CommitMeta.fromMessage((String)"target 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)V_1_1))).getCommitHash();
        targetHead = this.store().commit(target, Optional.of(targetHead), CommitMeta.fromMessage((String)"target 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)V_2_1))).getCommitHash();
        Hash source1 = this.store().commit(source, Optional.empty(), CommitMeta.fromMessage((String)"source 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)V_1_2))).getCommitHash();
        Hash source2 = this.store().commit(source, Optional.of(source1), CommitMeta.fromMessage((String)"source 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)V_2_2))).getCommitHash();
        this.store().transplant((NamedRef)source, target, Optional.of(targetHead), Arrays.asList(source1, source2), this.createMetadataRewriter(", merge-drop"), individualCommits, (Map)ImmutableMap.of((Object)key1, (Object)MergeKeyBehavior.of((ContentKey)key1, (MergeBehavior)MergeBehavior.DROP), (Object)key2, (Object)MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.DROP)), MergeBehavior.NORMAL, false, false);
        try (PaginationIterator iterator = this.store().getCommits((Ref)target, true);){
            Hash newTargetHead = ((Commit)iterator.next()).getHash();
            Assertions.assertThat((Object)newTargetHead).isEqualTo((Object)targetHead);
        }
    }
}

