/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.assertj.core.util.Lists;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceAssignedResult;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractAssign
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected AbstractAssign(VersionStore store) {
        super(store);
    }

    @Test
    public void assign() throws VersionStoreException {
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash initialHash = this.store().hashOnReference((NamedRef)branch, Optional.empty(), Collections.emptyList());
        Hash commit = this.commit("Some commit").toBranch(branch);
        this.store().create((NamedRef)BranchName.of((String)"bar"), Optional.of(commit));
        this.store().create((NamedRef)TagName.of((String)"tag1"), Optional.of(commit));
        this.store().create((NamedRef)TagName.of((String)"tag2"), Optional.of(commit));
        this.store().create((NamedRef)TagName.of((String)"tag3"), Optional.of(commit));
        Hash anotherCommit = this.commit("Another commit").toBranch(branch);
        ReferenceAssignedResult referenceAssignedResult = this.store().assign((NamedRef)TagName.of((String)"tag2"), commit, anotherCommit);
        this.soft.assertThat((Object)referenceAssignedResult.getPreviousHash()).isEqualTo((Object)commit);
        this.soft.assertThat((Object)referenceAssignedResult.getCurrentHash()).isEqualTo((Object)anotherCommit);
        this.soft.assertThat((Object)referenceAssignedResult.getNamedRef()).isEqualTo((Object)TagName.of((String)"tag2"));
        referenceAssignedResult = this.store().assign((NamedRef)TagName.of((String)"tag3"), commit, anotherCommit);
        this.soft.assertThat((Object)referenceAssignedResult.getPreviousHash()).isEqualTo((Object)commit);
        this.soft.assertThat((Object)referenceAssignedResult.getCurrentHash()).isEqualTo((Object)anotherCommit);
        this.soft.assertThat((Object)referenceAssignedResult.getNamedRef()).isEqualTo((Object)TagName.of((String)"tag3"));
        this.soft.assertThatThrownBy(() -> this.store().assign((NamedRef)BranchName.of((String)"baz"), commit, anotherCommit)).isInstanceOf(ReferenceNotFoundException.class);
        this.soft.assertThatThrownBy(() -> this.store().assign((NamedRef)TagName.of((String)"unknowon-tag"), commit, anotherCommit)).isInstanceOf(ReferenceNotFoundException.class);
        this.soft.assertThatThrownBy(() -> this.store().assign((NamedRef)TagName.of((String)"tag1"), initialHash, commit)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThatThrownBy(() -> this.store().assign((NamedRef)TagName.of((String)"tag1"), initialHash, anotherCommit)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThatThrownBy(() -> this.store().assign((NamedRef)TagName.of((String)"tag1"), commit, Hash.of((String)"1234567890abcdef"))).isInstanceOf(ReferenceNotFoundException.class);
        this.soft.assertThat(this.commitsList((Ref)branch, false)).contains((Object[])new Commit[]{AbstractAssign.commit(anotherCommit, "Another commit", commit), AbstractAssign.commit(commit, "Some commit", initialHash)});
        this.soft.assertThat(this.commitsList((Ref)BranchName.of((String)"bar"), false)).contains((Object[])new Commit[]{AbstractAssign.commit(commit, "Some commit", initialHash)});
        this.soft.assertThat(this.commitsList((Ref)TagName.of((String)"tag1"), false)).contains((Object[])new Commit[]{AbstractAssign.commit(commit, "Some commit", initialHash)});
        this.soft.assertThat(this.commitsList((Ref)TagName.of((String)"tag2"), false)).contains((Object[])new Commit[]{AbstractAssign.commit(anotherCommit, "Another commit", commit), AbstractAssign.commit(commit, "Some commit", initialHash)});
    }

    @Test
    public void assignReferenceToFreshMain() throws ReferenceNotFoundException, ReferenceAlreadyExistsException, ReferenceConflictException {
        ReferenceInfo main = this.store.getNamedRef("main", GetNamedRefsParams.DEFAULT);
        try (PaginationIterator commits = this.store().getCommits((Ref)main.getHash(), false);){
            this.soft.assertThat((Iterator)commits).isExhausted();
        }
        try (PaginationIterator refs = this.store().getNamedRefs(GetNamedRefsParams.DEFAULT, null);){
            this.soft.assertThat((List)Lists.newArrayList((Iterator)refs)).extracting(r -> r.getNamedRef().getName()).containsExactly((Object[])new String[]{main.getNamedRef().getName()});
        }
        BranchName testBranch = BranchName.of((String)"testBranch");
        Hash testBranchHash = this.store.create((NamedRef)testBranch, Optional.empty()).getHash();
        ReferenceAssignedResult referenceAssignedResult = this.store.assign((NamedRef)testBranch, testBranchHash, main.getHash());
        this.soft.assertThat((Object)referenceAssignedResult.getPreviousHash()).isEqualTo((Object)main.getHash());
        this.soft.assertThat((Object)referenceAssignedResult.getCurrentHash()).isEqualTo((Object)testBranchHash);
        this.soft.assertThat((Object)referenceAssignedResult.getNamedRef()).isEqualTo((Object)testBranch);
        this.soft.assertThat((Object)this.store.getNamedRef(testBranch.getName(), GetNamedRefsParams.DEFAULT).getHash()).isEqualTo((Object)main.getHash());
        TagName testTag = TagName.of((String)"testTag");
        Hash testTagHash = this.store.create((NamedRef)testTag, Optional.empty()).getHash();
        referenceAssignedResult = this.store.assign((NamedRef)testTag, testTagHash, main.getHash());
        this.soft.assertThat((Object)referenceAssignedResult.getPreviousHash()).isEqualTo((Object)main.getHash());
        this.soft.assertThat((Object)referenceAssignedResult.getCurrentHash()).isEqualTo((Object)testTagHash);
        this.soft.assertThat((Object)referenceAssignedResult.getNamedRef()).isEqualTo((Object)testTag);
        this.soft.assertThat((Object)this.store.getNamedRef(testTag.getName(), GetNamedRefsParams.DEFAULT).getHash()).isEqualTo((Object)main.getHash());
    }
}

