/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.error.ReferenceConflicts;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractCommits
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;
    private static final OnRefOnly V_1_1 = OnRefOnly.newOnRef("v1_1");
    private static final OnRefOnly V_1_2 = OnRefOnly.newOnRef("v1_2");
    private static final OnRefOnly V_1_3 = OnRefOnly.newOnRef("v1_3");
    private static final OnRefOnly V_2_1 = OnRefOnly.newOnRef("v2_1");
    private static final OnRefOnly V_2_2 = OnRefOnly.newOnRef("v2_2");
    private static final OnRefOnly V_3_1 = OnRefOnly.newOnRef("v3_1");
    private static final OnRefOnly V_3_2 = OnRefOnly.newOnRef("v3_2");
    private static final OnRefOnly V_4_1 = OnRefOnly.newOnRef("v4_1");
    private static final OnRefOnly NEW_v2_1 = OnRefOnly.newOnRef("new_v2_1");

    protected AbstractCommits(VersionStore store) {
        super(store);
    }

    @Test
    public void commitToBranch() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        Hash createHash = this.store().create((NamedRef)branch, Optional.empty()).getHash();
        Hash initialHash = this.store().hashOnReference((NamedRef)branch, Optional.empty(), Collections.emptyList());
        this.soft.assertThat((Object)createHash).isEqualTo((Object)initialHash);
        CommitResult result = this.store().commit(branch, Optional.of(initialHash), CommitMeta.fromMessage((String)"Some commit"), Collections.emptyList());
        this.soft.assertThat((Object)((Commit)result.getCommit()).getParentHash()).isEqualTo((Object)initialHash);
        this.soft.assertThat(((Commit)result.getCommit()).getOperations()).isNullOrEmpty();
        this.soft.assertThat((Object)result.getTargetBranch()).isEqualTo((Object)branch);
        Hash commitHash0 = result.getCommitHash();
        Hash commitHash = this.store().hashOnReference((NamedRef)branch, Optional.empty(), Collections.emptyList());
        this.soft.assertThat((Object)commitHash).isEqualTo((Object)commitHash0);
        this.soft.assertThat((Object)commitHash).isNotEqualTo((Object)initialHash);
        result = this.store().commit(branch, Optional.of(initialHash), CommitMeta.fromMessage((String)"Another commit"), Collections.emptyList());
        this.soft.assertThat((Object)((Commit)result.getCommit()).getParentHash()).isEqualTo((Object)commitHash);
        this.soft.assertThat(((Commit)result.getCommit()).getOperations()).isNullOrEmpty();
        this.soft.assertThat((Object)result.getTargetBranch()).isEqualTo((Object)branch);
        Hash anotherCommitHash = this.store().hashOnReference((NamedRef)branch, Optional.empty(), Collections.emptyList());
        this.soft.assertThat(this.commitsList((Ref)branch, false)).contains((Object[])new Commit[]{AbstractCommits.commit(anotherCommitHash, "Another commit", commitHash), AbstractCommits.commit(commitHash, "Some commit", initialHash)});
        this.soft.assertThat(this.commitsList((Ref)commitHash, false)).contains((Object[])new Commit[]{AbstractCommits.commit(commitHash, "Some commit", initialHash)});
        this.soft.assertThatThrownBy(() -> this.store().delete((NamedRef)branch, initialHash)).isInstanceOf(ReferenceConflictException.class);
        this.store().delete((NamedRef)branch, anotherCommitHash);
        this.soft.assertThatThrownBy(() -> this.store().hashOnReference((NamedRef)branch, Optional.empty(), Collections.emptyList())).isInstanceOf(ReferenceNotFoundException.class);
        try (PaginationIterator str = this.store().getNamedRefs(GetNamedRefsParams.DEFAULT, null);){
            this.soft.assertThat(Streams.stream((Iterator)str).filter(this::filterMainBranch)).isEmpty();
        }
        this.soft.assertThatThrownBy(() -> this.store().delete((NamedRef)branch, commitHash)).isInstanceOf(ReferenceNotFoundException.class);
    }

    @Test
    public void commitSomeOperations() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        ContentKey keyT1 = ContentKey.of((String[])new String[]{"t1"});
        ContentKey keyT2 = ContentKey.of((String[])new String[]{"t2"});
        ContentKey keyT3 = ContentKey.of((String[])new String[]{"t3"});
        ContentKey keyT4 = ContentKey.of((String[])new String[]{"t4"});
        Hash base = this.store().create((NamedRef)branch, Optional.empty()).getHash();
        Hash initialCommit = this.commit("Initial Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).put("t3", (Content)V_3_1).toBranch(branch);
        Content t1 = this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t1"})).content();
        Hash secondCommit = this.commit("Second Commit").put("t1", (Content)V_1_2.withId(t1.getId())).delete("t2").delete("t3").put("t4", (Content)V_4_1).toBranch(branch);
        Hash thirdCommit = this.commit("Third Commit").put("t2", (Content)V_2_2).unchanged("t4").toBranch(branch);
        this.soft.assertThat(this.commitsList((Ref)branch, false)).contains((Object[])new Commit[]{AbstractCommits.commit(thirdCommit, "Third Commit", secondCommit), AbstractCommits.commit(secondCommit, "Second Commit", initialCommit), AbstractCommits.commit(initialCommit, "Initial Commit", base)});
        try (PaginationIterator keys = this.store().getKeys((Ref)branch, null, false, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS);){
            this.soft.assertThat(Streams.stream((Iterator)keys).map(e -> e.getKey().contentKey())).containsExactlyInAnyOrder((Object[])new ContentKey[]{keyT1, keyT2, keyT4});
        }
        keys = this.store().getKeys((Ref)secondCommit, null, false, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS);
        try {
            this.soft.assertThat(Streams.stream((Iterator)keys).map(e -> e.getKey().contentKey())).containsExactlyInAnyOrder((Object[])new ContentKey[]{keyT1, keyT4});
        }
        finally {
            if (keys != null) {
                keys.close();
            }
        }
        keys = this.store().getKeys((Ref)initialCommit, null, false, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS);
        try {
            this.soft.assertThat(Streams.stream((Iterator)keys).map(e -> e.getKey().contentKey())).containsExactlyInAnyOrder((Object[])new ContentKey[]{keyT1, keyT2, keyT3});
        }
        finally {
            if (keys != null) {
                keys.close();
            }
        }
        this.soft.assertThat(AbstractCommits.contentsWithoutId(this.store().getValues((Ref)secondCommit, Arrays.asList(keyT1, keyT2, keyT3, keyT4)))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)keyT1, (Object)((Object)V_1_2), (Object)keyT4, (Object)((Object)V_4_1)));
        this.soft.assertThat(AbstractCommits.contentsWithoutId(this.store().getValues((Ref)initialCommit, Arrays.asList(keyT1, keyT2, keyT3, keyT4)))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)keyT1, (Object)((Object)V_1_1), (Object)keyT2, (Object)((Object)V_2_1), (Object)keyT3, (Object)((Object)V_3_1)));
        this.soft.assertThat((Object)AbstractCommits.contentWithoutId(this.store().getValue((Ref)branch, keyT1))).isEqualTo((Object)V_1_2);
        this.soft.assertThat((Object)AbstractCommits.contentWithoutId(this.store().getValue((Ref)branch, keyT2))).isEqualTo((Object)V_2_2);
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, keyT3)).isNull();
        this.soft.assertThat((Object)AbstractCommits.contentWithoutId(this.store().getValue((Ref)branch, keyT4))).isEqualTo((Object)V_4_1);
        this.soft.assertThat((Object)AbstractCommits.contentWithoutId(this.store().getValue((Ref)secondCommit, keyT1))).isEqualTo((Object)V_1_2);
        this.soft.assertThat((Object)this.store().getValue((Ref)secondCommit, keyT2)).isNull();
        this.soft.assertThat((Object)this.store().getValue((Ref)secondCommit, keyT3)).isNull();
        this.soft.assertThat((Object)AbstractCommits.contentWithoutId(this.store().getValue((Ref)secondCommit, keyT4))).isEqualTo((Object)V_4_1);
        this.soft.assertThat((Object)AbstractCommits.contentWithoutId(this.store().getValue((Ref)initialCommit, keyT1))).isEqualTo((Object)V_1_1);
        this.soft.assertThat((Object)AbstractCommits.contentWithoutId(this.store().getValue((Ref)initialCommit, keyT2))).isEqualTo((Object)V_2_1);
        this.soft.assertThat((Object)AbstractCommits.contentWithoutId(this.store().getValue((Ref)initialCommit, keyT3))).isEqualTo((Object)V_3_1);
        this.soft.assertThat((Object)this.store().getValue((Ref)initialCommit, keyT4)).isNull();
    }

    @Test
    public void commitNonConflictingOperations() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        Hash base = this.store().create((NamedRef)branch, Optional.empty()).getHash();
        Hash initialCommit = this.commit("Initial Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).put("t3", (Content)V_3_1).toBranch(branch);
        Content t1 = this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t1"})).content();
        Content t3 = this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t3"})).content();
        Hash t1Commit = this.commit("T1 Commit").fromReference(initialCommit).put("t1", (Content)V_1_2.withId(t1.getId())).toBranch(branch);
        t1 = this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t1"})).content();
        Hash t2Commit = this.commit("T2 Commit").fromReference(initialCommit).delete("t2").toBranch(branch);
        Hash t3Commit = this.commit("T3 Commit").fromReference(initialCommit).unchanged("t3").toBranch(branch);
        Hash extraCommit = this.commit("Extra Commit").fromReference(t1Commit).put("t1", (Content)V_1_3.withId(t1.getId())).put("t3", (Content)V_3_2.withId(t3.getId())).toBranch(branch);
        Hash newT2Commit = this.commit("New T2 Commit").fromReference(t2Commit).put("t2", (Content)NEW_v2_1).toBranch(branch);
        this.soft.assertThat(this.commitsList((Ref)branch, false)).contains((Object[])new Commit[]{AbstractCommits.commit(newT2Commit, "New T2 Commit", extraCommit), AbstractCommits.commit(extraCommit, "Extra Commit", t3Commit), AbstractCommits.commit(t3Commit, "T3 Commit", t2Commit), AbstractCommits.commit(t2Commit, "T2 Commit", t1Commit), AbstractCommits.commit(t1Commit, "T1 Commit", initialCommit), AbstractCommits.commit(initialCommit, "Initial Commit", base)});
        try (PaginationIterator keys = this.store().getKeys((Ref)branch, null, false, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS);){
            this.soft.assertThat(Streams.stream((Iterator)keys).map(e -> e.getKey().contentKey())).containsExactlyInAnyOrder((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"})});
        }
        this.soft.assertThat(AbstractCommits.contentsWithoutId(this.store().getValues((Ref)branch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_3), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)NEW_v2_1), (Object)ContentKey.of((String[])new String[]{"t3"}), (Object)((Object)V_3_2)));
        this.soft.assertThat(AbstractCommits.contentsWithoutId(this.store().getValues((Ref)newT2Commit, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_3), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)NEW_v2_1), (Object)ContentKey.of((String[])new String[]{"t3"}), (Object)((Object)V_3_2)));
        this.soft.assertThat(AbstractCommits.contentsWithoutId(this.store().getValues((Ref)extraCommit, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_3), (Object)ContentKey.of((String[])new String[]{"t3"}), (Object)((Object)V_3_2)));
        this.soft.assertThat(AbstractCommits.contentsWithoutId(this.store().getValues((Ref)t3Commit, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{"t3"}), (Object)((Object)V_3_1)));
        this.soft.assertThat(AbstractCommits.contentsWithoutId(this.store().getValues((Ref)t2Commit, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{"t3"}), (Object)((Object)V_3_1)));
        this.soft.assertThat(AbstractCommits.contentsWithoutId(this.store().getValues((Ref)t1Commit, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_1), (Object)ContentKey.of((String[])new String[]{"t3"}), (Object)((Object)V_3_1)));
    }

    @Test
    public void commitConflictingOperationsLegacy() throws Exception {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isFalse();
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash initialCommit = this.commit("Initial Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).toBranch(branch);
        Content t1 = this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t1"})).content();
        this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t2"}));
        Hash secondCommit = this.commit("Second Commit").put("t1", (Content)V_1_2.withId(t1.getId())).delete("t2").put("t3", (Content)V_3_1).toBranch(branch);
        this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t3"}));
        this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t1", (Content)V_1_3).toBranch(branch)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t2", (Content)V_2_2).toBranch(branch)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t3", (Content)V_3_2).toBranch(branch)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).delete("t1").toBranch(branch)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).delete("t2").toBranch(branch)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).delete("t3").toBranch(branch)).isInstanceOf(ReferenceConflictException.class);
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)branch, Optional.empty(), Collections.emptyList())).isEqualTo((Object)secondCommit);
    }

    @Test
    public void commitConflictingOperations() throws Exception {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isTrue();
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash initialCommit = this.commit("Initial Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).toBranch(branch);
        Content t1 = this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t1"})).content();
        Content t2 = this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t2"})).content();
        Hash secondCommit = this.commit("Second Commit").put("t1", (Content)V_1_2.withId(t1.getId())).delete("t2").put("t3", (Content)V_3_1).toBranch(branch);
        Content t3 = this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t3"})).content();
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t1", (Content)V_1_3).toBranch(branch)).isInstanceOf(IllegalArgumentException.class)).hasMessage("New value to update existing key 't1' has no content ID");
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t4", (Content)V_4_1).unchanged("t2").toBranch(branch)).isInstanceOf(ReferenceConflictException.class)).hasMessageEndingWith("Key 't2' does not exist.").asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(new Function[]{Conflict::conflictType, Conflict::key, Conflict::message}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{Conflict.ConflictType.KEY_DOES_NOT_EXIST, ContentKey.of((String[])new String[]{"t2"}), "key 't2' does not exist"})});
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t4", (Content)V_4_1).unchanged("t1").toBranch(branch)).isInstanceOf(ReferenceConflictException.class)).hasMessageEndingWith("Values of existing and expected content for key 't1' are different.").asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(new Function[]{Conflict::conflictType, Conflict::key, Conflict::message}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{Conflict.ConflictType.VALUE_DIFFERS, ContentKey.of((String[])new String[]{"t1"}), "values of existing and expected content for key 't1' are different"})});
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t1", (Content)V_1_3.withId(t1.getId())).toBranch(branch)).isInstanceOf(ReferenceConflictException.class)).hasMessageEndingWith("Values of existing and expected content for key 't1' are different.").asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(new Function[]{Conflict::conflictType, Conflict::key, Conflict::message}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{Conflict.ConflictType.VALUE_DIFFERS, ContentKey.of((String[])new String[]{"t1"}), "values of existing and expected content for key 't1' are different"})});
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t2", (Content)V_2_2.withId(t2.getId())).toBranch(branch)).isInstanceOf(ReferenceConflictException.class)).hasMessageEndingWith("Key 't2' does not exist.").asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(new Function[]{Conflict::conflictType, Conflict::key, Conflict::message}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{Conflict.ConflictType.KEY_DOES_NOT_EXIST, ContentKey.of((String[])new String[]{"t2"}), "key 't2' does not exist"})});
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t3", (Content)V_3_2.withId(t3.getId())).toBranch(branch)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("New value for key 't3' must not have a content ID");
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).put("t3", (Content)V_3_2).toBranch(branch)).isInstanceOf(ReferenceConflictException.class)).hasMessageEndingWith("Key 't3' already exists.").asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(new Function[]{Conflict::conflictType, Conflict::key, Conflict::message}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{Conflict.ConflictType.KEY_EXISTS, ContentKey.of((String[])new String[]{"t3"}), "key 't3' already exists"})});
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).delete("t1").toBranch(branch)).isInstanceOf(ReferenceConflictException.class)).hasMessageEndingWith("Values of existing and expected content for key 't1' are different.").asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(new Function[]{Conflict::conflictType, Conflict::key, Conflict::message}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{Conflict.ConflictType.VALUE_DIFFERS, ContentKey.of((String[])new String[]{"t1"}), "values of existing and expected content for key 't1' are different"})});
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).delete("t2").toBranch(branch)).isInstanceOf(ReferenceConflictException.class)).hasMessageEndingWith("Key 't2' does not exist.").asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(new Function[]{Conflict::conflictType, Conflict::key, Conflict::message}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{Conflict.ConflictType.KEY_DOES_NOT_EXIST, ContentKey.of((String[])new String[]{"t2"}), "key 't2' does not exist"})});
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.commit("Conflicting Commit").fromReference(initialCommit).delete("t3").toBranch(branch)).isInstanceOf(ReferenceConflictException.class)).hasMessageEndingWith("Payload of existing and expected content for key 't3' are different.").asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(new Function[]{Conflict::conflictType, Conflict::key, Conflict::message}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{Conflict.ConflictType.PAYLOAD_DIFFERS, ContentKey.of((String[])new String[]{"t3"}), "payload of existing and expected content for key 't3' are different"})});
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)branch, Optional.empty(), Collections.emptyList())).isEqualTo((Object)secondCommit);
    }

    @Test
    public void forceCommitConflictingOperations() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        this.commit("Initial Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).toBranch(branch);
        Content t1 = this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t1"})).content();
        this.commit("Second Commit").put("t1", (Content)V_1_2.withId(t1.getId())).delete("t2").put("t3", (Content)V_3_1).toBranch(branch);
        Content t3 = this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"t3"})).content();
        Hash putCommit = this.forceCommit("Conflicting Commit").put("t1", (Content)V_1_3.withId(t1.getId())).put("t2", (Content)V_2_2).put("t3", (Content)V_3_2.withId(t3.getId())).toBranch(branch);
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)branch, Optional.empty(), Collections.emptyList())).isEqualTo((Object)putCommit);
        this.soft.assertThat(AbstractCommits.contentsWithoutId(this.store().getValues((Ref)branch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_3), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{"t3"}), (Object)((Object)V_3_2)));
        Hash unchangedCommit = this.commit("Conflicting Commit").unchanged("t1").unchanged("t2").unchanged("t3").toBranch(branch);
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)branch, Optional.empty(), Collections.emptyList())).isEqualTo((Object)unchangedCommit);
        this.soft.assertThat(AbstractCommits.contentsWithoutId(this.store().getValues((Ref)branch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_3), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{"t3"}), (Object)((Object)V_3_2)));
        Hash deleteCommit = this.commit("Conflicting Commit").delete("t1").delete("t2").delete("t3").toBranch(branch);
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)branch, Optional.empty(), Collections.emptyList())).isEqualTo((Object)deleteCommit);
        this.soft.assertThat(this.store().getValues((Ref)branch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"})))).isEmpty();
    }

    @Test
    public void commitDuplicateValues() throws Exception {
        BranchName branch = BranchName.of((String)"dupe-values");
        this.store().create((NamedRef)branch, Optional.empty());
        OnRefOnly foo1 = OnRefOnly.newOnRef("foo");
        OnRefOnly foo2 = OnRefOnly.newOnRef("foo");
        this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"metadata"), (List)ImmutableList.of((Object)this.put("keyA", foo1), (Object)this.put("keyB", foo2)));
        this.soft.assertThat((Object)AbstractCommits.contentWithoutId(this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"keyA"})))).isEqualTo((Object)foo1);
        this.soft.assertThat((Object)AbstractCommits.contentWithoutId(this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"keyB"})))).isEqualTo((Object)foo2);
    }

    @Test
    public void commitWithInvalidBranch() {
        BranchName branch = BranchName.of((String)"unknown");
        this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"New commit"), Collections.emptyList())).isInstanceOf(ReferenceNotFoundException.class);
    }

    @Test
    public void commitWithUnknownReference() throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        BranchName branch = BranchName.of((String)"foo");
        this.store().create((NamedRef)branch, Optional.empty());
        this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.of(Hash.of((String)"1234567890abcdef")), CommitMeta.fromMessage((String)"New commit"), Collections.emptyList())).isInstanceOf(ReferenceNotFoundException.class);
    }

    @Test
    public void commitWithInvalidReference() throws ReferenceNotFoundException, ReferenceConflictException, ReferenceAlreadyExistsException {
        BranchName branch = BranchName.of((String)"foo");
        Hash initialHash = this.store().create((NamedRef)branch, Optional.empty()).getHash();
        Hash commitHash = this.store().commit(branch, Optional.of(initialHash), CommitMeta.fromMessage((String)"Some commit"), Collections.emptyList()).getCommitHash();
        BranchName branch2 = BranchName.of((String)"bar");
        this.store().create((NamedRef)branch2, Optional.empty());
        this.soft.assertThatThrownBy(() -> this.store().commit(branch2, Optional.of(commitHash), CommitMeta.fromMessage((String)"Another commit"), Collections.emptyList())).isInstanceOf(ReferenceNotFoundException.class);
    }

    static Stream<Arguments> renames() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{OperationOrder.DELETE_THEN_PUT, false, false}), Arguments.arguments((Object[])new Object[]{OperationOrder.DELETE_THEN_PUT, false, true}), Arguments.arguments((Object[])new Object[]{OperationOrder.DELETE_THEN_PUT, true, false}), Arguments.arguments((Object[])new Object[]{OperationOrder.DELETE_THEN_PUT, true, true}), Arguments.arguments((Object[])new Object[]{OperationOrder.PUT_THEN_DELETE, false, false}), Arguments.arguments((Object[])new Object[]{OperationOrder.PUT_THEN_DELETE, false, true}), Arguments.arguments((Object[])new Object[]{OperationOrder.PUT_THEN_DELETE, true, false}), Arguments.arguments((Object[])new Object[]{OperationOrder.PUT_THEN_DELETE, true, true}));
    }

    @ParameterizedTest
    @MethodSource(value={"renames"})
    void renames(OperationOrder order, boolean reuseContentKey, boolean reuseContentId) throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        Hash initialHash = this.store().create((NamedRef)branch, Optional.empty()).getHash();
        ContentKey original = ContentKey.of((String[])new String[]{"original"});
        Hash committed = this.store().commit(branch, Optional.of(initialHash), CommitMeta.fromMessage((String)"Some commit"), Collections.singletonList(Put.of((ContentKey)original, (Content)IcebergTable.of((String)"loc", (long)1L, (int)2, (int)3, (int)4)))).getCommitHash();
        Content table = this.store().getValue((Ref)branch, original).content();
        Delete deleteOp = Delete.of((ContentKey)original);
        ContentKey renamed = reuseContentKey ? original : ContentKey.of((String[])new String[]{"renamed"});
        Put putOp = Put.of((ContentKey)renamed, (Content)(reuseContentId ? IcebergTable.of((String)"loc", (long)1L, (int)2, (int)3, (int)4, (String)table.getId()) : IcebergTable.of((String)"loc", (long)1L, (int)2, (int)3, (int)4)));
        List<Operation> ops = order == OperationOrder.PUT_THEN_DELETE ? Arrays.asList(putOp, deleteOp) : Arrays.asList(deleteOp, putOp);
        Throwable error = Assertions.catchThrowable(() -> this.store().commit(branch, Optional.of(committed), CommitMeta.fromMessage((String)"Rename commit"), ops));
        if (reuseContentKey) {
            if (order == OperationOrder.DELETE_THEN_PUT && !reuseContentId && this.isNewStorageModel()) {
                this.soft.assertThat(error).isNull();
            } else {
                ((ThrowableAssert)this.soft.assertThat(error).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Duplicate key");
            }
            this.soft.assertThat(this.store().getValues((Ref)branch, Collections.singletonList(original))).containsKey((Object)original);
        } else {
            this.soft.assertThat(error).isNull();
            ((MapAssert)this.soft.assertThat(this.store().getValues((Ref)branch, Arrays.asList(original, renamed))).containsKey((Object)renamed)).doesNotContainKey((Object)original);
        }
    }

    @Test
    void renameTwice() throws Exception {
        BranchName branch = BranchName.of((String)"main");
        ContentKey key = ContentKey.of((String[])new String[]{"table"});
        ContentKey keyBackup = ContentKey.of((String[])new String[]{"table_backup"});
        ContentKey keyTemp = ContentKey.of((String[])new String[]{"table_tmp"});
        ImmutableList keys = ImmutableList.of((Object)key, (Object)keyTemp, (Object)keyBackup);
        IcebergTable tableOld = IcebergTable.of((String)"old", (long)1L, (int)2, (int)3, (int)4);
        IcebergTable tableNew = IcebergTable.of((String)"new", (long)1L, (int)2, (int)3, (int)4);
        this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"commit"), Collections.singletonList(Put.of((ContentKey)key, (Content)tableOld))).getCommitHash();
        tableOld = (IcebergTable)this.store().getValue((Ref)branch, key).content();
        ((MapAssert)this.soft.assertThat(this.store().getValues((Ref)branch, (Collection)keys).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ContentResult)e.getValue()).content()))).hasSize(1)).containsEntry((Object)key, (Object)tableOld);
        this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"new"), Collections.singletonList(Put.of((ContentKey)keyTemp, (Content)tableNew)));
        tableNew = (IcebergTable)this.store().getValue((Ref)branch, keyTemp).content();
        ((MapAssert)((MapAssert)this.soft.assertThat(this.store().getValues((Ref)branch, (Collection)keys).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ContentResult)e.getValue()).content()))).hasSize(2)).containsEntry((Object)key, (Object)tableOld)).containsEntry((Object)keyTemp, (Object)tableNew);
        this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"backup"), (List)ImmutableList.of((Object)Delete.of((ContentKey)key), (Object)Put.of((ContentKey)keyBackup, (Content)tableOld)));
        ((MapAssert)((MapAssert)this.soft.assertThat(this.store().getValues((Ref)branch, (Collection)keys).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ContentResult)e.getValue()).content()))).hasSize(2)).containsEntry((Object)keyBackup, (Object)tableOld)).containsEntry((Object)keyTemp, (Object)tableNew);
        this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"rename new"), (List)ImmutableList.of((Object)Delete.of((ContentKey)keyTemp), (Object)Put.of((ContentKey)key, (Content)tableNew)));
        ((MapAssert)((MapAssert)this.soft.assertThat(this.store().getValues((Ref)branch, (Collection)keys).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ContentResult)e.getValue()).content()))).hasSize(2)).containsEntry((Object)keyBackup, (Object)tableOld)).containsEntry((Object)key, (Object)tableNew);
        this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"delete"), Collections.singletonList(Delete.of((ContentKey)keyBackup)));
        ((MapAssert)this.soft.assertThat(this.store().getValues((Ref)branch, (Collection)keys).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ContentResult)e.getValue()).content()))).hasSize(1)).containsEntry((Object)key, (Object)tableNew);
    }

    @Test
    void commitWithValidation() throws Exception {
        BranchName branch = BranchName.of((String)"main");
        ContentKey key = ContentKey.of((String[])new String[]{"table0"});
        Hash branchHead = this.store().getNamedRef(branch.getName(), GetNamedRefsParams.DEFAULT).getHash();
        ArithmeticException exception = new ArithmeticException("Whatever");
        this.soft.assertThatThrownBy(() -> this.doCommitWithValidation(branch, key, validation -> {
            try {
                Assertions.assertThat((Object)this.store().getValue((Ref)branch, key)).isNull();
                PaginationIterator ignore = this.store().getKeys((Ref)branch, null, false, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS);
                if (ignore != null) {
                    ignore.close();
                }
            }
            catch (ReferenceNotFoundException e) {
                throw new RuntimeException(e);
            }
            throw exception;
        })).isSameAs((Object)exception);
        this.soft.assertThat((Object)this.store().getNamedRef(branch.getName(), GetNamedRefsParams.DEFAULT).getHash()).isEqualTo((Object)branchHead);
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, key)).isNull();
    }

    void doCommitWithValidation(BranchName branch, ContentKey key, VersionStore.CommitValidator validator) throws Exception {
        this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"initial commit meta"), Collections.singletonList(Put.of((ContentKey)key, (Content)OnRefOnly.newOnRef("some value"))), validator, (k, c) -> {});
    }

    static Stream<Arguments> duplicateKeysNewStorage() {
        ContentKey key = ContentKey.of((String[])new String[]{"my.awesome.table"});
        String tableRefState = "table ref state";
        OnRefOnly createValue1 = OnRefOnly.newOnRef("no no - not this");
        OnRefOnly createValue2 = OnRefOnly.newOnRef(tableRefState);
        return Stream.of(Arguments.of((Object[])new Object[]{Put.of((ContentKey)key, (Content)createValue1), Put.of((ContentKey)key, (Content)createValue2)}), Arguments.of((Object[])new Object[]{Put.of((ContentKey)key, (Content)createValue2), Delete.of((ContentKey)key)}), Arguments.of((Object[])new Object[]{Put.of((ContentKey)key, (Content)createValue2), Unchanged.of((ContentKey)key)}), Arguments.of((Object[])new Object[]{Delete.of((ContentKey)key), Delete.of((ContentKey)key)}), Arguments.of((Object[])new Object[]{Delete.of((ContentKey)key), Unchanged.of((ContentKey)key)}), Arguments.of((Object[])new Object[]{Unchanged.of((ContentKey)key), Put.of((ContentKey)key, (Content)createValue2)}), Arguments.of((Object[])new Object[]{Unchanged.of((ContentKey)key), Delete.of((ContentKey)key)}), Arguments.of((Object[])new Object[]{Unchanged.of((ContentKey)key), Unchanged.of((ContentKey)key)}));
    }

    @ParameterizedTest
    @MethodSource(value={"duplicateKeysNewStorage"})
    void duplicateKeysNewStorage(Operation operation1, Operation operation2) {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isTrue();
        BranchName branch = BranchName.of((String)"main");
        ContentKey key = ContentKey.of((String[])new String[]{"my.awesome.table"});
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"initial"), Arrays.asList(operation1, operation2))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(key.toString());
    }

    static Stream<Arguments> duplicateKeysOldStorage() {
        ContentKey key = ContentKey.of((String[])new String[]{"my.awesome.table"});
        String tableRefState = "table ref state";
        OnRefOnly createValue1 = OnRefOnly.newOnRef("no no - not this");
        OnRefOnly createValue2 = OnRefOnly.newOnRef(tableRefState);
        return Stream.of(Arguments.of((Object[])new Object[]{Put.of((ContentKey)key, (Content)createValue1), Put.of((ContentKey)key, (Content)createValue2)}), Arguments.of((Object[])new Object[]{Put.of((ContentKey)key, (Content)createValue2), Delete.of((ContentKey)key)}), Arguments.of((Object[])new Object[]{Put.of((ContentKey)key, (Content)createValue2), Unchanged.of((ContentKey)key)}), Arguments.of((Object[])new Object[]{Delete.of((ContentKey)key), Put.of((ContentKey)key, (Content)createValue2)}), Arguments.of((Object[])new Object[]{Delete.of((ContentKey)key), Unchanged.of((ContentKey)key)}), Arguments.of((Object[])new Object[]{Unchanged.of((ContentKey)key), Put.of((ContentKey)key, (Content)createValue2)}), Arguments.of((Object[])new Object[]{Unchanged.of((ContentKey)key), Delete.of((ContentKey)key)}), Arguments.of((Object[])new Object[]{Unchanged.of((ContentKey)key), Unchanged.of((ContentKey)key)}));
    }

    @ParameterizedTest
    @MethodSource(value={"duplicateKeysOldStorage"})
    void duplicateKeysOldStorage(Operation operation1, Operation operation2) {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isFalse();
        BranchName branch = BranchName.of((String)"main");
        ContentKey key = ContentKey.of((String[])new String[]{"my.awesome.table"});
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"initial"), Arrays.asList(operation1, operation2))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(key.toString());
    }

    static enum OperationOrder {
        PUT_THEN_DELETE,
        DELETE_THEN_PUT;

    }
}

