/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.Namespace;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.tests.CommitBuilder;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractEntries
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected AbstractEntries(VersionStore store) {
        super(store);
    }

    @Test
    public void entriesWrongParameters() {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isTrue();
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.keysAsList((Ref)this.store().noAncestorHash(), (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().minKey(ContentKey.of((String[])new String[]{"foo"})).maxKey(ContentKey.of((String[])new String[]{"foo"})).prefixKey(ContentKey.of((String[])new String[]{"foo"})).build())).withMessageContaining("Combining prefixKey with either minKey or maxKey is not supported.");
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.keysAsList((Ref)this.store().noAncestorHash(), (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().maxKey(ContentKey.of((String[])new String[]{"foo"})).prefixKey(ContentKey.of((String[])new String[]{"foo"})).build())).withMessageContaining("Combining prefixKey with either minKey or maxKey is not supported.");
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.keysAsList((Ref)this.store().noAncestorHash(), (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().minKey(ContentKey.of((String[])new String[]{"foo"})).prefixKey(ContentKey.of((String[])new String[]{"foo"})).build())).withMessageContaining("Combining prefixKey with either minKey or maxKey is not supported.");
    }

    @Test
    public void entriesRanges() throws Exception {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isTrue();
        BranchName branch = BranchName.of((String)"foo");
        ContentKey key1 = ContentKey.of((String[])new String[]{"k1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"k2"});
        ContentKey key2a = ContentKey.of((String[])new String[]{"k2", "a"});
        ContentKey key2b = ContentKey.of((String[])new String[]{"k2", "a\u03c0"});
        ContentKey key2c = ContentKey.of((String[])new String[]{"k2", "\u03c0a"});
        ContentKey key2d = ContentKey.of((String[])new String[]{"k2", "aa"});
        ContentKey key23 = ContentKey.of((String[])new String[]{"k2", "k3"});
        ContentKey key23a = ContentKey.of((String[])new String[]{"k2", "k3", "a"});
        ContentKey key23b = ContentKey.of((String[])new String[]{"k2", "k3", "b"});
        ContentKey key3 = ContentKey.of((String[])new String[]{"k3"});
        this.store().create((NamedRef)branch, Optional.empty()).getHash();
        Hash initialCommit = this.commit("Initial Commit").put(key1, (Content)OnRefOnly.newOnRef("v1")).put(key2, (Content)Namespace.of((ContentKey)key2)).put(key23, (Content)Namespace.of((ContentKey)key23)).put(key2a, (Content)OnRefOnly.newOnRef("v2a")).put(key2b, (Content)OnRefOnly.newOnRef("v2b")).put(key2c, (Content)OnRefOnly.newOnRef("v2c")).put(key2d, (Content)OnRefOnly.newOnRef("v2d")).put(key23a, (Content)OnRefOnly.newOnRef("v23a")).put(key23b, (Content)OnRefOnly.newOnRef("v23b")).put(key3, (Content)OnRefOnly.newOnRef("v3")).toBranch(branch);
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS)).map(e -> e.getKey().contentKey()).containsExactlyInAnyOrder((Object[])new ContentKey[]{key1, key2, key2a, key2b, key2c, key2d, key23, key23a, key23b, key3});
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().minKey(key23).build())).map(e -> e.getKey().contentKey()).containsExactlyInAnyOrder((Object[])new ContentKey[]{key23, key23a, key23b, key3, key2c});
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().prefixKey(key23).build())).map(e -> e.getKey().contentKey()).containsExactlyInAnyOrder((Object[])new ContentKey[]{key23, key23a, key23b});
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().maxKey(key23).build())).map(e -> e.getKey().contentKey()).containsExactlyInAnyOrder((Object[])new ContentKey[]{key1, key2, key2a, key2b, key2d, key23});
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().minKey(key23).maxKey(key23a).build())).map(e -> e.getKey().contentKey()).containsExactlyInAnyOrder((Object[])new ContentKey[]{key23, key23a});
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().prefixKey(ContentKey.of((String[])new String[]{"k"})).build())).isEmpty();
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().maxKey(ContentKey.of((String[])new String[]{"k"})).build())).isEmpty();
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().prefixKey(ContentKey.of((String[])new String[]{"x"})).build())).isEmpty();
        this.soft.assertThat(this.keysAsList((Ref)initialCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().contentKeyPredicate((k, t) -> k.toPathString().startsWith(key2.toPathString())).build())).map(e -> e.getKey().contentKey()).containsExactlyInAnyOrder((Object[])new ContentKey[]{key2, key2a, key2b, key2c, key2d, key23, key23a, key23b});
    }

    List<KeyEntry> keysAsList(Ref ref, VersionStore.KeyRestrictions keyRestrictions) throws Exception {
        try (PaginationIterator keys = this.store().getKeys(ref, null, false, keyRestrictions);){
            ArrayList arrayList = Lists.newArrayList((Iterator)keys);
            return arrayList;
        }
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 49, 50, 51, 100, 101})
    void getKeys(int numKeys) throws Exception {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isTrue();
        BranchName branch = BranchName.of((String)"foo");
        Hash head = this.store().create((NamedRef)branch, Optional.empty()).getHash();
        ArrayList<Tuple> expected = new ArrayList<Tuple>();
        if (numKeys > 0) {
            CommitBuilder commit = this.commit("Initial Commit");
            for (int i = 0; i < numKeys; ++i) {
                ContentKey key = ContentKey.of((String[])new String[]{"key" + i});
                OnRefOnly value = OnRefOnly.newOnRef("key" + i);
                commit.put(key, (Content)value);
                expected.add(Tuple.tuple((Object[])new Object[]{key, value}));
            }
            head = commit.toBranch(branch);
        }
        try (PaginationIterator iter = this.store().getKeys((Ref)head, null, true, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS);){
            this.soft.assertThat((Iterator)iter).toIterable().extracting(new Function[]{keyEntry -> keyEntry.getKey().contentKey(), keyEntry -> keyEntry.getContent().withId(null)}).containsExactlyInAnyOrderElementsOf(expected);
        }
    }

    @Test
    void entries() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        ContentKey key2 = ContentKey.of((String[])new String[]{"k2"});
        ContentKey key2a = ContentKey.of((String[])new String[]{"k2", "a"});
        ContentKey key23 = ContentKey.of((String[])new String[]{"k2", "k3"});
        ContentKey key23a = ContentKey.of((String[])new String[]{"k2", "k3", "a"});
        this.store().create((NamedRef)branch, Optional.empty()).getHash();
        Hash commit = this.commit("Initial Commit").put(key2, (Content)Namespace.of((ContentKey)key2)).put(key23, (Content)Namespace.of((ContentKey)key23)).put(key2a, (Content)OnRefOnly.newOnRef("v2a")).put(key23a, (Content)OnRefOnly.newOnRef("v23a")).toBranch(branch);
        ContentResult content2 = this.store().getValue((Ref)commit, key2);
        ContentResult content2a = this.store().getValue((Ref)commit, key2a);
        ContentResult content23 = this.store().getValue((Ref)commit, key23);
        ContentResult content23a = this.store().getValue((Ref)commit, key23a);
        try (PaginationIterator iter = this.store.getKeys((Ref)commit, null, true, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS);){
            this.soft.assertThat((Iterator)iter).toIterable().extracting(new Function[]{KeyEntry::getKey, KeyEntry::getContent}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{content2.identifiedKey(), content2.content()}), Tuple.tuple((Object[])new Object[]{content2a.identifiedKey(), content2a.content()}), Tuple.tuple((Object[])new Object[]{content23.identifiedKey(), content23.content()}), Tuple.tuple((Object[])new Object[]{content23a.identifiedKey(), content23a.content()})});
        }
        if (this.isNewStorageModel()) {
            this.soft.assertThat(this.store.getIdentifiedKeys((Ref)commit, (Collection)Lists.newArrayList((Object[])new ContentKey[]{key2, key2a, key23, key23a}))).containsExactly((Object[])new IdentifiedContentKey[]{content2.identifiedKey(), content2a.identifiedKey(), content23.identifiedKey(), content23a.identifiedKey()});
            this.soft.assertThat(content2a.identifiedKey().elements()).startsWith((Object[])content2.identifiedKey().elements().toArray(new IdentifiedContentKey.IdentifiedElement[0]));
            this.soft.assertThat(content23.identifiedKey().elements()).startsWith((Object[])content2.identifiedKey().elements().toArray(new IdentifiedContentKey.IdentifiedElement[0]));
            this.soft.assertThat(content23a.identifiedKey().elements()).startsWith((Object[])content23.identifiedKey().elements().toArray(new IdentifiedContentKey.IdentifiedElement[0]));
        } else {
            this.soft.assertThat(this.store.getIdentifiedKeys((Ref)commit, (Collection)Lists.newArrayList((Object[])new ContentKey[]{key2, key2a, key23, key23a}))).extracting(IdentifiedContentKey::lastElement).extracting(IdentifiedContentKey.IdentifiedElement::element).containsExactly((Object[])new String[]{key2.getName(), key2a.getName(), key23.getName(), key23a.getName()});
            this.soft.assertThat((Object)content2a.identifiedKey().lastElement()).isEqualTo((Object)IdentifiedContentKey.IdentifiedElement.identifiedElement((String)key2a.getName(), (String)content2a.content().getId()));
            this.soft.assertThat((Object)content23.identifiedKey().lastElement()).isEqualTo((Object)IdentifiedContentKey.IdentifiedElement.identifiedElement((String)key23.getName(), (String)content23.content().getId()));
            this.soft.assertThat((Object)content23a.identifiedKey().lastElement()).isEqualTo((Object)IdentifiedContentKey.IdentifiedElement.identifiedElement((String)key23a.getName(), (String)content23a.content().getId()));
        }
    }
}

