/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.error.ReferenceConflicts;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeConflictException;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.ResultType;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.tests.StorageAssertions;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractMerge
extends AbstractNestedVersionStore {
    public static final BranchName MAIN_BRANCH = BranchName.of((String)"foo");
    @InjectSoftAssertions
    protected SoftAssertions soft;
    private static final OnRefOnly V_1_1 = OnRefOnly.newOnRef("v1_1");
    private static final OnRefOnly V_1_2 = OnRefOnly.newOnRef("v1_2");
    private static final OnRefOnly V_1_4 = OnRefOnly.newOnRef("v1_4");
    private static final OnRefOnly V_2_1 = OnRefOnly.newOnRef("v2_1");
    private static final OnRefOnly V_2_2 = OnRefOnly.newOnRef("v2_2");
    private static final OnRefOnly V_3_1 = OnRefOnly.newOnRef("v3_1");
    private static final OnRefOnly V_4_1 = OnRefOnly.newOnRef("v4_1");
    private static final OnRefOnly V_5_1 = OnRefOnly.newOnRef("v5_1");
    private static final OnRefOnly VALUE_1 = OnRefOnly.newOnRef("value1");
    private static final OnRefOnly VALUE_2 = OnRefOnly.newOnRef("value2");
    private static final OnRefOnly VALUE_3 = OnRefOnly.newOnRef("value3");
    private static final OnRefOnly VALUE_4 = OnRefOnly.newOnRef("value4");
    private static final OnRefOnly VALUE_5 = OnRefOnly.newOnRef("value5");
    private static final OnRefOnly VALUE_6 = OnRefOnly.newOnRef("value6");
    private Hash initialHash;
    private Hash firstCommit;
    private Hash thirdCommit;
    private List<Commit> commits;

    protected AbstractMerge(VersionStore store) {
        super(store);
    }

    @BeforeEach
    protected void setupCommits() throws VersionStoreException {
        this.store().create((NamedRef)MAIN_BRANCH, Optional.empty());
        this.initialHash = this.commit("Default common ancestor").toBranch(MAIN_BRANCH);
        this.firstCommit = this.commit("First Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).put("t3", (Content)V_3_1).toBranch(MAIN_BRANCH);
        Content t1 = this.store().getValue((Ref)MAIN_BRANCH, ContentKey.of((String[])new String[]{"t1"})).content();
        this.commit("Second Commit").put("t1", (Content)V_1_2.withId(t1.getId())).delete("t2").delete("t3").put("t4", (Content)V_4_1).toBranch(MAIN_BRANCH);
        this.thirdCommit = this.commit("Third Commit").put("t2", (Content)V_2_2).unchanged("t4").toBranch(MAIN_BRANCH);
        this.commits = this.commitsList((Ref)MAIN_BRANCH, false).subList(0, 3);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeKeyBehaviorValidation(boolean dryRun) throws Exception {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isTrue();
        BranchName targetBranch = BranchName.of((String)"mergeKeyBehaviorValidation");
        this.store().create((NamedRef)targetBranch, Optional.of(this.firstCommit));
        ContentKey keyNotUsed = ContentKey.of((String[])new String[]{"not", "used"});
        ContentKey keyUnused = ContentKey.of((String[])new String[]{"un", "used"});
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(targetBranch).putMergeKeyBehaviors(keyNotUsed, MergeKeyBehavior.of((ContentKey)keyNotUsed, (MergeBehavior)MergeBehavior.DROP)).putMergeKeyBehaviors(keyUnused, MergeKeyBehavior.of((ContentKey)keyUnused, (MergeBehavior)MergeBehavior.DROP)).dryRun(dryRun).build())).withMessage("Not all merge key behaviors specified in the request have been used. The following keys were not used: [not.used, un.used]");
        ContentKey keyT3 = ContentKey.of((String[])new String[]{"t3"});
        for (MergeBehavior mergeBehavior : new MergeBehavior[]{MergeBehavior.DROP, MergeBehavior.FORCE}) {
            this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(targetBranch).putMergeKeyBehaviors(keyT3, MergeKeyBehavior.of((ContentKey)keyT3, (MergeBehavior)mergeBehavior, (Content)V_3_1, (Content)V_1_1)).dryRun(dryRun).build())).withMessage("MergeKeyBehavior.resolvedContent must be null for MergeBehavior.%s for t3", new Object[]{mergeBehavior});
        }
        Content c11 = this.store().getValue((Ref)this.firstCommit, ContentKey.of((String[])new String[]{"t1"})).content();
        for (MergeBehavior mergeBehavior : new MergeBehavior[]{MergeBehavior.NORMAL, MergeBehavior.FORCE}) {
            StorageAssertions checkpoint = this.storageCheckpoint();
            ((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(targetBranch).putMergeKeyBehaviors(keyT3, MergeKeyBehavior.of((ContentKey)keyT3, (MergeBehavior)mergeBehavior, (Content)c11, null)).dryRun(dryRun).build())).describedAs("MergeBehavior.%s", new Object[]{mergeBehavior})).hasMessage("The following keys have been changed in conflict: 't3'").asInstanceOf(InstanceOfAssertFactories.type(MergeConflictException.class))).extracting(MergeConflictException::getMergeResult).extracting(new Function[]{MergeResult::wasApplied, MergeResult::wasSuccessful, r -> r.getDetails().get(keyT3)}).containsExactly(new Object[]{false, false, MergeResult.KeyDetails.keyDetails((MergeBehavior)mergeBehavior, (Conflict)Conflict.conflict((Conflict.ConflictType)Conflict.ConflictType.VALUE_DIFFERS, (ContentKey)keyT3, (String)"values of existing and expected content for key 't3' are different"))});
            checkpoint.assertNoWrites();
            this.soft.assertAll();
        }
    }

    @Test
    protected void mergeResolveConflict() throws VersionStoreException {
        BranchName sourceBranch = BranchName.of((String)"mergeResolveConflict");
        this.store().create((NamedRef)sourceBranch, Optional.of(this.thirdCommit));
        ContentKey key2 = ContentKey.of((String[])new String[]{"t2"});
        Content contentT2 = this.store().getValue((Ref)MAIN_BRANCH, key2).content();
        Hash targetHead = this.commit("on-target-commit").put("t2", (Content)OnRefOnly.onRef("v2_2-target", contentT2.getId())).toBranch(MAIN_BRANCH);
        Hash sourceHead = this.commit("on-source-commit").put("t2", (Content)OnRefOnly.onRef("v2_2-source", contentT2.getId())).toBranch(sourceBranch);
        contentT2 = this.store().getValue((Ref)MAIN_BRANCH, key2).content();
        this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)sourceBranch).fromHash(sourceHead).toBranch(MAIN_BRANCH).build())).isInstanceOf(MergeConflictException.class);
        OnRefOnly resolvedContent = OnRefOnly.onRef("resolved", contentT2.getId());
        OnRefOnly wrongExpectedContent = OnRefOnly.onRef("wrong", contentT2.getId());
        if (!this.isNewStorageModel()) {
            this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)sourceBranch).fromHash(sourceHead).toBranch(MAIN_BRANCH).putMergeKeyBehaviors(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.NORMAL, (Content)wrongExpectedContent, (Content)resolvedContent)).build())).withMessage("MergeKeyBehavior.resolvedContent and MergeKeyBehavior.expectedTargetContent are not supported for this storage model");
            return;
        }
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)sourceBranch).fromHash(sourceHead).toBranch(MAIN_BRANCH).putMergeKeyBehaviors(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.NORMAL, (Content)wrongExpectedContent, (Content)resolvedContent)).build())).isInstanceOf(ReferenceConflictException.class)).asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).containsExactly((Object[])new Conflict[]{Conflict.conflict((Conflict.ConflictType)Conflict.ConflictType.VALUE_DIFFERS, (ContentKey)key2, (String)"values of existing and expected content for key 't2' are different")});
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)sourceBranch).fromHash(sourceHead).toBranch(MAIN_BRANCH).putMergeKeyBehaviors(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.NORMAL, null, (Content)resolvedContent)).build())).withMessage("MergeKeyBehavior.resolvedContent requires setting MergeKeyBehavior.expectedTarget as well for key t2");
        MergeResult result = this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)sourceBranch).fromHash(sourceHead).toBranch(MAIN_BRANCH).putMergeKeyBehaviors(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.NORMAL, (Content)contentT2, (Content)resolvedContent)).build());
        ReferenceInfo branch = this.store().getNamedRef(MAIN_BRANCH.getName(), GetNamedRefsParams.DEFAULT);
        this.soft.assertThat((Object)result).extracting(new Function[]{MergeResult::wasApplied, MergeResult::wasSuccessful, MergeResult::getResultantTargetHash, MergeResult::getCommonAncestor, MergeResult::getEffectiveTargetHash}).containsExactly(new Object[]{true, true, branch.getHash(), this.thirdCommit, targetHead});
        Content mergedContent = this.store().getValue((Ref)MAIN_BRANCH, key2).content();
        this.soft.assertThat((Object)mergedContent).isEqualTo((Object)resolvedContent);
    }

    @Test
    protected void mergeIntoEmptyBranch3Commits() throws VersionStoreException {
        CharSequence[] charSequenceArray;
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isFalse();
        BranchName newBranch = BranchName.of((String)"mergeIntoEmptyBranch3Commits");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        this.doMergeIntoEmpty(newBranch);
        Assertions.assertThat((Object)this.store().hashOnReference((NamedRef)newBranch, Optional.empty(), Collections.emptyList())).isNotEqualTo((Object)this.thirdCommit);
        if (this.isNewStorageModel()) {
            CharSequence[] charSequenceArray2 = new String[1];
            charSequenceArray = charSequenceArray2;
            charSequenceArray2[0] = "";
        } else {
            charSequenceArray = (String[])this.commits.stream().map(Commit::getCommitMeta).map(CommitMeta::getMessage).toArray(String[]::new);
        }
        CharSequence[] expectContains = charSequenceArray;
        ((ObjectAssert)this.soft.assertThat(this.commitsList((Ref)newBranch, false)).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).asString().contains(expectContains);
    }

    private void doMergeIntoEmpty(BranchName newBranch) throws ReferenceNotFoundException, ReferenceConflictException {
        MergeResult result = this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(newBranch).expectedHash(Optional.of(this.initialHash)).build());
        ((ObjectAssert)this.soft.assertThat(result.getCreatedCommits()).singleElement()).satisfies(new ThrowingConsumer[]{c -> {
            this.soft.assertThat((Object)c.getParentHash()).isEqualTo((Object)this.initialHash);
            if (this.isNewStorageModel()) {
                this.soft.assertThat(c.getCommitMeta().getMessage()).isEmpty();
            } else {
                ((StringAssert)((StringAssert)this.soft.assertThat(c.getCommitMeta().getMessage()).contains(new CharSequence[]{"First Commit"})).contains(new CharSequence[]{"Second Commit"})).contains(new CharSequence[]{"Third Commit"});
            }
            ((ListAssert)((ListAssert)((ListAssert)((ListAssert)this.soft.assertThat(c.getOperations()).hasSizeBetween(3, 4)).anySatisfy(o -> {
                if (c.getOperations() != null && c.getOperations().size() == 4) {
                    this.soft.assertThat(o).isInstanceOf(Delete.class);
                    this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t3"}));
                }
            })).anySatisfy(o -> {
                this.soft.assertThat(o).isInstanceOf(Put.class);
                this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t1"}));
                this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_1_2);
            })).anySatisfy(o -> {
                this.soft.assertThat(o).isInstanceOf(Put.class);
                this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t2"}));
                this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_2_2);
            })).anySatisfy(o -> {
                this.soft.assertThat(o).isInstanceOf(Put.class);
                this.soft.assertThat((Comparable)o.getKey()).isEqualTo((Object)ContentKey.of((String[])new String[]{"t4"}));
                this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)o).getValue())).isEqualTo((Object)V_4_1);
            });
        }});
        this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}), ContentKey.of((String[])new String[]{"t4"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{"t4"}), (Object)((Object)V_4_1)));
    }

    @Test
    void compareDryAndEffectiveMergeResults() throws VersionStoreException {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isFalse();
        BranchName newBranch = BranchName.of((String)"compareDryAndEffectiveMergeResults");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        Hash origHead = this.store().getNamedRef(newBranch.getName(), GetNamedRefsParams.DEFAULT).getHash();
        MergeResult dryMergeResult = this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.firstCommit).toBranch(newBranch).expectedHash(Optional.of(this.initialHash)).dryRun(true).fetchAdditionalInfo(true).build());
        this.soft.assertThat((Object)dryMergeResult).extracting(new Function[]{MergeResult::wasApplied, MergeResult::wasSuccessful, MergeResult::getCommonAncestor, MergeResult::getTargetBranch, MergeResult::getEffectiveTargetHash, MergeResult::getExpectedHash}).containsExactly(new Object[]{false, true, this.initialHash, newBranch, this.initialHash, this.initialHash});
        this.soft.assertThat((Object)this.store().getNamedRef(newBranch.getName(), GetNamedRefsParams.DEFAULT).getHash()).isEqualTo((Object)origHead);
        MergeResult mergeResult = this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.firstCommit).toBranch(newBranch).expectedHash(Optional.of(this.initialHash)).fetchAdditionalInfo(true).build());
        Hash head = this.store().getNamedRef(newBranch.getName(), GetNamedRefsParams.DEFAULT).getHash();
        this.soft.assertThat((Object)head).isNotEqualTo((Object)origHead);
        this.soft.assertThat(mergeResult.getSourceCommits()).satisfiesAnyOf(new ThrowingConsumer[]{l -> Assertions.assertThat((List)l).isEmpty(), l -> Assertions.assertThat((List)l).extracting(new Function[]{Commit::getHash, c -> c.getCommitMeta().getMessage(), c -> AbstractMerge.operationsWithoutContentId(c.getOperations())}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{this.firstCommit, "First Commit", Arrays.asList(Put.of((ContentKey)ContentKey.of((String[])new String[]{"t1"}), (Content)V_1_1), Put.of((ContentKey)ContentKey.of((String[])new String[]{"t2"}), (Content)V_2_1), Put.of((ContentKey)ContentKey.of((String[])new String[]{"t3"}), (Content)V_3_1))})})});
        this.soft.assertThat(mergeResult.getTargetCommits()).isNull();
        if (!this.isNewStorageModel()) {
            this.soft.assertThat(mergeResult.getCreatedCommits()).isEmpty();
        }
        this.soft.assertThat(mergeResult.getDetails()).containsKeys((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"})});
        ((ObjectAssert)this.soft.assertThat((Object)mergeResult).isEqualTo((Object)MergeResult.builder().resultType(ResultType.MERGE).sourceRef((NamedRef)MAIN_BRANCH).wasApplied(true).wasSuccessful(true).commonAncestor(this.initialHash).resultantTargetHash(head).targetBranch(newBranch).effectiveTargetHash(this.initialHash).expectedHash(this.initialHash).addAllSourceCommits((Iterable)mergeResult.getSourceCommits()).addAllCreatedCommits((Iterable)mergeResult.getCreatedCommits()).putAllDetails(mergeResult.getDetails()).build())).isEqualTo((Object)MergeResult.builder().from(dryMergeResult).wasApplied(true).createdCommits((Iterable)mergeResult.getCreatedCommits()).resultantTargetHash(mergeResult.getResultantTargetHash()).build());
    }

    @Test
    protected void mergeIntoEmptyBranch1Commit() throws VersionStoreException {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isFalse();
        BranchName newBranch = BranchName.of((String)"mergeIntoEmptyBranch1Commit");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        MergeResult result = this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.firstCommit).toBranch(newBranch).expectedHash(Optional.of(this.initialHash)).build());
        this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}), ContentKey.of((String[])new String[]{"t4"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_1), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_1), (Object)ContentKey.of((String[])new String[]{"t3"}), (Object)((Object)V_3_1)));
        this.soft.assertThat((Object)this.store().hashOnReference((NamedRef)newBranch, Optional.empty(), Collections.emptyList())).isEqualTo((Object)this.firstCommit);
        this.soft.assertThat(result.getCreatedCommits()).isEmpty();
        List<Commit> mergedCommit = this.commitsList((Ref)newBranch, false).subList(0, 1);
        AbstractMerge.assertCommitMeta(this.soft, mergedCommit, this.commits.subList(2, 3));
        ((ListAssert)this.soft.assertThat((Object)mergedCommit.get(0)).extracting(Commit::getCommitMeta).extracting(CommitMeta::getParentCommitHashes).asInstanceOf(InstanceOfAssertFactories.list(Hash.class))).hasSize(1);
    }

    @Test
    protected void mergeIntoEmptyBranchModifying() throws VersionStoreException {
        CharSequence[] charSequenceArray;
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isFalse();
        BranchName newBranch = BranchName.of((String)"mergeIntoEmptyBranchModifying");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        this.doMergeIntoEmpty(newBranch);
        List<Commit> mergedCommits = this.commitsList((Ref)newBranch, false);
        if (this.isNewStorageModel()) {
            CharSequence[] charSequenceArray2 = new String[1];
            charSequenceArray = charSequenceArray2;
            charSequenceArray2[0] = "";
        } else {
            charSequenceArray = (String[])this.commits.stream().map(Commit::getCommitMeta).map(CommitMeta::getMessage).toArray(String[]::new);
        }
        CharSequence[] expectContains = charSequenceArray;
        ((ObjectAssert)this.soft.assertThat(mergedCommits).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).asString().contains(expectContains);
        ((ListAssert)((ObjectAssert)this.soft.assertThat(mergedCommits).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getParentCommitHashes).asInstanceOf(InstanceOfAssertFactories.list(String.class))).containsExactly((Object[])new String[]{mergedCommits.get(1).getHash().asString(), this.commits.get(0).getHash().asString()});
    }

    @Test
    protected void mergeIntoNonConflictingBranch() throws VersionStoreException {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isFalse();
        BranchName newBranch = BranchName.of((String)"bar_2");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        Hash newCommit = this.commit("Unrelated commit").put("t5", (Content)V_5_1).toBranch(newBranch);
        MergeResult result = this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(newBranch).build());
        this.soft.assertThat((Object)result.getResultantTargetHash()).isNotEqualTo((Object)this.thirdCommit);
        this.soft.assertThat(result.getSourceCommits()).satisfiesAnyOf(new ThrowingConsumer[]{l -> Assertions.assertThat((List)l).isEmpty(), l -> Assertions.assertThat((List)l).hasSize(3)});
        this.soft.assertThat((Object)result).extracting(new Function[]{MergeResult::getCommonAncestor, MergeResult::wasSuccessful, MergeResult::wasApplied}).containsExactly(new Object[]{this.initialHash, true, true});
        this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}), ContentKey.of((String[])new String[]{"t4"}), ContentKey.of((String[])new String[]{"t5"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{"t4"}), (Object)((Object)V_4_1), (Object)ContentKey.of((String[])new String[]{"t5"}), (Object)((Object)V_5_1)));
        List<Commit> commits = this.commitsList((Ref)newBranch, false);
        this.soft.assertThat(commits).satisfiesExactly(new ThrowingConsumer[]{c0 -> {
            CharSequence[] charSequenceArray;
            if (this.isNewStorageModel()) {
                CharSequence[] charSequenceArray2 = new String[1];
                charSequenceArray = charSequenceArray2;
                charSequenceArray2[0] = "";
            } else {
                String[] stringArray = new String[3];
                stringArray[0] = "Third Commit";
                stringArray[1] = "Second Commit";
                charSequenceArray = stringArray;
                stringArray[2] = "First Commit";
            }
            CharSequence[] expectContains = charSequenceArray;
            Assertions.assertThat((Object)c0).extracting(Commit::getCommitMeta).extracting(CommitMeta::getMessage).asString().contains(expectContains);
        }, c3 -> Assertions.assertThat((Object)c3).extracting(Commit::getHash).isEqualTo((Object)newCommit), c4 -> Assertions.assertThat((Object)c4).extracting(Commit::getHash).isEqualTo((Object)this.initialHash)});
        ((ObjectAssert)this.soft.assertThat(result.getCreatedCommits()).singleElement()).extracting(Commit::getParentHash).isEqualTo((Object)newCommit);
    }

    @Test
    protected void nonEmptyFastForwardMerge() throws VersionStoreException {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isFalse();
        ContentKey key = ContentKey.of((String[])new String[]{"t1"});
        BranchName etl = BranchName.of((String)"etl");
        BranchName review = BranchName.of((String)"review");
        this.store().create((NamedRef)etl, Optional.of(this.initialHash));
        this.store().create((NamedRef)review, Optional.of(this.initialHash));
        CommitResult etl1 = this.store().commit(etl, Optional.empty(), CommitMeta.fromMessage((String)"commit 1"), Collections.singletonList(Put.of((ContentKey)key, (Content)VALUE_1)));
        Content v = this.store().getValue((Ref)etl, key).content();
        MergeResult mergeResult1 = this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)etl).fromHash(this.store().hashOnReference((NamedRef)etl, Optional.empty(), Collections.emptyList())).toBranch(review).build());
        this.soft.assertThat((Object)mergeResult1.getResultantTargetHash()).isEqualTo((Object)etl1.getCommitHash());
        this.soft.assertThat(mergeResult1.getCreatedCommits()).isEmpty();
        CommitResult etl2 = this.store().commit(etl, Optional.empty(), CommitMeta.fromMessage((String)"commit 2"), Collections.singletonList(Put.of((ContentKey)key, (Content)VALUE_2.withId(v.getId()))));
        MergeResult mergeResult2 = this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)etl).fromHash(this.store().hashOnReference((NamedRef)etl, Optional.empty(), Collections.emptyList())).toBranch(review).build());
        this.soft.assertThat((Object)mergeResult2.getResultantTargetHash()).isEqualTo((Object)etl2.getCommitHash());
        this.soft.assertThat(mergeResult2.getCreatedCommits()).isEmpty();
        this.soft.assertThat((Object)AbstractMerge.contentWithoutId(this.store().getValue((Ref)review, key))).isEqualTo((Object)VALUE_2);
    }

    @Test
    protected void mergeWithCommonAncestor() throws VersionStoreException {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isFalse();
        BranchName newBranch = BranchName.of((String)"bar_2");
        this.store().create((NamedRef)newBranch, Optional.of(this.firstCommit));
        Hash newCommit = this.commit("Unrelated commit").put("t5", (Content)V_5_1).toBranch(newBranch);
        MergeResult result = this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(newBranch).build());
        this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store().getValues((Ref)newBranch, Arrays.asList(ContentKey.of((String[])new String[]{"t1"}), ContentKey.of((String[])new String[]{"t2"}), ContentKey.of((String[])new String[]{"t3"}), ContentKey.of((String[])new String[]{"t4"}), ContentKey.of((String[])new String[]{"t5"}))))).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.of((Object)ContentKey.of((String[])new String[]{"t1"}), (Object)((Object)V_1_2), (Object)ContentKey.of((String[])new String[]{"t2"}), (Object)((Object)V_2_2), (Object)ContentKey.of((String[])new String[]{"t4"}), (Object)((Object)V_4_1), (Object)ContentKey.of((String[])new String[]{"t5"}), (Object)((Object)V_5_1)));
        List<Commit> commits = this.commitsList((Ref)newBranch, true);
        ((ListAssert)this.soft.assertThat(commits).hasSize(4)).satisfiesExactly(new ThrowingConsumer[]{c -> {
            if (this.isNewStorageModel()) {
                Assertions.assertThat((String)c.getCommitMeta().getMessage()).isEmpty();
            } else {
                Assertions.assertThat((String)c.getCommitMeta().getMessage()).contains(new CharSequence[]{"Second Commit", "Third Commit"});
            }
        }, c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)newCommit), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)this.firstCommit), c -> Assertions.assertThat((Object)c.getHash()).isEqualTo((Object)this.initialHash)});
        ((ObjectAssert)this.soft.assertThat(result.getCreatedCommits()).singleElement()).isEqualTo((Object)commits.get(0));
        ((ListAssert)((ObjectAssert)this.soft.assertThat(commits).first()).extracting(Commit::getCommitMeta).extracting(CommitMeta::getParentCommitHashes).asInstanceOf(InstanceOfAssertFactories.list(String.class))).containsExactly((Object[])new String[]{newCommit.asString(), this.thirdCommit.asString()});
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "true,false", "false,true", "true,true"})
    protected void mergeWithConflictingKeys(boolean dryRun, boolean allForce) throws VersionStoreException {
        Assumptions.assumeThat((boolean)this.isNewStorageModel()).isFalse();
        BranchName mergeInto = BranchName.of((String)"foofoo");
        BranchName mergeFrom = BranchName.of((String)"barbar");
        this.store().create((NamedRef)mergeInto, Optional.of(this.initialHash));
        this.store().create((NamedRef)mergeFrom, Optional.of(this.initialHash));
        ContentKey conflictingKey1 = ContentKey.of((String[])new String[]{"some_key1"});
        ContentKey conflictingKey2 = ContentKey.of((String[])new String[]{"some_key2"});
        ContentKey key3 = ContentKey.of((String[])new String[]{"some_key3"});
        ContentKey key4 = ContentKey.of((String[])new String[]{"some_key4"});
        this.store().commit(mergeInto, Optional.empty(), CommitMeta.fromMessage((String)"commit 1"), Collections.singletonList(Put.of((ContentKey)conflictingKey1, (Content)VALUE_1)));
        this.store().commit(mergeFrom, Optional.empty(), CommitMeta.fromMessage((String)"commit 2"), Arrays.asList(Put.of((ContentKey)conflictingKey1, (Content)VALUE_2), Put.of((ContentKey)key3, (Content)VALUE_5)));
        Hash mergeIntoHead = this.store().commit(mergeInto, Optional.empty(), CommitMeta.fromMessage((String)"commit 3"), Arrays.asList(Put.of((ContentKey)conflictingKey2, (Content)VALUE_3), Put.of((ContentKey)key4, (Content)VALUE_6))).getCommitHash();
        Hash mergeFromHash = this.store().commit(mergeFrom, Optional.empty(), CommitMeta.fromMessage((String)"commit 4"), Collections.singletonList(Put.of((ContentKey)conflictingKey2, (Content)VALUE_4))).getCommitHash();
        StorageAssertions checkpoint = this.storageCheckpoint();
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)mergeFrom).fromHash(mergeFromHash).toBranch(mergeInto).dryRun(dryRun).build())).isInstanceOf(ReferenceConflictException.class)).hasMessageContaining("The following keys have been changed in conflict:").hasMessageContaining(conflictingKey1.toString()).hasMessageContaining(conflictingKey2.toString());
        if (dryRun) {
            checkpoint.assertNoWrites();
        }
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)mergeFrom).fromHash(mergeFromHash).toBranch(mergeInto).putMergeKeyBehaviors(conflictingKey2, MergeKeyBehavior.of((ContentKey)conflictingKey2, (MergeBehavior)MergeBehavior.DROP)).dryRun(dryRun).build())).isInstanceOf(ReferenceConflictException.class)).hasMessageContaining("The following keys have been changed in conflict:").hasMessageContaining(conflictingKey1.toString()).hasMessageNotContaining(conflictingKey2.toString());
        if (dryRun) {
            checkpoint.assertNoWrites();
        }
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)mergeFrom).fromHash(mergeFromHash).toBranch(mergeInto).putMergeKeyBehaviors(conflictingKey1, MergeKeyBehavior.of((ContentKey)conflictingKey1, (MergeBehavior)MergeBehavior.NORMAL)).defaultMergeBehavior(MergeBehavior.DROP).dryRun(dryRun).build())).isInstanceOf(ReferenceConflictException.class)).hasMessageContaining("The following keys have been changed in conflict:").hasMessageContaining(conflictingKey1.toString()).hasMessageNotContaining(conflictingKey2.toString());
        if (dryRun) {
            checkpoint.assertNoWrites();
        }
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)mergeFrom).fromHash(mergeFromHash).toBranch(mergeInto).putMergeKeyBehaviors(conflictingKey1, MergeKeyBehavior.of((ContentKey)conflictingKey1, (MergeBehavior)MergeBehavior.FORCE)).dryRun(dryRun).build())).isInstanceOf(ReferenceConflictException.class)).hasMessageContaining("The following keys have been changed in conflict:").hasMessageNotContaining(conflictingKey1.toString()).hasMessageContaining(conflictingKey2.toString());
        if (dryRun) {
            checkpoint.assertNoWrites();
        }
        Supplier<Hash> mergeIntoHeadSupplier = () -> {
            try {
                return this.store.getNamedRef(mergeInto.getName(), GetNamedRefsParams.DEFAULT).getHash();
            }
            catch (ReferenceNotFoundException e) {
                throw new RuntimeException(e);
            }
        };
        this.soft.assertThat((Object)mergeIntoHeadSupplier.get()).isEqualTo((Object)mergeIntoHead);
        if (!allForce) {
            MergeResult result = this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)mergeFrom).fromHash(mergeFromHash).toBranch(mergeInto).putMergeKeyBehaviors(conflictingKey1, MergeKeyBehavior.of((ContentKey)conflictingKey1, (MergeBehavior)MergeBehavior.FORCE)).putMergeKeyBehaviors(conflictingKey2, MergeKeyBehavior.of((ContentKey)conflictingKey2, (MergeBehavior)MergeBehavior.DROP)).build());
            ((MapAssert)((MapAssert)((MapAssert)this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store.getValues((Ref)mergeIntoHeadSupplier.get(), Arrays.asList(conflictingKey1, conflictingKey2, key3, key4)))).containsEntry((Object)conflictingKey1, (Object)VALUE_2)).containsEntry((Object)conflictingKey2, (Object)VALUE_3)).containsEntry((Object)key3, (Object)VALUE_5)).containsEntry((Object)key4, (Object)VALUE_6);
            ((ObjectAssert)this.soft.assertThat(result.getCreatedCommits()).singleElement()).satisfies(new ThrowingConsumer[]{commit -> {
                if (this.isNewStorageModel()) {
                    this.soft.assertThat(commit.getCommitMeta().getMessage()).isEmpty();
                } else {
                    ((StringAssert)this.soft.assertThat(commit.getCommitMeta().getMessage()).contains(new CharSequence[]{"commit 2"})).contains(new CharSequence[]{"commit 4"});
                }
                this.soft.assertThat((Object)commit.getParentHash()).isEqualTo((Object)mergeIntoHead);
                this.soft.assertThat(commit.getOperations()).satisfiesExactlyInAnyOrder(new ThrowingConsumer[]{op -> {
                    this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)conflictingKey1);
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_2);
                }, op -> {
                    this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)key3);
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_5);
                }});
            }});
        } else {
            MergeResult result2 = this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)mergeFrom).fromHash(mergeFromHash).toBranch(mergeInto).defaultMergeBehavior(MergeBehavior.FORCE).build());
            ((MapAssert)((MapAssert)((MapAssert)this.soft.assertThat(AbstractMerge.contentsWithoutId(this.store.getValues((Ref)mergeIntoHeadSupplier.get(), Arrays.asList(conflictingKey1, conflictingKey2, key3, key4)))).containsEntry((Object)conflictingKey1, (Object)VALUE_2)).containsEntry((Object)conflictingKey2, (Object)VALUE_4)).containsEntry((Object)key3, (Object)VALUE_5)).containsEntry((Object)key4, (Object)VALUE_6);
            ((ObjectAssert)this.soft.assertThat(result2.getCreatedCommits()).singleElement()).satisfies(new ThrowingConsumer[]{commit -> {
                if (this.isNewStorageModel()) {
                    this.soft.assertThat(commit.getCommitMeta().getMessage()).isEmpty();
                } else {
                    ((StringAssert)this.soft.assertThat(commit.getCommitMeta().getMessage()).contains(new CharSequence[]{"commit 2"})).contains(new CharSequence[]{"commit 4"});
                }
                this.soft.assertThat((Object)commit.getParentHash()).isEqualTo((Object)mergeIntoHead);
                this.soft.assertThat(commit.getOperations()).satisfiesExactlyInAnyOrder(new ThrowingConsumer[]{op -> {
                    this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)conflictingKey1);
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_2);
                }, op -> {
                    this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)conflictingKey2);
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_4);
                }, op -> {
                    this.soft.assertThat((Comparable)op.getKey()).isEqualTo((Object)key3);
                    this.soft.assertThat((Object)AbstractMerge.contentWithoutId(((Put)op).getValue())).isEqualTo((Object)VALUE_5);
                }});
            }});
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoConflictingBranch(boolean dryRun) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_3");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        this.commit("Another commit").put("t1", (Content)V_1_4).toBranch(newBranch);
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(newBranch).expectedHash(Optional.of(this.initialHash)).dryRun(dryRun).build())).isInstanceOf(ReferenceConflictException.class);
        if (dryRun) {
            checkpoint.assertNoWrites();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoNonExistingBranch(boolean dryRun) {
        BranchName newBranch = BranchName.of((String)"bar_5");
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(newBranch).expectedHash(Optional.of(this.initialHash)).dryRun(dryRun).build())).isInstanceOf(ReferenceNotFoundException.class);
        checkpoint.assertNoWrites();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoNonExistingReference(boolean dryRun) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_6");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(Hash.of((String)"1234567890abcdef")).toBranch(newBranch).expectedHash(Optional.of(this.initialHash)).dryRun(dryRun).build())).isInstanceOf(ReferenceNotFoundException.class);
        checkpoint.assertNoWrites();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeEmptyCommit(boolean dryRun) throws VersionStoreException {
        BranchName source = BranchName.of((String)"source");
        BranchName target = BranchName.of((String)"target");
        this.store().create((NamedRef)source, Optional.of(this.initialHash));
        this.store().create((NamedRef)target, Optional.of(this.initialHash));
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
        Hash targetHead = this.store().commit(target, Optional.empty(), CommitMeta.fromMessage((String)"target 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)VALUE_1))).getCommitHash();
        targetHead = this.store().commit(target, Optional.of(targetHead), CommitMeta.fromMessage((String)"target 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)VALUE_1))).getCommitHash();
        Hash sourceHead = this.store().commit(source, Optional.empty(), CommitMeta.fromMessage((String)"source 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)VALUE_2))).getCommitHash();
        sourceHead = this.store().commit(source, Optional.of(sourceHead), CommitMeta.fromMessage((String)"source 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)VALUE_2))).getCommitHash();
        this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)source).fromHash(sourceHead).toBranch(target).expectedHash(Optional.ofNullable(targetHead)).putMergeKeyBehaviors(key1, MergeKeyBehavior.of((ContentKey)key1, (MergeBehavior)MergeBehavior.DROP)).putMergeKeyBehaviors(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.DROP)).dryRun(dryRun).build());
        try (PaginationIterator iterator = this.store().getCommits((Ref)target, true);){
            Hash newTargetHead = ((Commit)iterator.next()).getHash();
            Assertions.assertThat((Object)newTargetHead).isEqualTo((Object)targetHead);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void mergeFromAndIntoHead(boolean dryRun) throws Exception {
        BranchName branch = BranchName.of((String)"source");
        this.store().create((NamedRef)branch, Optional.of(this.initialHash));
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
        Hash commit1 = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"commit 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)VALUE_1))).getCommitHash();
        Hash commit2 = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"commit 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)VALUE_2))).getCommitHash();
        if (this.isNewStorageModel()) {
            this.soft.assertThat((Object)this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)branch).fromHash(commit2).toBranch(branch).expectedHash(Optional.of(commit1)).dryRun(dryRun).build())).extracting(new Function[]{MergeResult::wasApplied, MergeResult::wasSuccessful, MergeResult::getResultantTargetHash, MergeResult::getCommonAncestor, MergeResult::getEffectiveTargetHash}).containsExactly(new Object[]{false, true, commit2, commit2, commit2});
        } else {
            this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)branch).fromHash(commit2).toBranch(branch).expectedHash(Optional.of(commit1)).dryRun(dryRun).build()));
            this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)branch).fromHash(commit1).toBranch(branch).expectedHash(Optional.of(commit2)).dryRun(dryRun).build()));
        }
    }
}

