/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractDiff
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;
    public static final OnRefOnly V_1 = OnRefOnly.newOnRef("v1");
    public static final OnRefOnly V_2 = OnRefOnly.newOnRef("v2");
    public static final OnRefOnly V_2_A = OnRefOnly.newOnRef("v2a");
    public static final OnRefOnly V_3 = OnRefOnly.newOnRef("v3");
    public static final OnRefOnly V_1_A = OnRefOnly.newOnRef("v1a");
    public static final IcebergTable V_12 = IcebergTable.of((String)"foo", (long)42L, (int)43, (int)44, (int)45);
    public static final IcebergTable V_22 = IcebergTable.of((String)"bar", (long)42L, (int)43, (int)44, (int)45);

    protected AbstractDiff(VersionStore store) {
        super(store);
    }

    @Test
    protected void checkDiffDifferentContents() throws VersionStoreException {
        BranchName branch1 = BranchName.of((String)"checkDiffOtherContent1");
        BranchName branch2 = BranchName.of((String)"checkDiffOtherContent2");
        this.store().create((NamedRef)branch1, Optional.empty());
        this.store().create((NamedRef)branch2, Optional.empty());
        Hash commit1 = this.commit("Commit1").put("k1", (Content)V_1).put("k2", (Content)V_2).toBranch(branch1);
        Hash commit2 = this.commit("Commit2").put("k1", (Content)V_12).put("k2", (Content)V_22).toBranch(branch2);
        ContentKey k1 = ContentKey.of((String[])new String[]{"k1"});
        ContentKey k2 = ContentKey.of((String[])new String[]{"k2"});
        Map contents1 = this.store().getValues((Ref)branch1, (Collection)Lists.newArrayList((Object[])new ContentKey[]{k1, k2}));
        IdentifiedContentKey ik11 = ((ContentResult)contents1.get(k1)).identifiedKey();
        IdentifiedContentKey ik12 = ((ContentResult)contents1.get(k2)).identifiedKey();
        Map contents2 = this.store().getValues((Ref)branch2, (Collection)Lists.newArrayList((Object[])new ContentKey[]{k1, k2}));
        IdentifiedContentKey ik21 = ((ContentResult)contents2.get(k1)).identifiedKey();
        IdentifiedContentKey ik22 = ((ContentResult)contents2.get(k2)).identifiedKey();
        List<Diff> diff = this.diffAsList(commit1, commit2);
        this.soft.assertThat(AbstractDiff.diffsWithoutContentId(diff)).extracting(new Function[]{Diff::getFromKey, Diff::getToKey, Diff::getFromValue, Diff::getToValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{ik11, ik21, Optional.of(V_1), Optional.of(V_12)}), Tuple.tuple((Object[])new Object[]{ik12, ik22, Optional.of(V_2), Optional.of(V_22)})});
    }

    @Test
    protected void checkDiffRename() throws VersionStoreException {
        BranchName branch1 = BranchName.of((String)"checkDiffRename");
        ContentKey k1 = ContentKey.of((String[])new String[]{"k1"});
        ContentKey k2 = ContentKey.of((String[])new String[]{"k2"});
        this.store().create((NamedRef)branch1, Optional.empty());
        Hash commit1 = this.commit("Commit1").put("k1", (Content)V_1).toBranch(branch1);
        ContentResult contents1 = this.store().getValue((Ref)commit1, k1);
        IdentifiedContentKey ik1 = contents1.identifiedKey();
        Content content = contents1.content();
        Hash commit2 = this.commit("Commit2").delete("k1").put("k2", content).toBranch(branch1);
        ContentResult contents2 = this.store().getValue((Ref)commit2, k2);
        IdentifiedContentKey ik2 = contents2.identifiedKey();
        List<Diff> diff = this.diffAsList(commit1, commit2);
        this.soft.assertThat(ik1.lastElement().contentId()).isEqualTo(content.getId());
        this.soft.assertThat(ik2.lastElement().contentId()).isEqualTo(content.getId());
        this.soft.assertThat(AbstractDiff.diffsWithoutContentId(diff)).extracting(new Function[]{Diff::getFromKey, Diff::getToKey, Diff::getFromValue, Diff::getToValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{ik1, null, Optional.of(V_1), Optional.empty()}), Tuple.tuple((Object[])new Object[]{null, ik2, Optional.empty(), Optional.of(V_1)})});
    }

    @Test
    protected void checkDiffDropAndCreate() throws VersionStoreException {
        BranchName branch1 = BranchName.of((String)"checkDiffReadd");
        ContentKey k1 = ContentKey.of((String[])new String[]{"k1"});
        ContentKey k2 = ContentKey.of((String[])new String[]{"k2"});
        this.store().create((NamedRef)branch1, Optional.empty());
        Hash commit1 = this.commit("Commit1").put("k1", (Content)V_1).toBranch(branch1);
        Hash commit2 = this.commit("Commit2").delete("k1").put("k2", (Content)V_2).toBranch(branch1);
        ContentResult contents1 = this.store().getValue((Ref)commit1, k1);
        IdentifiedContentKey ik1 = contents1.identifiedKey();
        Content content1 = contents1.content();
        ContentResult contents2 = this.store().getValue((Ref)commit2, k2);
        IdentifiedContentKey ik2 = contents2.identifiedKey();
        Content content2 = contents2.content();
        ((StringAssert)this.soft.assertThat(ik1.lastElement().contentId()).isEqualTo(content1.getId())).isNotEqualTo((Object)content2.getId());
        ((StringAssert)this.soft.assertThat(ik2.lastElement().contentId()).isEqualTo(content2.getId())).isNotEqualTo((Object)content1.getId());
        List<Diff> diff = this.diffAsList(commit1, commit2);
        this.soft.assertThat(AbstractDiff.diffsWithoutContentId(diff)).extracting(new Function[]{Diff::getFromKey, Diff::getToKey, Diff::getFromValue, Diff::getToValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{ik1, null, Optional.of(V_1), Optional.empty()}), Tuple.tuple((Object[])new Object[]{null, ik2, Optional.empty(), Optional.of(V_2)})});
    }

    @Test
    protected void checkDiffReadd() throws VersionStoreException {
        BranchName branch1 = BranchName.of((String)"checkDiffReadd");
        ContentKey k = ContentKey.of((String[])new String[]{"k"});
        this.store().create((NamedRef)branch1, Optional.empty());
        Hash commit1 = this.commit("Commit1").put("k", (Content)V_1).toBranch(branch1);
        Content content1 = this.store().getValue((Ref)commit1, k).content();
        this.commit("Commit2").delete("k").toBranch(branch1);
        Hash commit3 = this.commit("Commit3").put("k", (Content)V_2).toBranch(branch1);
        Content content3 = this.store().getValue((Ref)commit3, k).content();
        ContentResult contents1 = this.store().getValue((Ref)commit1, k);
        IdentifiedContentKey ik1 = contents1.identifiedKey();
        ContentResult contents2 = this.store().getValue((Ref)commit3, k);
        IdentifiedContentKey ik2 = contents2.identifiedKey();
        ((StringAssert)this.soft.assertThat(ik1.lastElement().contentId()).isEqualTo(content1.getId())).isNotEqualTo((Object)content3.getId());
        ((StringAssert)this.soft.assertThat(ik2.lastElement().contentId()).isEqualTo(content3.getId())).isNotEqualTo((Object)content1.getId());
        List<Diff> diff = this.diffAsList(commit1, commit3);
        this.soft.assertThat(AbstractDiff.diffsWithoutContentId(diff)).extracting(new Function[]{Diff::getFromKey, Diff::getToKey, Diff::getFromValue, Diff::getToValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{ik1, ik2, Optional.of(V_1), Optional.of(V_2)})});
    }

    @Test
    protected void checkDiff() throws VersionStoreException {
        BranchName branch = BranchName.of((String)"checkDiff");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash initial = this.store().hashOnReference((NamedRef)branch, Optional.empty(), Collections.emptyList());
        ContentKey k1 = ContentKey.of((String[])new String[]{"k1"});
        ContentKey k2 = ContentKey.of((String[])new String[]{"k2"});
        ContentKey k3 = ContentKey.of((String[])new String[]{"k3"});
        ContentKey k1a = ContentKey.of((String[])new String[]{"k1a"});
        Hash firstCommit = this.commit("First Commit").put("k1", (Content)V_1).put("k2", (Content)V_2).toBranch(branch);
        Content k2content = this.store().getValue((Ref)branch, ContentKey.of((String[])new String[]{"k2"})).content();
        Hash secondCommit = this.commit("Second Commit").put("k2", (Content)V_2_A.withId(k2content.getId())).put("k3", (Content)V_3).put("k1a", (Content)V_1_A).toBranch(branch);
        Map contents = this.store().getValues((Ref)branch, (Collection)Lists.newArrayList((Object[])new ContentKey[]{k1, k2, k3, k1a}));
        IdentifiedContentKey ik1 = ((ContentResult)contents.get(k1)).identifiedKey();
        IdentifiedContentKey ik2 = ((ContentResult)contents.get(k2)).identifiedKey();
        IdentifiedContentKey ik3 = ((ContentResult)contents.get(k3)).identifiedKey();
        IdentifiedContentKey ik1a = ((ContentResult)contents.get(k1a)).identifiedKey();
        List<Diff> startToSecond = this.diffAsList(initial, secondCommit);
        this.soft.assertThat(AbstractDiff.diffsWithoutContentId(startToSecond)).extracting(new Function[]{Diff::getFromKey, Diff::getToKey, Diff::getFromValue, Diff::getToValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{null, ik1, Optional.empty(), Optional.of(V_1)}), Tuple.tuple((Object[])new Object[]{null, ik2, Optional.empty(), Optional.of(V_2_A)}), Tuple.tuple((Object[])new Object[]{null, ik3, Optional.empty(), Optional.of(V_3)}), Tuple.tuple((Object[])new Object[]{null, ik1a, Optional.empty(), Optional.of(V_1_A)})});
        List<Diff> secondToStart = this.diffAsList(secondCommit, initial);
        this.soft.assertThat(AbstractDiff.diffsWithoutContentId(secondToStart)).extracting(new Function[]{Diff::getFromKey, Diff::getToKey, Diff::getFromValue, Diff::getToValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{ik1, null, Optional.of(V_1), Optional.empty()}), Tuple.tuple((Object[])new Object[]{ik2, null, Optional.of(V_2_A), Optional.empty()}), Tuple.tuple((Object[])new Object[]{ik3, null, Optional.of(V_3), Optional.empty()}), Tuple.tuple((Object[])new Object[]{ik1a, null, Optional.of(V_1_A), Optional.empty()})});
        List<Diff> firstToSecond = this.diffAsList(firstCommit, secondCommit);
        this.soft.assertThat(AbstractDiff.diffsWithoutContentId(firstToSecond)).extracting(new Function[]{Diff::getFromKey, Diff::getToKey, Diff::getFromValue, Diff::getToValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{null, ik1a, Optional.empty(), Optional.of(V_1_A)}), Tuple.tuple((Object[])new Object[]{ik2, ik2, Optional.of(V_2), Optional.of(V_2_A)}), Tuple.tuple((Object[])new Object[]{null, ik3, Optional.empty(), Optional.of(V_3)})});
        List<Diff> secondToFirst = this.diffAsList(secondCommit, firstCommit);
        this.soft.assertThat(AbstractDiff.diffsWithoutContentId(secondToFirst)).extracting(new Function[]{Diff::getFromKey, Diff::getToKey, Diff::getFromValue, Diff::getToValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{ik1a, null, Optional.of(V_1_A), Optional.empty()}), Tuple.tuple((Object[])new Object[]{ik2, ik2, Optional.of(V_2_A), Optional.of(V_2)}), Tuple.tuple((Object[])new Object[]{ik3, null, Optional.of(V_3), Optional.empty()})});
        this.soft.assertThat(this.diffAsList(firstCommit, firstCommit)).isEmpty();
        this.soft.assertThat(this.diffAsList(initial, secondCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().minKey(ContentKey.of((String[])new String[]{"k"})).maxKey(ContentKey.of((String[])new String[]{"l"})).build())).extracting(new Function[]{Diff::getFromKey, Diff::getToKey}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{null, ik1}), Tuple.tuple((Object[])new Object[]{null, ik2}), Tuple.tuple((Object[])new Object[]{null, ik3}), Tuple.tuple((Object[])new Object[]{null, ik1a})});
        this.soft.assertThat(this.diffAsList(initial, secondCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().minKey(ContentKey.of((String[])new String[]{"k"})).build())).extracting(new Function[]{Diff::getFromKey, Diff::getToKey}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{null, ik1}), Tuple.tuple((Object[])new Object[]{null, ik2}), Tuple.tuple((Object[])new Object[]{null, ik3}), Tuple.tuple((Object[])new Object[]{null, ik1a})});
        this.soft.assertThat(this.diffAsList(initial, secondCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().maxKey(k2).build())).extracting(new Function[]{Diff::getFromKey, Diff::getToKey}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{null, ik1}), Tuple.tuple((Object[])new Object[]{null, ik2}), Tuple.tuple((Object[])new Object[]{null, ik1a})});
        this.soft.assertThat(this.diffAsList(initial, secondCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().minKey(k1a).maxKey(k2).build())).extracting(new Function[]{Diff::getFromKey, Diff::getToKey}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{null, ik1a}), Tuple.tuple((Object[])new Object[]{null, ik2})});
        this.soft.assertThat(this.diffAsList(initial, secondCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().minKey(k2).maxKey(k2).build())).extracting(new Function[]{Diff::getFromKey, Diff::getToKey}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{null, ik2})});
        this.soft.assertThat(this.diffAsList(initial, secondCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().minKey(ContentKey.of((String[])new String[]{"k4"})).maxKey(ContentKey.of((String[])new String[]{"l"})).build())).isEmpty();
        this.soft.assertThat(this.diffAsList(initial, secondCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().prefixKey(ContentKey.of((String[])new String[]{"k1"})).build())).extracting(new Function[]{Diff::getFromKey, Diff::getToKey}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{null, ik1})});
        this.soft.assertThat(this.diffAsList(initial, secondCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().prefixKey(ContentKey.of((String[])new String[]{"k"})).build())).extracting(new Function[]{Diff::getFromKey, Diff::getToKey}).isEmpty();
        this.soft.assertThat(this.diffAsList(initial, secondCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().prefixKey(ContentKey.of((String[])new String[]{"x"})).build())).isEmpty();
        this.soft.assertThat(this.diffAsList(initial, secondCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().contentKeyPredicate((k, t) -> k1.equals(k) || k3.equals(k)).build())).extracting(new Function[]{Diff::getFromKey, Diff::getToKey}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{null, ik1}), Tuple.tuple((Object[])new Object[]{null, ik3})});
        this.soft.assertThat(this.diffAsList(initial, secondCommit, (VersionStore.KeyRestrictions)VersionStore.KeyRestrictions.builder().contentKeyPredicate((k, t) -> false).build())).isEmpty();
    }

    private List<Diff> diffAsList(Hash initial, Hash secondCommit) throws ReferenceNotFoundException {
        return this.diffAsList(initial, secondCommit, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS);
    }

    private List<Diff> diffAsList(Hash initial, Hash secondCommit, VersionStore.KeyRestrictions keyRestrictions) throws ReferenceNotFoundException {
        try (PaginationIterator diffStream = this.store().getDiffs((Ref)initial, (Ref)secondCommit, null, keyRestrictions);){
            ArrayList<Diff> r = new ArrayList<Diff>();
            diffStream.forEachRemaining(r::add);
            ArrayList<Diff> arrayList = r;
            return arrayList;
        }
    }
}

