/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.error.ReferenceConflicts;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeConflictException;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.tests.StorageAssertions;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractMerge
extends AbstractNestedVersionStore {
    public static final BranchName MAIN_BRANCH = BranchName.of((String)"foo");
    @InjectSoftAssertions
    protected SoftAssertions soft;
    private static final OnRefOnly V_1_1 = OnRefOnly.newOnRef("v1_1");
    private static final OnRefOnly V_1_2 = OnRefOnly.newOnRef("v1_2");
    private static final OnRefOnly V_1_4 = OnRefOnly.newOnRef("v1_4");
    private static final OnRefOnly V_2_1 = OnRefOnly.newOnRef("v2_1");
    private static final OnRefOnly V_2_2 = OnRefOnly.newOnRef("v2_2");
    private static final OnRefOnly V_3_1 = OnRefOnly.newOnRef("v3_1");
    private static final OnRefOnly V_4_1 = OnRefOnly.newOnRef("v4_1");
    private static final OnRefOnly VALUE_1 = OnRefOnly.newOnRef("value1");
    private static final OnRefOnly VALUE_2 = OnRefOnly.newOnRef("value2");
    private Hash initialHash;
    private Hash firstCommit;
    private Hash thirdCommit;

    protected AbstractMerge(VersionStore store) {
        super(store);
    }

    @BeforeEach
    protected void setupCommits() throws VersionStoreException {
        this.store().create((NamedRef)MAIN_BRANCH, Optional.empty());
        this.initialHash = this.commit("Default common ancestor").toBranch(MAIN_BRANCH);
        this.firstCommit = this.commit("First Commit").put("t1", (Content)V_1_1).put("t2", (Content)V_2_1).put("t3", (Content)V_3_1).toBranch(MAIN_BRANCH);
        Content t1 = this.store().getValue((Ref)MAIN_BRANCH, ContentKey.of((String[])new String[]{"t1"})).content();
        this.commit("Second Commit").put("t1", (Content)V_1_2.withId(t1.getId())).delete("t2").delete("t3").put("t4", (Content)V_4_1).toBranch(MAIN_BRANCH);
        this.thirdCommit = this.commit("Third Commit").put("t2", (Content)V_2_2).unchanged("t4").toBranch(MAIN_BRANCH);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeKeyBehaviorValidation(boolean dryRun) throws Exception {
        BranchName targetBranch = BranchName.of((String)"mergeKeyBehaviorValidation");
        this.store().create((NamedRef)targetBranch, Optional.of(this.firstCommit));
        ContentKey keyNotUsed = ContentKey.of((String[])new String[]{"not", "used"});
        ContentKey keyUnused = ContentKey.of((String[])new String[]{"un", "used"});
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(targetBranch).putMergeKeyBehaviors(keyNotUsed, MergeKeyBehavior.of((ContentKey)keyNotUsed, (MergeBehavior)MergeBehavior.DROP)).putMergeKeyBehaviors(keyUnused, MergeKeyBehavior.of((ContentKey)keyUnused, (MergeBehavior)MergeBehavior.DROP)).dryRun(dryRun).build())).withMessage("Not all merge key behaviors specified in the request have been used. The following keys were not used: [not.used, un.used]");
        ContentKey keyT3 = ContentKey.of((String[])new String[]{"t3"});
        for (MergeBehavior mergeBehavior : new MergeBehavior[]{MergeBehavior.DROP, MergeBehavior.FORCE}) {
            this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(targetBranch).putMergeKeyBehaviors(keyT3, MergeKeyBehavior.of((ContentKey)keyT3, (MergeBehavior)mergeBehavior, (Content)V_3_1, (Content)V_1_1)).dryRun(dryRun).build())).withMessage("MergeKeyBehavior.resolvedContent must be null for MergeBehavior.%s for t3", new Object[]{mergeBehavior});
        }
        Content c11 = this.store().getValue((Ref)this.firstCommit, ContentKey.of((String[])new String[]{"t1"})).content();
        for (MergeBehavior mergeBehavior : new MergeBehavior[]{MergeBehavior.NORMAL, MergeBehavior.FORCE}) {
            StorageAssertions checkpoint = this.storageCheckpoint();
            ((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(targetBranch).putMergeKeyBehaviors(keyT3, MergeKeyBehavior.of((ContentKey)keyT3, (MergeBehavior)mergeBehavior, (Content)c11, null)).dryRun(dryRun).build())).describedAs("MergeBehavior.%s", new Object[]{mergeBehavior})).hasMessage("The following keys have been changed in conflict: 't3'").asInstanceOf(InstanceOfAssertFactories.type(MergeConflictException.class))).extracting(MergeConflictException::getMergeResult).extracting(new Function[]{MergeResult::wasApplied, MergeResult::wasSuccessful, r -> r.getDetails().get(keyT3)}).containsExactly(new Object[]{false, false, MergeResult.KeyDetails.keyDetails((MergeBehavior)mergeBehavior, (Conflict)Conflict.conflict((Conflict.ConflictType)Conflict.ConflictType.VALUE_DIFFERS, (ContentKey)keyT3, (String)"values of existing and expected content for key 't3' are different"))});
            checkpoint.assertNoWrites();
            this.soft.assertAll();
        }
    }

    @Test
    protected void mergeResolveConflict() throws VersionStoreException {
        BranchName sourceBranch = BranchName.of((String)"mergeResolveConflict");
        this.store().create((NamedRef)sourceBranch, Optional.of(this.thirdCommit));
        ContentKey key2 = ContentKey.of((String[])new String[]{"t2"});
        Content contentT2 = this.store().getValue((Ref)MAIN_BRANCH, key2).content();
        Hash targetHead = this.commit("on-target-commit").put("t2", (Content)OnRefOnly.onRef("v2_2-target", contentT2.getId())).toBranch(MAIN_BRANCH);
        Hash sourceHead = this.commit("on-source-commit").put("t2", (Content)OnRefOnly.onRef("v2_2-source", contentT2.getId())).toBranch(sourceBranch);
        contentT2 = this.store().getValue((Ref)MAIN_BRANCH, key2).content();
        this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)sourceBranch).fromHash(sourceHead).toBranch(MAIN_BRANCH).build())).isInstanceOf(MergeConflictException.class);
        OnRefOnly resolvedContent = OnRefOnly.onRef("resolved", contentT2.getId());
        OnRefOnly wrongExpectedContent = OnRefOnly.onRef("wrong", contentT2.getId());
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)sourceBranch).fromHash(sourceHead).toBranch(MAIN_BRANCH).putMergeKeyBehaviors(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.NORMAL, (Content)wrongExpectedContent, (Content)resolvedContent)).build())).isInstanceOf(ReferenceConflictException.class)).asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).containsExactly((Object[])new Conflict[]{Conflict.conflict((Conflict.ConflictType)Conflict.ConflictType.VALUE_DIFFERS, (ContentKey)key2, (String)"values of existing and expected content for key 't2' are different")});
        this.soft.assertThatIllegalArgumentException().isThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)sourceBranch).fromHash(sourceHead).toBranch(MAIN_BRANCH).putMergeKeyBehaviors(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.NORMAL, null, (Content)resolvedContent)).build())).withMessage("MergeKeyBehavior.resolvedContent requires setting MergeKeyBehavior.expectedTarget as well for key t2");
        MergeResult result = this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)sourceBranch).fromHash(sourceHead).toBranch(MAIN_BRANCH).putMergeKeyBehaviors(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.NORMAL, (Content)contentT2, (Content)resolvedContent)).build());
        ReferenceInfo branch = this.store().getNamedRef(MAIN_BRANCH.getName(), GetNamedRefsParams.DEFAULT);
        this.soft.assertThat((Object)result).extracting(new Function[]{MergeResult::wasApplied, MergeResult::wasSuccessful, MergeResult::getResultantTargetHash, MergeResult::getCommonAncestor, MergeResult::getEffectiveTargetHash}).containsExactly(new Object[]{true, true, branch.getHash(), this.thirdCommit, targetHead});
        Content mergedContent = this.store().getValue((Ref)MAIN_BRANCH, key2).content();
        this.soft.assertThat((Object)mergedContent).isEqualTo((Object)resolvedContent);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoConflictingBranch(boolean dryRun) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_3");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        this.commit("Another commit").put("t1", (Content)V_1_4).toBranch(newBranch);
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(newBranch).expectedHash(Optional.of(this.initialHash)).dryRun(dryRun).build())).isInstanceOf(ReferenceConflictException.class);
        if (dryRun) {
            checkpoint.assertNoWrites();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoNonExistingBranch(boolean dryRun) {
        BranchName newBranch = BranchName.of((String)"bar_5");
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(this.thirdCommit).toBranch(newBranch).expectedHash(Optional.of(this.initialHash)).dryRun(dryRun).build())).isInstanceOf(ReferenceNotFoundException.class);
        checkpoint.assertNoWrites();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeIntoNonExistingReference(boolean dryRun) throws VersionStoreException {
        BranchName newBranch = BranchName.of((String)"bar_6");
        this.store().create((NamedRef)newBranch, Optional.of(this.initialHash));
        StorageAssertions checkpoint = this.storageCheckpoint();
        this.soft.assertThatThrownBy(() -> this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)MAIN_BRANCH).fromHash(Hash.of((String)"1234567890abcdef")).toBranch(newBranch).expectedHash(Optional.of(this.initialHash)).dryRun(dryRun).build())).isInstanceOf(ReferenceNotFoundException.class);
        checkpoint.assertNoWrites();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    protected void mergeEmptyCommit(boolean dryRun) throws VersionStoreException {
        BranchName source = BranchName.of((String)"source");
        BranchName target = BranchName.of((String)"target");
        this.store().create((NamedRef)source, Optional.of(this.initialHash));
        this.store().create((NamedRef)target, Optional.of(this.initialHash));
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
        Hash targetHead = this.store().commit(target, Optional.empty(), CommitMeta.fromMessage((String)"target 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)VALUE_1))).getCommitHash();
        targetHead = this.store().commit(target, Optional.of(targetHead), CommitMeta.fromMessage((String)"target 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)VALUE_1))).getCommitHash();
        Hash sourceHead = this.store().commit(source, Optional.empty(), CommitMeta.fromMessage((String)"source 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)VALUE_2))).getCommitHash();
        sourceHead = this.store().commit(source, Optional.of(sourceHead), CommitMeta.fromMessage((String)"source 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)VALUE_2))).getCommitHash();
        this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)source).fromHash(sourceHead).toBranch(target).expectedHash(Optional.ofNullable(targetHead)).putMergeKeyBehaviors(key1, MergeKeyBehavior.of((ContentKey)key1, (MergeBehavior)MergeBehavior.DROP)).putMergeKeyBehaviors(key2, MergeKeyBehavior.of((ContentKey)key2, (MergeBehavior)MergeBehavior.DROP)).dryRun(dryRun).build());
        try (PaginationIterator iterator = this.store().getCommits((Ref)target, true);){
            Hash newTargetHead = ((Commit)iterator.next()).getHash();
            Assertions.assertThat((Object)newTargetHead).isEqualTo((Object)targetHead);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void mergeFromAndIntoHead(boolean dryRun) throws Exception {
        BranchName branch = BranchName.of((String)"source");
        this.store().create((NamedRef)branch, Optional.of(this.initialHash));
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
        Hash commit1 = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"commit 1"), Collections.singletonList(Put.of((ContentKey)key1, (Content)VALUE_1))).getCommitHash();
        Hash commit2 = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"commit 2"), Collections.singletonList(Put.of((ContentKey)key2, (Content)VALUE_2))).getCommitHash();
        this.soft.assertThat((Object)this.store().merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)branch).fromHash(commit2).toBranch(branch).expectedHash(Optional.of(commit1)).dryRun(dryRun).build())).extracting(new Function[]{MergeResult::wasApplied, MergeResult::wasSuccessful, MergeResult::getResultantTargetHash, MergeResult::getCommonAncestor, MergeResult::getEffectiveTargetHash}).containsExactly(new Object[]{false, true, commit2, commit2, commit2});
    }
}

