/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;

public abstract class AbstractReferenceNotFound
extends AbstractNestedVersionStore {
    protected AbstractReferenceNotFound(VersionStore store) {
        super(store);
    }

    static List<ReferenceNotFoundFunction> referenceNotFoundFunctions() {
        return Arrays.asList(new ReferenceNotFoundFunction("getCommits/branch").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.getCommits((Ref)BranchName.of((String)"this-one-should-not-exist"), false)), new ReferenceNotFoundFunction("getCommits/tag").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.getCommits((Ref)TagName.of((String)"this-one-should-not-exist"), false)), new ReferenceNotFoundFunction("getCommits/hash").msg("Commit '12341234123412341234123412341234123412341234' not found").function(s -> s.getCommits((Ref)Hash.of((String)"12341234123412341234123412341234123412341234"), false)), new ReferenceNotFoundFunction("getValue/branch").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.getValue((Ref)BranchName.of((String)"this-one-should-not-exist"), ContentKey.of((String[])new String[]{"foo"}))), new ReferenceNotFoundFunction("getValue/tag").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.getValue((Ref)TagName.of((String)"this-one-should-not-exist"), ContentKey.of((String[])new String[]{"foo"}))), new ReferenceNotFoundFunction("getValue/hash").msg("Commit '12341234123412341234123412341234123412341234' not found").function(s -> s.getValue((Ref)Hash.of((String)"12341234123412341234123412341234123412341234"), ContentKey.of((String[])new String[]{"foo"}))), new ReferenceNotFoundFunction("getValues/branch").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.getValues((Ref)BranchName.of((String)"this-one-should-not-exist"), Collections.singletonList(ContentKey.of((String[])new String[]{"foo"})))), new ReferenceNotFoundFunction("getValues/tag").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.getValues((Ref)TagName.of((String)"this-one-should-not-exist"), Collections.singletonList(ContentKey.of((String[])new String[]{"foo"})))), new ReferenceNotFoundFunction("getValues/hash").msg("Commit '12341234123412341234123412341234123412341234' not found").function(s -> s.getValues((Ref)Hash.of((String)"12341234123412341234123412341234123412341234"), Collections.singletonList(ContentKey.of((String[])new String[]{"foo"})))), new ReferenceNotFoundFunction("getKeys/branch").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.getKeys((Ref)BranchName.of((String)"this-one-should-not-exist"), null, false, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS)), new ReferenceNotFoundFunction("getKeys/tag").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.getKeys((Ref)TagName.of((String)"this-one-should-not-exist"), null, false, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS)), new ReferenceNotFoundFunction("getKeys/hash").msg("Commit '12341234123412341234123412341234123412341234' not found").function(s -> s.getKeys((Ref)Hash.of((String)"12341234123412341234123412341234123412341234"), null, false, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS)), new ReferenceNotFoundFunction("assign/branch/ok").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.assign((NamedRef)BranchName.of((String)"this-one-should-not-exist"), s.noAncestorHash(), s.noAncestorHash())), new ReferenceNotFoundFunction("assign/hash").msg("Commit '12341234123412341234123412341234123412341234' not found").function(s -> s.assign((NamedRef)BranchName.of((String)"main"), s.noAncestorHash(), Hash.of((String)"12341234123412341234123412341234123412341234"))), new ReferenceNotFoundFunction("delete/branch").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.delete((NamedRef)BranchName.of((String)"this-one-should-not-exist"), s.noAncestorHash())), new ReferenceNotFoundFunction("delete/tag").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.delete((NamedRef)BranchName.of((String)"this-one-should-not-exist"), s.noAncestorHash())), new ReferenceNotFoundFunction("create/hash").msg("Commit '12341234123412341234123412341234123412341234' not found").function(s -> s.create((NamedRef)BranchName.of((String)"foo"), Optional.of(Hash.of((String)"12341234123412341234123412341234123412341234")))), new ReferenceNotFoundFunction("commit/branch").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.commit(BranchName.of((String)"this-one-should-not-exist"), Optional.empty(), CommitMeta.fromMessage((String)"meta"), Collections.singletonList(Delete.of((ContentKey)ContentKey.of((String[])new String[]{"meep"}))))), new ReferenceNotFoundFunction("commit/hash").msg("Could not find commit '12341234123412341234123412341234123412341234' in reference 'main'.").function(s -> s.commit(BranchName.of((String)"main"), Optional.of(Hash.of((String)"12341234123412341234123412341234123412341234")), CommitMeta.fromMessage((String)"meta"), Collections.singletonList(Delete.of((ContentKey)ContentKey.of((String[])new String[]{"meep"}))))), new ReferenceNotFoundFunction("transplant/branch/ok").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.transplant((VersionStore.TransplantOp)VersionStore.TransplantOp.builder().fromRef((NamedRef)BranchName.of((String)"source")).toBranch(BranchName.of((String)"this-one-should-not-exist")).addSequenceToTransplant(s.hashOnReference((NamedRef)BranchName.of((String)"main"), Optional.empty(), Collections.emptyList())).build())), new ReferenceNotFoundFunction("transplant/hash/empty").msg("Could not find commit '12341234123412341234123412341234123412341234' in reference 'main'.").function(s -> s.transplant((VersionStore.TransplantOp)VersionStore.TransplantOp.builder().fromRef((NamedRef)BranchName.of((String)"source")).toBranch(BranchName.of((String)"main")).expectedHash(Optional.of(Hash.of((String)"12341234123412341234123412341234123412341234"))).addSequenceToTransplant(Hash.of((String)"12341234123412341234123412341234123412341234")).build())), new ReferenceNotFoundFunction("transplant/empty/hash").msg("Commit '12341234123412341234123412341234123412341234' not found").function(s -> s.transplant((VersionStore.TransplantOp)VersionStore.TransplantOp.builder().fromRef((NamedRef)BranchName.of((String)"source")).toBranch(BranchName.of((String)"main")).addSequenceToTransplant(Hash.of((String)"12341234123412341234123412341234123412341234")).build())), new ReferenceNotFoundFunction("diff/from-hash").msg("Commit '12341234123412341234123412341234123412341234' not found").function(s -> s.getDiffs((Ref)Hash.of((String)"12341234123412341234123412341234123412341234"), (Ref)BranchName.of((String)"main"), null, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS)), new ReferenceNotFoundFunction("diff/to-branch").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.getDiffs((Ref)BranchName.of((String)"main"), (Ref)BranchName.of((String)"this-one-should-not-exist"), null, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS)), new ReferenceNotFoundFunction("diff/from-hash").msg("Commit '12341234123412341234123412341234123412341234' not found").function(s -> s.getDiffs((Ref)Hash.of((String)"12341234123412341234123412341234123412341234"), (Ref)BranchName.of((String)"main"), null, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS)), new ReferenceNotFoundFunction("diff/from-branch").msg("Named reference 'this-one-should-not-exist' not found").function(s -> s.getDiffs((Ref)BranchName.of((String)"this-one-should-not-exist"), (Ref)BranchName.of((String)"main"), null, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS)), new ReferenceNotFoundFunction("merge/hash/empty").msg("Commit '12341234123412341234123412341234123412341234' not found").function(s -> s.merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)BranchName.of((String)"source")).fromHash(Hash.of((String)"12341234123412341234123412341234123412341234")).toBranch(BranchName.of((String)"main")).build())), new ReferenceNotFoundFunction("merge/empty/hash").msg("Could not find commit '12341234123412341234123412341234123412341234' in reference 'main'.").function(s -> s.merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)BranchName.of((String)"source")).fromHash(s.noAncestorHash()).toBranch(BranchName.of((String)"main")).expectedHash(Optional.of(Hash.of((String)"12341234123412341234123412341234123412341234"))).build())), new ReferenceNotFoundFunction("merge/hash/empty").msg("Commit '12341234123412341234123412341234123412341234' not found").function(s -> s.merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)BranchName.of((String)"source")).fromHash(Hash.of((String)"12341234123412341234123412341234123412341234")).toBranch(BranchName.of((String)"main")).build())), new ReferenceNotFoundFunction("merge/empty/hash").msg("Could not find commit '12341234123412341234123412341234123412341234' in reference 'main'.").function(s -> s.merge((VersionStore.MergeOp)VersionStore.MergeOp.builder().fromRef((NamedRef)BranchName.of((String)"source")).fromHash(s.noAncestorHash()).toBranch(BranchName.of((String)"main")).expectedHash(Optional.of(Hash.of((String)"12341234123412341234123412341234123412341234"))).build())));
    }

    @ParameterizedTest
    @MethodSource(value={"referenceNotFoundFunctions"})
    void referenceNotFound(ReferenceNotFoundFunction f) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> f.function.run(this.store())).isInstanceOf(ReferenceNotFoundException.class)).hasMessage(f.msg);
    }

    private static class ReferenceNotFoundFunction {
        final String name;
        String msg;
        ThrowingFunction function;

        ReferenceNotFoundFunction(String name) {
            this.name = name;
        }

        ReferenceNotFoundFunction function(ThrowingFunction function) {
            this.function = function;
            return this;
        }

        ReferenceNotFoundFunction msg(String msg) {
            this.msg = msg;
            return this;
        }

        public String toString() {
            return this.name;
        }

        @FunctionalInterface
        static interface ThrowingFunction {
            public void run(VersionStore var1) throws VersionStoreException;
        }
    }
}

