/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.tests.CommitBuilder;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractCommitLog
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected AbstractCommitLog(VersionStore store) {
        super(store);
    }

    @Test
    public void commitLogPaging() throws Exception {
        List logPage;
        BranchName branch = BranchName.of((String)"commitLogPaging");
        Hash createHash = this.store().create((NamedRef)branch, Optional.empty()).getHash();
        int commits = 95;
        Hash[] commitHashes = new Hash[commits];
        ArrayList<ImmutableCommitMeta> messages = new ArrayList<ImmutableCommitMeta>(commits);
        for (int i = 0; i < commits; ++i) {
            String str = String.format("commit#%05d", i);
            ImmutableCommitMeta.Builder msg = CommitMeta.builder().message(str);
            ContentKey key = ContentKey.of((String[])new String[]{"table"});
            Hash parent = i == 0 ? createHash : commitHashes[i - 1];
            ContentResult value = this.store().getValue((Ref)this.store().hashOnReference((NamedRef)branch, Optional.of(parent), Collections.emptyList()), key, false);
            Put op = value != null ? Put.of((ContentKey)key, (Content)OnRefOnly.onRef(str, Objects.requireNonNull(value.content()).getId())) : Put.of((ContentKey)key, (Content)OnRefOnly.newOnRef(str));
            commitHashes[i] = this.store().commit(branch, Optional.of(parent), (CommitMeta)msg.build(), (List)ImmutableList.of((Object)op)).getCommitHash();
            messages.add(msg.hash(commitHashes[i].asString()).addParentCommitHashes(parent.asString()).build());
        }
        Collections.reverse(messages);
        List<CommitMeta> justTwo = this.commitsListMap((Ref)branch, 2, Commit::getCommitMeta);
        this.soft.assertThat(justTwo).isEqualTo(messages.subList(0, 2));
        List<CommitMeta> justTen = this.commitsListMap((Ref)branch, 10, Commit::getCommitMeta);
        this.soft.assertThat(justTen).isEqualTo(messages.subList(0, 10));
        int pageSize = 10;
        this.soft.assertThat(commits % (pageSize - 1)).isNotEqualTo(0);
        Hash lastHash = null;
        int offset = 0;
        do {
            logPage = this.commitsListMap((Ref)(lastHash == null ? branch : lastHash), pageSize, Function.identity());
            this.soft.assertThat(logPage.stream().map(Commit::getCommitMeta).collect(Collectors.toList())).isEqualTo(messages.subList(offset, Math.min(offset + pageSize, commits)));
            lastHash = ((Commit)logPage.get(logPage.size() - 1)).getHash();
        } while ((offset += pageSize - 1) < commits);
        logPage = this.commitsListMap((Ref)lastHash, pageSize, Function.identity());
        this.soft.assertThat(logPage.stream().map(Commit::getCommitMeta).collect(Collectors.toList())).isEqualTo(Collections.singletonList((CommitMeta)messages.get(commits - 1)));
    }

    @Test
    public void commitLogExtended() throws Exception {
        int i;
        BranchName branch = BranchName.of((String)"commitLogExtended");
        Hash firstParent = this.store().create((NamedRef)branch, Optional.empty()).getHash();
        int numCommits = 10;
        CommitBuilder init = this.commit("initial");
        ArrayList<Hash> hashes = new ArrayList<Hash>();
        for (i = 1; i <= numCommits; ++i) {
            init = init.put("delete" + i, (Content)OnRefOnly.newOnRef("to delete " + i));
        }
        hashes.add(init.toBranch(branch));
        for (i = 1; i <= numCommits; ++i) {
            Hash head = this.commit("Commit #" + i).put("k" + i, (Content)OnRefOnly.newOnRef("v" + i)).put("key" + i, (Content)OnRefOnly.newOnRef("value" + i)).delete("delete" + i).toBranch(branch);
            hashes.add(head);
        }
        List parentHashes = Stream.concat(Stream.of(firstParent), hashes.stream()).collect(Collectors.toList());
        ((ListAssert)this.soft.assertThat(Lists.reverse(this.commitsList((Ref)branch, false))).allSatisfy(c -> {
            Assertions.assertThat((List)c.getOperations()).isNull();
            Assertions.assertThat((Object)c.getParentHash()).isNotNull();
        })).extracting(Commit::getHash).containsExactlyElementsOf(hashes);
        List commits = Lists.reverse(this.commitsList((Ref)branch, true));
        for (int i2 = 1; i2 <= numCommits; ++i2) {
            Commit c2 = (Commit)commits.get(i2);
            ((ObjectAssert)this.soft.assertThat((Object)c2.getCommitMeta()).describedAs("Commit number %s", new Object[]{i2})).satisfiesAnyOf(new ThrowingConsumer[]{cm -> Assertions.assertThat((String)cm.getHash()).isNull(), cm -> Assertions.assertThat((String)cm.getHash()).isEqualTo(c2.getHash().asString())});
            ((ObjectAssert)this.soft.assertThat((Object)c2).describedAs("Commit number %s", new Object[]{i2})).extracting(new Function[]{Commit::getHash, Commit::getParentHash, commit -> AbstractCommitLog.operationsWithoutContentId(commit.getOperations())}).containsExactly(new Object[]{hashes.get(i2), parentHashes.get(i2), Arrays.asList(Delete.of((ContentKey)ContentKey.of((String[])new String[]{"delete" + i2})), Put.of((ContentKey)ContentKey.of((String[])new String[]{"k" + i2}), (Content)OnRefOnly.newOnRef("v" + i2)), Put.of((ContentKey)ContentKey.of((String[])new String[]{"key" + i2}), (Content)OnRefOnly.newOnRef("value" + i2)))});
        }
    }
}

