/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.Namespace;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractContents
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected AbstractContents(VersionStore store) {
        super(store);
    }

    @Test
    public void getValueNonExisting() throws Exception {
        BranchName branch = BranchName.of((String)"empty-branch");
        this.store().create((NamedRef)branch, Optional.empty());
        Hash hash = this.store().hashOnReference((NamedRef)branch, Optional.empty(), Collections.emptyList());
        ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
        ContentKey keyNs = ContentKey.of((String[])new String[]{"ns"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"ns", "key2"});
        IdentifiedContentKey notFoundIdentifiedKey1 = IdentifiedContentKey.identifiedContentKeyFromContent((ContentKey)key1, null, null, l -> null);
        IdentifiedContentKey notFoundIdentifiedKey2 = IdentifiedContentKey.identifiedContentKeyFromContent((ContentKey)key2, null, null, l -> null);
        this.soft.assertThat((Object)this.store().getValue((Ref)hash, key1, false)).isNull();
        this.soft.assertThat(this.store().getValues((Ref)hash, List.of(key1), false)).isEmpty();
        this.soft.assertThat((Object)this.store().getValue((Ref)hash, key1, true)).isEqualTo((Object)ContentResult.contentResult((IdentifiedContentKey)notFoundIdentifiedKey1, null, null));
        this.soft.assertThat(this.store().getValues((Ref)hash, List.of(key1, key2), false)).isEmpty();
        this.soft.assertThat(this.store().getValues((Ref)hash, List.of(key1, key2), true)).containsExactlyInAnyOrderEntriesOf(Map.of(key1, ContentResult.contentResult((IdentifiedContentKey)notFoundIdentifiedKey1, null, null), key2, ContentResult.contentResult((IdentifiedContentKey)notFoundIdentifiedKey2, null, null)));
        hash = this.commit("Initial Commit").put(keyNs, (Content)Namespace.of((ContentKey)keyNs)).toBranch(branch);
        String contentIdNs = Objects.requireNonNull(this.store().getValue((Ref)hash, keyNs, false).content()).getId();
        notFoundIdentifiedKey2 = IdentifiedContentKey.identifiedContentKeyFromContent((ContentKey)key2, null, null, l -> List.of("ns").equals(l) ? contentIdNs : null);
        this.soft.assertThat((Object)this.store().getValue((Ref)hash, key1, false)).isNull();
        this.soft.assertThat(this.store().getValues((Ref)hash, List.of(key1), false)).isEmpty();
        this.soft.assertThat((Object)this.store().getValue((Ref)hash, key1, true)).isEqualTo((Object)ContentResult.contentResult((IdentifiedContentKey)notFoundIdentifiedKey1, null, null));
        this.soft.assertThat(this.store().getValues((Ref)hash, List.of(key1, key2), false)).isEmpty();
        this.soft.assertThat(this.store().getValues((Ref)hash, List.of(key1, key2), true)).containsExactlyInAnyOrderEntriesOf(Map.of(key1, ContentResult.contentResult((IdentifiedContentKey)notFoundIdentifiedKey1, null, null), key2, ContentResult.contentResult((IdentifiedContentKey)notFoundIdentifiedKey2, null, null)));
    }

    @Test
    void recreateTable() throws Exception {
        BranchName branch = BranchName.of((String)"recreateTable-main");
        ContentKey key = ContentKey.of((String[])new String[]{"recreateTable"});
        this.store().create((NamedRef)branch, Optional.empty());
        OnRefOnly initialState = OnRefOnly.newOnRef("value");
        CommitResult ancestor = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"create table"), Collections.singletonList(Put.of((ContentKey)key, (Content)initialState)));
        this.soft.assertThat((Object)AbstractContents.contentWithoutId(this.store().getValue((Ref)branch, key, false))).isEqualTo((Object)initialState);
        this.soft.assertThat((Object)AbstractContents.contentWithoutId(this.store().getValue((Ref)ancestor.getCommitHash(), key, false))).isEqualTo((Object)initialState);
        CommitResult delete = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"drop table"), (List)ImmutableList.of((Object)Delete.of((ContentKey)key)));
        this.soft.assertThat((Object)this.store().getValue((Ref)branch, key, false)).isNull();
        this.soft.assertThat((Object)this.store().getValue((Ref)delete.getCommitHash(), key, false)).isNull();
        OnRefOnly recreateState = OnRefOnly.newOnRef("value");
        CommitResult recreate = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"drop table"), (List)ImmutableList.of((Object)Put.of((ContentKey)key, (Content)recreateState)));
        this.soft.assertThat((Object)AbstractContents.contentWithoutId(this.store().getValue((Ref)branch, key, false))).isEqualTo((Object)recreateState);
        this.soft.assertThat((Object)AbstractContents.contentWithoutId(this.store().getValue((Ref)recreate.getCommitHash(), key, false))).isEqualTo((Object)recreateState);
    }
}

