/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableMergeOp;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractMergeScenarios
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;
    final Map<String, Hash> branches = new HashMap<String, Hash>();
    final Map<Hash, String> commits = new HashMap<Hash, String>();
    final Map<ContentKey, String> tableIds = new HashMap<ContentKey, String>();
    final AtomicInteger commitCount = new AtomicInteger();
    final AtomicLong unique = new AtomicLong();

    protected AbstractMergeScenarios(VersionStore store) {
        super(store);
    }

    @Test
    void noMergeBase() throws VersionStoreException {
        Commit a = this.buildCommit().commitToNewBranch("b1");
        Commit b = this.buildCommit().commitToNewBranch("b2");
        Commit c = this.buildCommit().commitTo("b1");
        Commit d = this.buildCommit().commitTo("b2");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.buildMerge().from("b1").merge("b2")).isInstanceOf(ReferenceNotFoundException.class)).hasMessageStartingWith("No common ancestor");
    }

    @Test
    void simpleCase() throws VersionStoreException {
        Commit a = this.buildCommit().commitToNewBranch("b1");
        Commit b = this.buildCommit().commitToNewBranch("b2", "b1", a);
        Commit c = this.buildCommit().commitTo("b1");
        this.buildMerge().from("b2").assertMergeBase("b1", a);
    }

    @Test
    void doubleMerge() throws VersionStoreException {
        Commit a = this.buildCommit().commitToNewBranch("b1");
        Commit b = this.buildCommit().commitToNewBranch("b2", "b1", a);
        Commit c = this.buildCommit().commitTo("b1");
        Commit d = this.buildMerge().from("b2").merge("b1");
        Commit e = this.buildCommit().commitTo("b2");
        this.buildMerge().from("b1").assertMergeBase("b2", b);
    }

    @Test
    void doubleMerge2() throws VersionStoreException {
        Commit a = this.buildCommit().commitToNewBranch("b1");
        Commit b = this.buildCommit().commitToNewBranch("b2", "b1", a);
        Commit c = this.buildCommit().commitTo("b1");
        Commit d = this.buildCommit().commitTo("b2");
        Commit e = this.buildMerge().from("b2").merge("b1");
        Commit f = this.buildCommit().commitTo("b2");
        this.buildMerge().from("b1").assertMergeBase("b2", d);
    }

    @Test
    void multiMerge1() throws VersionStoreException {
        Commit a = this.buildCommit().commitToNewBranch("b1");
        Commit b = this.buildCommit().commitToNewBranch("b2", "b1", a);
        Commit c = this.buildCommit().commitTo("b1");
        Commit d = this.buildCommit().commitTo("b2");
        Commit e = this.buildCommit().commitToNewBranch("b3", "b2", b);
        Commit f = this.buildCommit().commitTo("b1");
        Commit g = this.buildMerge().from("b2").merge("b3");
        Commit h = this.buildMerge().from("b1").merge("b2");
        Commit i = this.buildMerge().from("b1").merge("b3");
        this.buildMerge().from("b3").assertMergeBase("b1", f);
    }

    @Test
    void multiMerge2() throws VersionStoreException {
        Commit a = this.buildCommit().commitToNewBranch("b1");
        Commit b = this.buildCommit().commitToNewBranch("b2", "b1", a);
        Commit c = this.buildMerge().from("b2").merge("b1");
        Commit d = this.buildCommit().commitToNewBranch("b3", "b1", a);
        Commit e = this.buildCommit().commitTo("b1");
        Commit f = this.buildCommit().commitTo("b1");
        Commit g = this.buildMerge().from("b3").merge("b1");
        Commit h = this.buildMerge().from("b2").merge("b3");
        Commit j = this.buildCommit().commitTo("b3");
        this.buildMerge().from("b3").assertMergeBase("b1", d);
    }

    @Test
    void afterCrossMerge() throws VersionStoreException {
        Commit a = this.buildCommit().commitToNewBranch("b1");
        Commit b = this.buildCommit().commitToNewBranch("b2", "b1", a);
        Commit c = this.buildCommit().commitTo("b1");
        Commit d = this.buildMerge().from("b1", c).merge("b2");
        Commit e = this.buildMerge().from("b2", b).merge("b1");
        Commit f = this.buildCommit().commitTo("b2");
        Commit g = this.buildCommit().commitTo("b1");
        this.buildMerge().dryRun().from("b2").assertMergeBase("b1", b);
        this.buildMerge().dryRun().from("b1").assertMergeBase("b2", c);
    }

    @Test
    void nestedBranches() throws VersionStoreException {
        Commit a = this.buildCommit().commitToNewBranch("b1");
        Commit b = this.buildCommit().commitToNewBranch("b3", "b1", a);
        Commit c = this.buildCommit().commitTo("b1");
        Commit d = this.buildCommit().commitTo("b1");
        Commit e = this.buildCommit().commitTo("b1");
        Commit f = this.buildCommit().commitToNewBranch("b2", "b1", a);
        Commit g = this.buildMerge().from("b1", e).merge("b2");
        Commit h = this.buildCommit().commitTo("b1");
        Commit i = this.buildMerge().from("b1").merge("b3");
        this.buildMerge().dryRun().from("b3").assertMergeBase("b2", e);
    }

    @Test
    void featureBranch() throws VersionStoreException {
        Commit a = this.buildCommit().commitToNewBranch("b1");
        Commit b = this.buildCommit().commitToNewBranch("b2", "b1", a);
        Commit c = this.buildCommit().commitTo("b1");
        Commit d = this.buildCommit().commitTo("b1");
        Commit e = this.buildMerge().from("b1", c).merge("b2");
        Commit f = this.buildCommit().commitTo("b1");
        Commit g = this.buildCommit().commitTo("b2");
        Commit h = this.buildCommit().commitTo("b1");
        Commit i = this.buildMerge().from("b1", f).merge("b2");
        Commit j = this.buildCommit().commitTo("b1");
        Commit k = this.buildCommit().commitTo("b2");
        this.buildMerge().from("b2").assertMergeBase("b1", f);
    }

    private MergeBuilder buildMerge() {
        return new MergeBuilder();
    }

    private CommitBuilder buildCommit() {
        return new CommitBuilder();
    }

    private String commitMessage() {
        char c = (char)(97 + this.commitCount.getAndIncrement());
        return Character.toString(c);
    }

    @BeforeEach
    void setup() {
        this.tableIds.clear();
        this.commits.clear();
        this.commitCount.set(0);
        this.unique.set(0L);
    }

    private final class CommitBuilder {
        final CommitMeta.Builder meta;
        final List<Operation> operations = new ArrayList<Operation>();

        CommitBuilder() {
            this.meta = CommitMeta.builder();
        }

        @CanIgnoreReturnValue
        CommitBuilder createTable(String name) {
            this.operations.add((Operation)Put.of((ContentKey)ContentKey.fromPathString((String)name), (Content)IcebergTable.of((String)name, (long)AbstractMergeScenarios.this.unique.incrementAndGet(), (int)1, (int)2, (int)3)));
            return this;
        }

        @CanIgnoreReturnValue
        CommitBuilder update(String name) {
            ContentKey key = ContentKey.fromPathString((String)name);
            String cid = Objects.requireNonNull(AbstractMergeScenarios.this.tableIds.get(key), "Table " + name + " not yet created");
            this.operations.add((Operation)Put.of((ContentKey)key, (Content)IcebergTable.of((String)name, (long)AbstractMergeScenarios.this.unique.incrementAndGet(), (int)1, (int)2, (int)3, (String)cid)));
            return this;
        }

        @CanIgnoreReturnValue
        CommitBuilder delete(String name) {
            ContentKey key = ContentKey.fromPathString((String)name);
            Objects.requireNonNull(AbstractMergeScenarios.this.tableIds.get(key), "Table " + name + " not yet created");
            this.operations.add((Operation)Delete.of((ContentKey)key));
            return this;
        }

        Commit commitToNewBranch(String branch) throws VersionStoreException {
            return this.commitToNewBranch(branch, null, null);
        }

        Commit commitToNewBranch(String branch, String from, Commit fromCommit) throws VersionStoreException {
            if (AbstractMergeScenarios.this.branches.containsKey(branch)) {
                throw new IllegalStateException("Branch " + branch + " already created");
            }
            Hash origin = null;
            if (from != null) {
                origin = fromCommit.getHash();
                Objects.requireNonNull(AbstractMergeScenarios.this.branches.get(from), "Branch " + from + " not yet created");
            }
            Hash head = AbstractMergeScenarios.this.store().create((NamedRef)BranchName.of((String)branch), Optional.ofNullable(origin)).getHash();
            AbstractMergeScenarios.this.branches.put(branch, head);
            return this.commitTo(branch);
        }

        Commit commitTo(String branch) throws VersionStoreException {
            String msg = AbstractMergeScenarios.this.commitMessage();
            this.meta.message(msg);
            if (this.operations.isEmpty()) {
                this.createTable("table created on " + msg);
            }
            Hash head = AbstractMergeScenarios.this.branches.get(branch);
            Objects.requireNonNull(head, "Branch " + branch + " not created");
            CommitResult result = AbstractMergeScenarios.this.store().commit(BranchName.of((String)branch), Optional.of(head), this.meta.build(), this.operations, v -> {}, AbstractMergeScenarios.this.tableIds::put);
            head = result.getCommitHash();
            AbstractMergeScenarios.this.commits.put(head, msg);
            AbstractMergeScenarios.this.branches.put(branch, head);
            return (Commit)result.getCommit();
        }
    }

    private final class MergeBuilder {
        final ImmutableMergeOp.Builder merge = VersionStore.MergeOp.builder();

        private MergeBuilder() {
        }

        @CanIgnoreReturnValue
        MergeBuilder from(String from) {
            Hash head = Objects.requireNonNull(AbstractMergeScenarios.this.branches.get(from), "Branch " + from + " not created");
            this.merge.fromRef((NamedRef)BranchName.of((String)from)).fromHash(head);
            return this;
        }

        @CanIgnoreReturnValue
        MergeBuilder from(String from, Commit fromCommit) {
            this.merge.fromRef((NamedRef)BranchName.of((String)from)).fromHash(fromCommit.getHash());
            return this;
        }

        @CanIgnoreReturnValue
        MergeBuilder dryRun() {
            this.merge.dryRun(true);
            return this;
        }

        Commit merge(String target) throws VersionStoreException {
            return (Commit)this.doMerge(target).getCreatedCommits().get(0);
        }

        Hash mergeReturnMergeBase(String target) throws VersionStoreException {
            return this.doMerge(target).getCommonAncestor();
        }

        void assertMergeBase(String target, Commit expected) throws VersionStoreException {
            Hash mergeBase = this.mergeReturnMergeBase(target);
            String expectedCommitMessage = AbstractMergeScenarios.this.commits.get(expected.getHash());
            String receivedCommitMessage = AbstractMergeScenarios.this.commits.get(mergeBase);
            ((ObjectAssert)AbstractMergeScenarios.this.soft.assertThat((Object)mergeBase).describedAs("Expected commit '%s', but got commit '%s' for merge from %s onto %s (expected hash %s, got hash %s)", new Object[]{expectedCommitMessage, receivedCommitMessage, this.merge.build().fromRef().getName(), target, expected.getHash(), mergeBase})).isEqualTo((Object)expected.getHash());
        }

        MergeResult<Commit> doMerge(String target) throws VersionStoreException {
            Hash head = Objects.requireNonNull(AbstractMergeScenarios.this.branches.get(target), "Branch " + target + " not created");
            ImmutableMergeOp op = this.merge.toBranch(BranchName.of((String)target)).expectedHash(Optional.of(head)).build();
            MergeResult result = AbstractMergeScenarios.this.store().merge((VersionStore.MergeOp)op);
            if (!op.dryRun()) {
                head = ((Commit)result.getCreatedCommits().get(0)).getHash();
                AbstractMergeScenarios.this.branches.put(target, head);
                AbstractMergeScenarios.this.commits.put(head, AbstractMergeScenarios.this.commitMessage());
            }
            return result;
        }
    }
}

