/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.model.GarbageCollectorConfig;
import org.projectnessie.model.ImmutableGarbageCollectorConfig;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractRepositoryConfig
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected AbstractRepositoryConfig(VersionStore store) {
        super(store);
    }

    @Test
    void createAndUpdate() throws Exception {
        ImmutableGarbageCollectorConfig created = GarbageCollectorConfig.builder().defaultCutoffPolicy("P30D").newFilesGracePeriod(Duration.of(3L, ChronoUnit.HOURS)).build();
        ImmutableGarbageCollectorConfig updated = GarbageCollectorConfig.builder().defaultCutoffPolicy("P10D").expectedFileCountPerContent(Integer.valueOf(123)).build();
        this.soft.assertThat((Object)created.getType()).isEqualTo((Object)RepositoryConfig.Type.GARBAGE_COLLECTOR);
        this.soft.assertThat((Object)updated.getType()).isEqualTo((Object)RepositoryConfig.Type.GARBAGE_COLLECTOR);
        this.soft.assertThat(this.store.getRepositoryConfig(Collections.singleton(RepositoryConfig.Type.GARBAGE_COLLECTOR))).isEmpty();
        this.soft.assertThat((Object)this.store.updateRepositoryConfig((RepositoryConfig)created)).isNull();
        this.soft.assertThat(this.store.getRepositoryConfig(Collections.singleton(RepositoryConfig.Type.GARBAGE_COLLECTOR))).containsExactly((Object[])new RepositoryConfig[]{created});
        this.soft.assertThat((Object)this.store.updateRepositoryConfig((RepositoryConfig)updated)).isEqualTo((Object)created);
        this.soft.assertThat(this.store.getRepositoryConfig(Collections.singleton(RepositoryConfig.Type.GARBAGE_COLLECTOR))).containsExactly((Object[])new RepositoryConfig[]{updated});
    }
}

