/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp;

import org.projog.clp.ClpConstraintStore;
import org.projog.clp.ExpressionResult;
import org.projog.clp.Possibilities;

public final class BruteForceSearch {
    private final ClpConstraintStore original;
    private final ClpConstraintStore[] copies;
    private final Possibilities[] p;
    private final int[] indexes;
    private int idx = 0;

    public BruteForceSearch(ClpConstraintStore environment) {
        this.original = environment;
        int variablesCount = environment.getVariablesCount();
        if (variablesCount == 0) {
            throw new IllegalStateException();
        }
        this.copies = new ClpConstraintStore[variablesCount];
        this.p = new Possibilities[variablesCount];
        this.indexes = new int[variablesCount];
        for (int i = 0; i < variablesCount; ++i) {
            this.indexes[i] = i;
        }
    }

    public ClpConstraintStore next() {
        Possibilities current;
        while ((current = this.getCurrent()) != null) {
            long next = current.next();
            this.copies[this.idx] = (this.idx == 0 ? this.original : this.copies[this.idx - 1]).copy();
            if (this.copies[this.idx].getVariable(this.indexes[this.idx]).setValue(this.copies[this.idx], next) == ExpressionResult.INVALID || !this.copies[this.idx].resolve()) continue;
            if (this.idx == this.p.length - 1) {
                return this.copies[this.idx];
            }
            ++this.idx;
        }
        return null;
    }

    private Possibilities getCurrent() {
        if (this.idx == -1) {
            return null;
        }
        Possibilities result = this.p[this.idx];
        if (result == null) {
            ClpConstraintStore copy;
            this.copies[this.idx] = copy = (this.idx == 0 ? this.original : this.copies[this.idx - 1]).copy();
            long min = copy.getVariableState(this.indexes[this.idx]).count();
            int minIdx = this.idx;
            for (int i = this.idx + 1; i < this.indexes.length; ++i) {
                long count = copy.getVariableState(this.indexes[i]).count();
                if (count >= min) continue;
                min = count;
                minIdx = i;
            }
            if (min > Integer.MAX_VALUE) {
                throw new IllegalStateException("Variables not sufficiently bound. Too many possibilities.");
            }
            if (this.idx != minIdx) {
                int tmp = this.indexes[this.idx];
                this.indexes[this.idx] = this.indexes[minIdx];
                this.indexes[minIdx] = tmp;
            }
            this.p[this.idx] = result = copy.getVariableState(this.indexes[this.idx]).getPossibilities();
        }
        while (!result.hasNext()) {
            this.p[this.idx] = null;
            this.copies[this.idx] = null;
            --this.idx;
            if (this.idx == -1) {
                return null;
            }
            result = this.p[this.idx];
        }
        return result;
    }
}

