/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.projog.clp.Constraint;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.FixedValue;
import org.projog.clp.Variable;
import org.projog.clp.VariableState;
import org.projog.clp.VariableStateResult;
import org.projog.clp.bool.Equivalent;
import org.projog.clp.compare.Between;
import org.projog.clp.compare.EqualTo;
import org.projog.clp.compare.LessThan;
import org.projog.clp.compare.LessThanOrEqualTo;
import org.projog.clp.compare.NotEqualTo;

public final class ClpConstraintStore
implements ConstraintStore {
    private final int variableCtr;
    private final Variable[] variables;
    private final VariableState[] variableStates;
    private final int constraintCtr;
    private final Constraint[] constraints;
    private final Map<Variable, List<Integer>> constraintsByVariable;
    private final Queue<Integer> constraintQueue;

    private ClpConstraintStore(Builder b) {
        int i;
        this.variableCtr = b.variables.size();
        this.variables = b.variables.toArray(new Variable[this.variableCtr]);
        this.variableStates = new VariableState[this.variableCtr];
        for (i = 0; i < this.variableCtr; ++i) {
            this.variableStates[i] = new VariableState();
        }
        this.constraintCtr = b.constraints.size();
        this.constraints = b.constraints.toArray(new Constraint[this.constraintCtr]);
        this.constraintsByVariable = b.constraintsByVariable;
        this.constraintQueue = new LinkedList<Integer>();
        for (i = 0; i < this.constraintCtr; ++i) {
            this.constraintQueue.add(i);
        }
    }

    private ClpConstraintStore(ClpConstraintStore original) {
        int i;
        this.variableCtr = original.variableCtr;
        this.variables = original.variables;
        this.variableStates = new VariableState[this.variableCtr];
        for (i = 0; i < this.variableCtr; ++i) {
            this.variableStates[i] = original.variableStates[i].copy();
        }
        this.constraintCtr = original.constraintCtr;
        this.constraints = new Constraint[this.constraintCtr];
        for (i = 0; i < this.constraintCtr; ++i) {
            this.constraints[i] = original.constraints[i];
        }
        this.constraintsByVariable = original.constraintsByVariable;
        this.constraintQueue = new LinkedList<Integer>();
    }

    ClpConstraintStore copy() {
        return new ClpConstraintStore(this);
    }

    public int getVariablesCount() {
        return this.variableCtr;
    }

    public Variable getVariable(int idx) {
        return this.variables[idx];
    }

    public VariableState getVariableState(int idx) {
        return this.variableStates[idx];
    }

    public long getValue(Variable id) {
        long max = this.variableStates[id.getId()].getMax();
        long min = this.variableStates[id.getId()].getMin();
        if (min == max) {
            return min;
        }
        throw new IllegalStateException(min + " " + max);
    }

    private ExpressionResult update(Expression e, VariableStateResult r) {
        List<Integer> list;
        if (r == VariableStateResult.UPDATED && (list = this.constraintsByVariable.get(e)) != null) {
            for (Integer constraintId : list) {
                if (this.constraints[constraintId] == null || this.constraintQueue.contains(constraintId)) continue;
                this.constraintQueue.add(constraintId);
            }
        }
        return r == VariableStateResult.FAILED ? ExpressionResult.INVALID : ExpressionResult.VALID;
    }

    public boolean resolve() {
        while (!this.constraintQueue.isEmpty()) {
            Integer next = this.constraintQueue.poll();
            Constraint c = this.constraints[next];
            if (c == null) continue;
            ConstraintResult result = c.enforce(this);
            if (result == ConstraintResult.FAILED) {
                return false;
            }
            if (result != ConstraintResult.MATCHED) continue;
            this.constraints[next.intValue()] = null;
        }
        return true;
    }

    private VariableState getExpression(Expression e) {
        return this.variableStates[((Variable)e).getId()];
    }

    @Override
    public long getMin(Expression id) {
        return this.getExpression(id).getMin();
    }

    @Override
    public long getMax(Expression id) {
        return this.getExpression(id).getMax();
    }

    @Override
    public ExpressionResult setValue(Expression id, long value) {
        return this.update(id, this.getExpression(id).setValue(value));
    }

    @Override
    public ExpressionResult setMin(Expression id, long min) {
        return this.update(id, this.getExpression(id).setMin(min));
    }

    @Override
    public ExpressionResult setMax(Expression id, long max) {
        return this.update(id, this.getExpression(id).setMax(max));
    }

    @Override
    public ExpressionResult setNot(Expression id, long not) {
        return this.update(id, this.getExpression(id).setNot(not));
    }

    public static class Enforce {
        private final Builder builder;
        private final Expression expression;

        private Enforce(Builder builder, Expression expression) {
            this.builder = builder;
            this.expression = expression;
        }

        public void equalTo(Expression opposite) {
            this.builder.addConstraint(new EqualTo(this.expression, opposite));
        }

        public void notEqualTo(Expression opposite) {
            this.builder.addConstraint(new NotEqualTo(this.expression, opposite));
        }

        public void lessThan(Expression opposite) {
            this.builder.addConstraint(new LessThan(this.expression, opposite));
        }

        public void lessThanOrEqualTo(Expression opposite) {
            this.builder.addConstraint(new LessThanOrEqualTo(this.expression, opposite));
        }

        public void between(long min, long max) {
            this.builder.addConstraint(new Between(this.expression, min, max));
        }

        public void equivalentTo(Constraint equivalent) {
            this.builder.addConstraint(new Equivalent((Constraint)this.expression, equivalent));
        }

        @Deprecated
        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    public static class EnforceAll {
        private final Builder builder;
        private final Variable[] variables;

        private EnforceAll(Builder builder, Variable[] variables) {
            this.builder = builder;
            this.variables = variables;
        }

        public EnforceAll distinct() {
            for (int i1 = 0; i1 < this.variables.length - 1; ++i1) {
                for (int i2 = i1 + 1; i2 < this.variables.length; ++i2) {
                    this.builder.addConstraint(new NotEqualTo(this.variables[i1], this.variables[i2]));
                }
            }
            return this;
        }

        public EnforceAll notEqualTo(long opposite) {
            return this.notEqualTo(new FixedValue(opposite));
        }

        public EnforceAll notEqualTo(Expression opposite) {
            for (Variable v : this.variables) {
                this.builder.addConstraint(new NotEqualTo(v, opposite));
            }
            return this;
        }

        public EnforceAll between(long min, long max) {
            for (Variable v : this.variables) {
                this.builder.addConstraint(new Between(v, min, max));
            }
            return this;
        }

        @Deprecated
        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Builder {
        private final List<Variable> variables = new ArrayList<Variable>();
        private final List<Constraint> constraints = new ArrayList<Constraint>();
        private final Map<Variable, List<Integer>> constraintsByVariable = new HashMap<Variable, List<Integer>>();

        public ClpConstraintStore build() {
            return new ClpConstraintStore(this);
        }

        public Variable createVariable() {
            Variable v = new Variable(this.variables.size());
            this.variables.add(v);
            return v;
        }

        public void addConstraint(Constraint constraint) {
            int constraintId = this.constraints.size();
            this.constraints.add(constraint);
            HashSet variables = new HashSet();
            constraint.walk(v -> {
                if (v instanceof Variable) {
                    variables.add((Variable)v);
                }
            });
            for (Variable v2 : variables) {
                List<Integer> list = this.constraintsByVariable.get(v2);
                if (list == null) {
                    list = new ArrayList<Integer>();
                    this.constraintsByVariable.put(v2, list);
                }
                list.add(constraintId);
            }
        }

        public EnforceAll enforce(List<Variable> e) {
            return new EnforceAll(this, e.toArray(new Variable[e.size()]));
        }

        public EnforceAll enforce(Variable ... e) {
            return new EnforceAll(this, e);
        }

        public Enforce enforce(long i) {
            return new Enforce(this, new FixedValue(i));
        }

        public Enforce enforce(Expression e) {
            return new Enforce(this, e);
        }

        @Deprecated
        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

