/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp;

import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;

public interface Constraint
extends Expression {
    public ConstraintResult enforce(ConstraintStore var1);

    public ConstraintResult prevent(ConstraintStore var1);

    public ConstraintResult reify(ReadConstraintStore var1);

    @Override
    public void walk(Consumer<Expression> var1);

    @Override
    public Constraint replace(Function<LeafExpression, LeafExpression> var1);

    @Override
    default public long getMin(ReadConstraintStore constraintStore) {
        ConstraintResult r = this.reify(constraintStore);
        return r == ConstraintResult.MATCHED ? 1L : 0L;
    }

    @Override
    default public long getMax(ReadConstraintStore constraintStore) {
        ConstraintResult r = this.reify(constraintStore);
        return r == ConstraintResult.FAILED ? 0L : 1L;
    }

    @Override
    default public ExpressionResult setMin(ConstraintStore constraintStore, long min) {
        if (min == 1L) {
            ConstraintResult r = this.enforce(constraintStore);
            return r == ConstraintResult.FAILED ? ExpressionResult.INVALID : ExpressionResult.VALID;
        }
        if (min > 1L) {
            return ExpressionResult.INVALID;
        }
        return ExpressionResult.VALID;
    }

    @Override
    default public ExpressionResult setMax(ConstraintStore constraintStore, long max) {
        if (max == 0L) {
            ConstraintResult r = this.prevent(constraintStore);
            return r == ConstraintResult.FAILED ? ExpressionResult.INVALID : ExpressionResult.VALID;
        }
        if (max < 0L) {
            return ExpressionResult.INVALID;
        }
        return ExpressionResult.VALID;
    }
}

