/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp;

import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;

public final class FixedValue
implements LeafExpression {
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private final long value;

    public FixedValue(long value) {
        this.value = value;
    }

    @Override
    public long getMin(ReadConstraintStore s) {
        return this.value;
    }

    @Override
    public long getMax(ReadConstraintStore s) {
        return this.value;
    }

    @Override
    public ExpressionResult setNot(ConstraintStore s, long not) {
        return this.value == not ? ExpressionResult.INVALID : ExpressionResult.VALID;
    }

    @Override
    public ExpressionResult setMin(ConstraintStore s, long min) {
        return min > this.value ? ExpressionResult.INVALID : ExpressionResult.VALID;
    }

    @Override
    public ExpressionResult setMax(ConstraintStore s, long max) {
        return max < this.value ? ExpressionResult.INVALID : ExpressionResult.VALID;
    }

    @Override
    public ConstraintResult enforce(ConstraintStore constraintStore) {
        return this.reify(constraintStore);
    }

    @Override
    public ConstraintResult prevent(ConstraintStore constraintStore) {
        if (this.value == 1L) {
            return ConstraintResult.FAILED;
        }
        if (this.value == 0L) {
            return ConstraintResult.MATCHED;
        }
        throw new IllegalStateException("Expected 0 or 1 but got " + this.value);
    }

    @Override
    public ConstraintResult reify(ReadConstraintStore constraintStore) {
        if (this.value == 1L) {
            return ConstraintResult.MATCHED;
        }
        if (this.value == 0L) {
            return ConstraintResult.FAILED;
        }
        throw new IllegalStateException("Expected 0 or 1 but got " + this.value);
    }

    @Override
    public void walk(Consumer<Expression> r) {
        r.accept(this);
    }

    @Override
    public LeafExpression replace(Function<LeafExpression, LeafExpression> function) {
        LeafExpression r = function.apply(this);
        if (r != null) {
            return r;
        }
        return this;
    }

    public String toString() {
        return "FixedValue [value=" + this.value + "]";
    }
}

