/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp;

import java.util.BitSet;

final class NumberSet {
    private final long start;
    private final BitSet bitset;

    NumberSet(long start, long end) {
        this.start = start;
        if (start >= end) {
            throw new IllegalArgumentException(start + ">=" + end);
        }
        long size = end - start + 1L;
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(end + "-" + start + "+1=" + size + ">" + Integer.MAX_VALUE);
        }
        this.bitset = new BitSet((int)size);
        this.bitset.set(0, (int)size);
    }

    private NumberSet(long start, BitSet bitset) {
        this.start = start;
        this.bitset = bitset;
    }

    NumberSet copy() {
        return new NumberSet(this.start, (BitSet)this.bitset.clone());
    }

    boolean get(long value) {
        return this.bitset.get((int)(value - this.start));
    }

    void clear(long fromValue, long toValue) {
        this.bitset.clear((int)(fromValue - this.start), (int)(toValue - this.start + 1L));
    }

    void clear(long not) {
        this.bitset.clear((int)(not - this.start));
    }

    long nextSetValue(long value) {
        return (long)this.bitset.nextSetBit((int)(value - this.start)) + this.start;
    }

    long previousSetValue(long value) {
        return (long)this.bitset.previousSetBit((int)(value - this.start)) + this.start;
    }

    int cardinality() {
        return this.bitset.cardinality();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        int i = this.bitset.nextSetBit(0);
        if (i != -1) {
            b.append(this.start + (long)i);
            while (++i >= 0 && (i = this.bitset.nextSetBit(i)) >= 0) {
                int endOfRun = this.bitset.nextClearBit(i);
                do {
                    b.append(", ").append(this.start + (long)i);
                } while (++i != endOfRun);
            }
        }
        b.append('}');
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberSet)) {
            return false;
        }
        NumberSet other = (NumberSet)o;
        return this.start == other.start && this.bitset.equals(other.bitset);
    }

    public int hashCode() {
        return this.bitset.hashCode();
    }
}

