/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp;

import org.projog.clp.NumberSet;

final class Possibilities {
    private final long min;
    private final long max;
    private final NumberSet bitset;
    private long next;

    Possibilities(long min, long max, NumberSet bitset) {
        if (min > max) {
            throw new IllegalStateException();
        }
        this.min = min;
        this.max = max;
        this.bitset = bitset;
        this.next = min;
    }

    boolean hasNext() {
        return this.next >= this.min && this.next <= this.max;
    }

    long next() {
        long c = this.next++;
        if (this.bitset != null) {
            if (this.next < this.min) {
                throw new IllegalStateException();
            }
            this.next = this.bitset.nextSetValue(this.next + 1L);
        }
        return c;
    }
}

