/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp;

import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;

public final class Variable
implements LeafExpression {
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private final int id;

    Variable(int id) {
        this.id = id;
    }

    int getId() {
        return this.id;
    }

    @Override
    public long getMin(ReadConstraintStore s) {
        return s.getMin(this);
    }

    @Override
    public long getMax(ReadConstraintStore s) {
        return s.getMax(this);
    }

    public ExpressionResult setValue(ConstraintStore s, long value) {
        return s.setValue(this, value);
    }

    @Override
    public ExpressionResult setNot(ConstraintStore s, long not) {
        return s.setNot(this, not);
    }

    @Override
    public ExpressionResult setMin(ConstraintStore s, long min) {
        return s.setMin(this, min);
    }

    @Override
    public ExpressionResult setMax(ConstraintStore s, long max) {
        return s.setMax(this, max);
    }

    @Override
    public ConstraintResult enforce(ConstraintStore s) {
        long min = this.getMin(s);
        long max = this.getMax(s);
        if (min > 1L || max < 0L) {
            throw new IllegalStateException("Expected 0 or 1");
        }
        if (s.setValue(this, 1L) == ExpressionResult.INVALID) {
            return ConstraintResult.FAILED;
        }
        return ConstraintResult.MATCHED;
    }

    @Override
    public ConstraintResult prevent(ConstraintStore s) {
        long min = this.getMin(s);
        long max = this.getMax(s);
        if (min > 1L || max < 0L) {
            throw new IllegalStateException("Expected 0 or 1");
        }
        if (s.setValue(this, 0L) == ExpressionResult.INVALID) {
            return ConstraintResult.FAILED;
        }
        return ConstraintResult.MATCHED;
    }

    @Override
    public ConstraintResult reify(ReadConstraintStore s) {
        long max;
        long min = this.getMin(s);
        if (min != (max = this.getMax(s))) {
            return ConstraintResult.UNRESOLVED;
        }
        if (min == 1L) {
            return ConstraintResult.MATCHED;
        }
        if (min == 0L) {
            return ConstraintResult.FAILED;
        }
        throw new IllegalStateException("Expected 0 or 1 but got " + min);
    }

    @Override
    public void walk(Consumer<Expression> r) {
        r.accept(this);
    }

    @Override
    public LeafExpression replace(Function<LeafExpression, LeafExpression> function) {
        LeafExpression r = function.apply(this);
        if (r != null) {
            return r;
        }
        return this;
    }

    public String toString() {
        return "Variable [id=" + this.id + "]";
    }
}

