/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp;

import org.projog.clp.NumberSet;
import org.projog.clp.Possibilities;
import org.projog.clp.VariableStateResult;
import org.projog.clp.math.MathUtils;

public final class VariableState {
    private static final NumberSet CORRUPT = new NumberSet(0L, 1L);
    private long min;
    private long max;
    private NumberSet bitset;

    public VariableState() {
        this.min = Long.MIN_VALUE;
        this.max = Long.MAX_VALUE;
    }

    private VariableState(long min, long max, NumberSet bitset) {
        this.min = min;
        this.max = max;
        this.bitset = bitset;
    }

    private VariableState(VariableState original) {
        this.min = original.min;
        this.max = original.max;
        if (original.bitset != null) {
            this.bitset = original.bitset.copy();
        }
    }

    public static VariableState and(VariableState a, VariableState b) {
        NumberSet bitSetToMerge;
        NumberSet newBitSet;
        long newMax;
        if (a == b) {
            return a;
        }
        long newMin = VariableState.min(a, b);
        if (newMin > (newMax = VariableState.max(a, b))) {
            return null;
        }
        if (a.bitset == null && b.bitset == null || newMin == newMax) {
            if (a.min == newMin && a.max == newMax) {
                return a;
            }
            if (b.min == newMin && b.max == newMax) {
                return b;
            }
            return new VariableState(newMin, newMax, null);
        }
        if (a.bitset == null) {
            return VariableState.squashVariableState(b, newMin, newMax);
        }
        if (b.bitset == null) {
            return VariableState.squashVariableState(a, newMin, newMax);
        }
        if (a.bitset.equals(b.bitset)) {
            return a;
        }
        if (a.bitset.cardinality() > b.bitset.cardinality()) {
            newBitSet = VariableState.squashBitSet(b, newMin, newMax);
            bitSetToMerge = a.bitset;
        } else {
            newBitSet = VariableState.squashBitSet(a, newMin, newMax);
            bitSetToMerge = b.bitset;
        }
        for (long i = newMin; i <= newMax && (i = newBitSet.nextSetValue(i)) >= newMin; ++i) {
            if (bitSetToMerge.get(i)) continue;
            newBitSet.clear(i);
        }
        return new VariableState(newMin, newMax, newBitSet);
    }

    private static long min(VariableState a, VariableState b) {
        if (a.min == b.min) {
            return a.min;
        }
        long newMin = Math.max(a.min, b.min);
        if (a.bitset != null && b.bitset != null) {
            long n2;
            long n1;
            do {
                if ((n1 = a.bitset.nextSetValue(newMin)) < a.min || n1 < b.min || n1 > a.max) {
                    return Long.MAX_VALUE;
                }
                n2 = b.bitset.nextSetValue(newMin = Math.max(n1, newMin));
                if (n2 < a.min || n2 < b.min || n1 > b.max) {
                    return Long.MAX_VALUE;
                }
                newMin = Math.max(n2, newMin);
            } while (n1 != n2);
        } else if (a.bitset != null) {
            long n = a.bitset.nextSetValue(newMin);
            if (n < newMin) {
                return Long.MAX_VALUE;
            }
            if (n > newMin) {
                newMin = n;
            }
        } else if (b.bitset != null) {
            long n = b.bitset.nextSetValue(newMin);
            if (n < newMin) {
                return Long.MAX_VALUE;
            }
            if (n > newMin) {
                newMin = n;
            }
        }
        return newMin;
    }

    private static long max(VariableState a, VariableState b) {
        if (a.max == b.max) {
            return a.max;
        }
        long newMax = Math.min(a.max, b.max);
        if (a.bitset != null && b.bitset != null) {
            long n2;
            long n1;
            do {
                if ((n1 = a.bitset.previousSetValue(newMax)) < a.min || n1 < b.min) {
                    return Long.MIN_VALUE;
                }
                n2 = b.bitset.previousSetValue(newMax = Math.min(n1, newMax));
                if (n2 < a.min || n2 < b.min) {
                    return Long.MIN_VALUE;
                }
                newMax = Math.min(n2, newMax);
            } while (n1 != n2);
        } else if (a.bitset != null) {
            long n = a.bitset.previousSetValue(newMax);
            if (n < a.min) {
                return Long.MIN_VALUE;
            }
            if (n < newMax) {
                newMax = n;
            }
        } else if (b.bitset != null) {
            long n = b.bitset.previousSetValue(newMax);
            if (n < b.min) {
                return Long.MIN_VALUE;
            }
            if (n < newMax) {
                newMax = n;
            }
        }
        return newMax;
    }

    private static VariableState squashVariableState(VariableState s, long newMin, long newMax) {
        if (newMin == s.min && newMax == s.max) {
            return s;
        }
        NumberSet newBitSet = VariableState.squashBitSet(s, newMin, newMax);
        return new VariableState(newMin, newMax, newBitSet);
    }

    private static NumberSet squashBitSet(VariableState s, long newMin, long newMax) {
        NumberSet newBitSet = s.bitset.copy();
        if (s.min < newMin) {
            newBitSet.clear(s.min, newMin - 1L);
        }
        if (s.max > newMax) {
            newBitSet.clear(newMax + 1L, s.max);
        }
        return newBitSet;
    }

    public long getMin() {
        this.validate();
        return this.min;
    }

    public long getMax() {
        this.validate();
        return this.max;
    }

    public VariableStateResult setValue(long value) {
        this.validate();
        if (value == this.min && value == this.max) {
            return VariableStateResult.NO_CHANGE;
        }
        if (value < this.min || value > this.max) {
            return this.fail();
        }
        if (this.bitset != null) {
            if (!this.bitset.get(value)) {
                return this.fail();
            }
            this.bitset = null;
        }
        this.min = value;
        this.max = value;
        return VariableStateResult.UPDATED;
    }

    public VariableStateResult setMin(long min) {
        this.validate();
        if (min <= this.min) {
            return VariableStateResult.NO_CHANGE;
        }
        if (min > this.max) {
            return this.fail();
        }
        if (this.bitset != null) {
            this.bitset.clear(this.min, min - 1L);
            min = this.bitset.nextSetValue(min);
            if (this.bitset.cardinality() == 0) {
                throw new IllegalStateException();
            }
        }
        this.min = min;
        if (min == this.max) {
            this.bitset = null;
        }
        return VariableStateResult.UPDATED;
    }

    public VariableStateResult setMax(long max) {
        this.validate();
        if (max >= this.max) {
            return VariableStateResult.NO_CHANGE;
        }
        if (max < this.min) {
            return this.fail();
        }
        if (this.bitset != null) {
            this.bitset.clear(max + 1L, this.max);
            max = this.bitset.previousSetValue(max);
            if (this.bitset.cardinality() == 0) {
                throw new IllegalStateException();
            }
        }
        this.max = max;
        if (this.min == max) {
            this.bitset = null;
        }
        return VariableStateResult.UPDATED;
    }

    public VariableStateResult setNot(long not) {
        this.validate();
        if (not < this.min || not > this.max) {
            return VariableStateResult.NO_CHANGE;
        }
        if (this.min == not && this.max == not) {
            return this.fail();
        }
        if (this.bitset == null) {
            if (MathUtils.safeSubtract(this.max, this.min) >= Integer.MAX_VALUE) {
                return VariableStateResult.NO_CHANGE;
            }
            this.bitset = new NumberSet(this.min, this.max);
        }
        if (this.bitset.get(not)) {
            if (this.bitset.cardinality() == 1) {
                throw new IllegalStateException();
            }
            this.bitset.clear(not);
            if (this.min == not) {
                this.min = this.bitset.nextSetValue(this.min + 1L);
            }
            if (this.max == not) {
                this.max = this.bitset.previousSetValue(this.max - 1L);
            }
            if (this.min == this.max) {
                this.bitset = null;
            }
            return VariableStateResult.UPDATED;
        }
        return VariableStateResult.NO_CHANGE;
    }

    public VariableState copy() {
        this.validate();
        return new VariableState(this);
    }

    public long count() {
        this.validate();
        if (this.bitset != null) {
            return this.bitset.cardinality();
        }
        return MathUtils.safeAdd(MathUtils.safeSubtract(this.max, this.min), 1L);
    }

    public Possibilities getPossibilities() {
        this.validate();
        return new Possibilities(this.min, this.max, this.bitset);
    }

    private VariableStateResult fail() {
        this.bitset = CORRUPT;
        return VariableStateResult.FAILED;
    }

    private void validate() {
        if (this.isCorrupt()) {
            throw new IllegalStateException();
        }
    }

    public boolean isSingleValue() {
        this.validate();
        return this.min == this.max;
    }

    public boolean isCorrupt() {
        return this.bitset == CORRUPT;
    }

    public String toString() {
        if (this.isCorrupt()) {
            return "corrupt";
        }
        if (this.isSingleValue()) {
            return Long.toString(this.min);
        }
        if (this.bitset == null || (long)this.bitset.cardinality() == this.max - this.min + 1L) {
            return this.min + ".." + this.max;
        }
        return this.bitset.toString();
    }
}

