/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.bool;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.Constraint;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.bool.Nand;

public final class And
implements Constraint {
    private final Constraint left;
    private final Constraint right;

    public And(Constraint left, Constraint right) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    public ConstraintResult enforce(ConstraintStore constraintStore) {
        return And.enforce(this.left, this.right, constraintStore);
    }

    static ConstraintResult enforce(Constraint left, Constraint right, ConstraintStore constraintStore) {
        ConstraintResult r1 = left.enforce(constraintStore);
        if (r1 == ConstraintResult.FAILED) {
            return ConstraintResult.FAILED;
        }
        ConstraintResult r2 = right.enforce(constraintStore);
        if (r2 == ConstraintResult.FAILED) {
            return ConstraintResult.FAILED;
        }
        return r1 == ConstraintResult.MATCHED && r2 == ConstraintResult.MATCHED ? ConstraintResult.MATCHED : ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult reify(ReadConstraintStore constraintStore) {
        ConstraintResult r1 = this.left.reify(constraintStore);
        if (r1 == ConstraintResult.FAILED) {
            return ConstraintResult.FAILED;
        }
        ConstraintResult r2 = this.right.reify(constraintStore);
        if (r2 == ConstraintResult.FAILED) {
            return ConstraintResult.FAILED;
        }
        return r1 == ConstraintResult.MATCHED && r2 == ConstraintResult.MATCHED ? ConstraintResult.MATCHED : ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult prevent(ConstraintStore constraintStore) {
        return Nand.enforce(this.left, this.right, constraintStore);
    }

    @Override
    public void walk(Consumer<Expression> r) {
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public And replace(Function<LeafExpression, LeafExpression> r) {
        return new And((Constraint)this.left.replace((Function)r), (Constraint)this.right.replace((Function)r));
    }

    public String toString() {
        return "And [left=" + this.left + ", right=" + this.right + "]";
    }
}

