/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.bool;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.Constraint;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.bool.Xor;

public final class Equivalent
implements Constraint {
    private final Constraint left;
    private final Constraint right;

    public Equivalent(Constraint left, Constraint right) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    public ConstraintResult enforce(ConstraintStore constraintStore) {
        return Equivalent.enforce(this.left, this.right, constraintStore);
    }

    static ConstraintResult enforce(Constraint left, Constraint right, ConstraintStore constraintStore) {
        ConstraintResult r = Equivalent.internalEnforce(left, right, constraintStore);
        if (r != ConstraintResult.UNRESOLVED) {
            return r;
        }
        return Equivalent.internalEnforce(right, left, constraintStore);
    }

    private static ConstraintResult internalEnforce(Constraint a, Constraint b, ConstraintStore constraintStore) {
        ConstraintResult r = a.reify(constraintStore);
        if (r == ConstraintResult.MATCHED) {
            return b.enforce(constraintStore);
        }
        if (r == ConstraintResult.FAILED) {
            return b.prevent(constraintStore);
        }
        return ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult reify(ReadConstraintStore constraintStore) {
        ConstraintResult r1 = this.left.reify(constraintStore);
        if (r1 == ConstraintResult.UNRESOLVED) {
            return ConstraintResult.UNRESOLVED;
        }
        ConstraintResult r2 = this.right.reify(constraintStore);
        if (r2 == ConstraintResult.UNRESOLVED) {
            return ConstraintResult.UNRESOLVED;
        }
        return r1 == r2 ? ConstraintResult.MATCHED : ConstraintResult.FAILED;
    }

    @Override
    public ConstraintResult prevent(ConstraintStore constraintStore) {
        return Xor.enforce(this.left, this.right, constraintStore);
    }

    @Override
    public void walk(Consumer<Expression> r) {
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public Equivalent replace(Function<LeafExpression, LeafExpression> r) {
        return new Equivalent((Constraint)this.left.replace((Function)r), (Constraint)this.right.replace((Function)r));
    }

    public String toString() {
        return "Equivalent [left=" + this.left + ", right=" + this.right + "]";
    }
}

