/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.bool;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.Constraint;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;

public final class Implication
implements Constraint {
    private final Constraint left;
    private final Constraint right;

    public Implication(Constraint left, Constraint right) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    public ConstraintResult enforce(ConstraintStore constraintStore) {
        ConstraintResult leftResult = this.left.reify(constraintStore);
        if (leftResult == ConstraintResult.MATCHED) {
            return this.right.enforce(constraintStore);
        }
        if (leftResult == ConstraintResult.FAILED) {
            return ConstraintResult.MATCHED;
        }
        ConstraintResult rightResult = this.right.reify(constraintStore);
        if (rightResult == ConstraintResult.MATCHED) {
            return ConstraintResult.MATCHED;
        }
        if (rightResult == ConstraintResult.FAILED) {
            return this.left.prevent(constraintStore);
        }
        return ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult prevent(ConstraintStore constraintStore) {
        ConstraintResult leftResult = this.left.reify(constraintStore);
        if (leftResult == ConstraintResult.MATCHED) {
            return this.right.prevent(constraintStore);
        }
        if (leftResult == ConstraintResult.FAILED) {
            return ConstraintResult.FAILED;
        }
        ConstraintResult rightResult = this.right.reify(constraintStore);
        if (rightResult == ConstraintResult.MATCHED) {
            return ConstraintResult.FAILED;
        }
        if (rightResult == ConstraintResult.FAILED) {
            return this.left.enforce(constraintStore);
        }
        return ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult reify(ReadConstraintStore constraintStore) {
        ConstraintResult leftResult = this.left.reify(constraintStore);
        if (leftResult == ConstraintResult.FAILED) {
            return ConstraintResult.MATCHED;
        }
        ConstraintResult rightResult = this.right.reify(constraintStore);
        if (rightResult == ConstraintResult.MATCHED) {
            return ConstraintResult.MATCHED;
        }
        if (leftResult == ConstraintResult.MATCHED && rightResult == ConstraintResult.FAILED) {
            return ConstraintResult.FAILED;
        }
        return ConstraintResult.UNRESOLVED;
    }

    @Override
    public void walk(Consumer<Expression> r) {
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public Implication replace(Function<LeafExpression, LeafExpression> r) {
        return new Implication((Constraint)this.left.replace((Function)r), (Constraint)this.right.replace((Function)r));
    }

    public String toString() {
        return "Implication [left=" + this.left + ", right=" + this.right + "]";
    }
}

