/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.bool;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.Constraint;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.bool.Or;

public final class Nor
implements Constraint {
    private final Constraint left;
    private final Constraint right;

    public Nor(Constraint left, Constraint right) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    public ConstraintResult enforce(ConstraintStore constraintStore) {
        return Nor.enforce(this.left, this.right, constraintStore);
    }

    static ConstraintResult enforce(Constraint left, Constraint right, ConstraintStore constraintStore) {
        ConstraintResult r1 = left.reify(constraintStore);
        if (r1 == ConstraintResult.MATCHED) {
            return ConstraintResult.FAILED;
        }
        ConstraintResult r2 = right.reify(constraintStore);
        if (r2 == ConstraintResult.MATCHED) {
            return ConstraintResult.FAILED;
        }
        if (r1 == ConstraintResult.FAILED && r2 == ConstraintResult.FAILED) {
            return ConstraintResult.MATCHED;
        }
        if (r1 == ConstraintResult.UNRESOLVED) {
            r1 = left.prevent(constraintStore);
            if (r1 == ConstraintResult.FAILED) {
                return ConstraintResult.FAILED;
            }
            if (r1 == ConstraintResult.MATCHED) {
                r1 = ConstraintResult.FAILED;
            }
        }
        if (r2 == ConstraintResult.UNRESOLVED) {
            r2 = right.prevent(constraintStore);
            if (r2 == ConstraintResult.FAILED) {
                return ConstraintResult.FAILED;
            }
            if (r2 == ConstraintResult.MATCHED) {
                r2 = ConstraintResult.FAILED;
            }
        }
        if (r1 == ConstraintResult.FAILED && r2 == ConstraintResult.FAILED) {
            return ConstraintResult.MATCHED;
        }
        return ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult reify(ReadConstraintStore constraintStore) {
        ConstraintResult r1 = this.left.reify(constraintStore);
        if (r1 == ConstraintResult.MATCHED) {
            return ConstraintResult.FAILED;
        }
        ConstraintResult r2 = this.right.reify(constraintStore);
        if (r2 == ConstraintResult.MATCHED) {
            return ConstraintResult.FAILED;
        }
        if (r1 == ConstraintResult.FAILED && r2 == ConstraintResult.FAILED) {
            return ConstraintResult.MATCHED;
        }
        return ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult prevent(ConstraintStore constraintStore) {
        return Or.enforce(this.left, this.right, constraintStore);
    }

    @Override
    public void walk(Consumer<Expression> r) {
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public Nor replace(Function<LeafExpression, LeafExpression> r) {
        return new Nor((Constraint)this.left.replace((Function)r), (Constraint)this.right.replace((Function)r));
    }

    public String toString() {
        return "Nor [left=" + this.left + ", right=" + this.right + "]";
    }
}

