/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.bool;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.Constraint;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;

public final class Not
implements Constraint {
    private final Constraint constraint;

    public Not(Constraint constraint) {
        this.constraint = Objects.requireNonNull(constraint);
    }

    @Override
    public ConstraintResult enforce(ConstraintStore constraintStore) {
        return this.constraint.prevent(constraintStore);
    }

    @Override
    public ConstraintResult prevent(ConstraintStore constraintStore) {
        return this.constraint.enforce(constraintStore);
    }

    @Override
    public ConstraintResult reify(ReadConstraintStore constraintStore) {
        ConstraintResult r = this.constraint.reify(constraintStore);
        switch (r) {
            case MATCHED: {
                return ConstraintResult.FAILED;
            }
            case FAILED: {
                return ConstraintResult.MATCHED;
            }
            case UNRESOLVED: {
                return ConstraintResult.UNRESOLVED;
            }
        }
        throw new IllegalArgumentException("ConstraintResult: " + (Object)((Object)r));
    }

    @Override
    public void walk(Consumer<Expression> r) {
        this.constraint.walk(r);
    }

    @Override
    public Not replace(Function<LeafExpression, LeafExpression> r) {
        return new Not((Constraint)this.constraint.replace((Function)r));
    }

    public String toString() {
        return "Not [constraint=" + this.constraint + "]";
    }
}

