/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.compare;

import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.Constraint;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;

public final class Between
implements Constraint {
    private final Expression e;
    private final long min;
    private final long max;

    public Between(Expression e, long min, long max) {
        if (max < min) {
            throw new IllegalArgumentException(max + " < " + min);
        }
        this.e = e;
        this.min = min;
        this.max = max;
    }

    @Override
    public ConstraintResult enforce(ConstraintStore m) {
        if (this.e.setMin(m, this.min) == ExpressionResult.INVALID || this.e.setMax(m, this.max) == ExpressionResult.INVALID) {
            return ConstraintResult.FAILED;
        }
        return this.e.getMin(m) >= this.min && this.e.getMax(m) <= this.max ? ConstraintResult.MATCHED : ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult reify(ReadConstraintStore constraintStore) {
        long minValue = this.e.getMin(constraintStore);
        long maxValue = this.e.getMax(constraintStore);
        if (minValue >= this.min && maxValue <= this.max) {
            return ConstraintResult.MATCHED;
        }
        if (minValue > this.max || maxValue < this.min) {
            return ConstraintResult.FAILED;
        }
        return ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult prevent(ConstraintStore constraintStore) {
        switch (this.reify(constraintStore)) {
            case MATCHED: {
                return ConstraintResult.FAILED;
            }
            case FAILED: {
                return ConstraintResult.MATCHED;
            }
        }
        return ConstraintResult.UNRESOLVED;
    }

    @Override
    public void walk(Consumer<Expression> r) {
        this.e.walk(r);
    }

    @Override
    public Between replace(Function<LeafExpression, LeafExpression> r) {
        return new Between(this.e.replace(r), this.min, this.max);
    }

    public String toString() {
        return "Between [e=" + this.e + ", min=" + this.min + ", max=" + this.max + "]";
    }
}

