/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.compare;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.Constraint;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.compare.NotEqualTo;

public final class EqualTo
implements Constraint {
    private final Expression left;
    private final Expression right;

    public EqualTo(Expression left, Expression right) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    public ConstraintResult enforce(ConstraintStore m) {
        return EqualTo.enforce(this.left, this.right, m);
    }

    static ConstraintResult enforce(Expression left, Expression right, ConstraintStore m) {
        long minLeft = left.getMin(m);
        long maxLeft = left.getMax(m);
        long minRight = right.getMin(m);
        long maxRight = right.getMax(m);
        if (minLeft > maxRight || maxLeft < minRight) {
            return ConstraintResult.FAILED;
        }
        if (left.setMin(m, minRight) == ExpressionResult.INVALID || left.setMax(m, maxRight) == ExpressionResult.INVALID || right.setMin(m, minLeft) == ExpressionResult.INVALID || right.setMax(m, maxLeft) == ExpressionResult.INVALID) {
            return ConstraintResult.FAILED;
        }
        return left.getMin(m) == right.getMax(m) && left.getMax(m) == right.getMin(m) ? ConstraintResult.MATCHED : ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult reify(ReadConstraintStore constraintStore) {
        long minLeft = this.left.getMin(constraintStore);
        long maxLeft = this.left.getMax(constraintStore);
        long minRight = this.right.getMin(constraintStore);
        long maxRight = this.right.getMax(constraintStore);
        if (minLeft == maxRight && maxLeft == minRight) {
            return ConstraintResult.MATCHED;
        }
        if (minLeft > maxRight || maxLeft < minRight) {
            return ConstraintResult.FAILED;
        }
        return ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult prevent(ConstraintStore constraintStore) {
        return NotEqualTo.enforce(this.left, this.right, constraintStore);
    }

    @Override
    public void walk(Consumer<Expression> r) {
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public EqualTo replace(Function<LeafExpression, LeafExpression> r) {
        return new EqualTo(this.left.replace(r), this.right.replace(r));
    }

    public String toString() {
        return "EqualTo [left=" + this.left + ", right=" + this.right + "]";
    }
}

