/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.compare;

import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.Constraint;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.compare.LessThanOrEqualTo;

public final class LessThan
implements Constraint {
    private final Expression left;
    private final Expression right;

    public LessThan(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public ConstraintResult enforce(ConstraintStore m) {
        return LessThan.enforce(this.left, this.right, m);
    }

    static ConstraintResult enforce(Expression left, Expression right, ConstraintStore m) {
        long max;
        long min = left.getMin(m);
        if (min >= (max = right.getMax(m))) {
            return ConstraintResult.FAILED;
        }
        if (left.setMax(m, max - 1L) == ExpressionResult.INVALID || right.setMin(m, min + 1L) == ExpressionResult.INVALID) {
            return ConstraintResult.FAILED;
        }
        return left.getMax(m) < right.getMin(m) ? ConstraintResult.MATCHED : ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult reify(ReadConstraintStore constraintStore) {
        if (this.left.getMax(constraintStore) < this.right.getMin(constraintStore)) {
            return ConstraintResult.MATCHED;
        }
        if (this.left.getMin(constraintStore) >= this.right.getMax(constraintStore)) {
            return ConstraintResult.FAILED;
        }
        return ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult prevent(ConstraintStore constraintStore) {
        return LessThanOrEqualTo.enforce(this.right, this.left, constraintStore);
    }

    @Override
    public void walk(Consumer<Expression> r) {
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public LessThan replace(Function<LeafExpression, LeafExpression> r) {
        return new LessThan(this.left.replace(r), this.right.replace(r));
    }

    public String toString() {
        return "LessThan [left=" + this.left + ", right=" + this.right + "]";
    }
}

