/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.compare;

import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.Constraint;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.compare.LessThan;

public final class LessThanOrEqualTo
implements Constraint {
    private final Expression left;
    private final Expression right;

    public LessThanOrEqualTo(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public ConstraintResult enforce(ConstraintStore m) {
        return LessThanOrEqualTo.enforce(this.left, this.right, m);
    }

    static ConstraintResult enforce(Expression left, Expression right, ConstraintStore m) {
        long max;
        long min = left.getMin(m);
        if (min > (max = right.getMax(m))) {
            return ConstraintResult.FAILED;
        }
        if (left.setMax(m, max) == ExpressionResult.INVALID || right.setMin(m, min) == ExpressionResult.INVALID) {
            return ConstraintResult.FAILED;
        }
        return left.getMax(m) <= right.getMin(m) ? ConstraintResult.MATCHED : ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult reify(ReadConstraintStore constraintStore) {
        if (this.left.getMax(constraintStore) <= this.right.getMin(constraintStore)) {
            return ConstraintResult.MATCHED;
        }
        if (this.left.getMin(constraintStore) > this.right.getMax(constraintStore)) {
            return ConstraintResult.FAILED;
        }
        return ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult prevent(ConstraintStore constraintStore) {
        return LessThan.enforce(this.right, this.left, constraintStore);
    }

    @Override
    public void walk(Consumer<Expression> r) {
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public LessThanOrEqualTo replace(Function<LeafExpression, LeafExpression> r) {
        return new LessThanOrEqualTo(this.left.replace(r), this.right.replace(r));
    }

    public String toString() {
        return "LessThanOrEqualTo [left=" + this.left + ", right=" + this.right + "]";
    }
}

