/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.compare;

import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.Constraint;
import org.projog.clp.ConstraintResult;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.compare.EqualTo;

public final class NotEqualTo
implements Constraint {
    private final Expression left;
    private final Expression right;

    public NotEqualTo(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public ConstraintResult enforce(ConstraintStore m) {
        return NotEqualTo.enforce(this.left, this.right, m);
    }

    static ConstraintResult enforce(Expression left, Expression right, ConstraintStore m) {
        long maxRight;
        long maxLeft;
        long minLeft = left.getMin(m);
        if (minLeft == (maxLeft = left.getMax(m)) && right.setNot(m, minLeft) == ExpressionResult.INVALID) {
            return ConstraintResult.FAILED;
        }
        long minRight = right.getMin(m);
        if (minRight == (maxRight = right.getMax(m)) && left.setNot(m, minRight) == ExpressionResult.INVALID) {
            return ConstraintResult.FAILED;
        }
        if (minLeft == maxLeft && minRight == maxRight && minLeft == minRight) {
            return ConstraintResult.FAILED;
        }
        return left.getMin(m) > right.getMax(m) || right.getMin(m) > left.getMax(m) ? ConstraintResult.MATCHED : ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult reify(ReadConstraintStore constraintStore) {
        long minLeft = this.left.getMin(constraintStore);
        long maxLeft = this.left.getMax(constraintStore);
        long minRight = this.right.getMin(constraintStore);
        long maxRight = this.right.getMax(constraintStore);
        if (minLeft > maxRight || minRight > maxLeft) {
            return ConstraintResult.MATCHED;
        }
        if (minLeft == maxLeft && minRight == maxRight && minLeft == minRight) {
            return ConstraintResult.FAILED;
        }
        return ConstraintResult.UNRESOLVED;
    }

    @Override
    public ConstraintResult prevent(ConstraintStore constraintStore) {
        return EqualTo.enforce(this.left, this.right, constraintStore);
    }

    @Override
    public void walk(Consumer<Expression> r) {
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public NotEqualTo replace(Function<LeafExpression, LeafExpression> r) {
        return new NotEqualTo(this.left.replace(r), this.right.replace(r));
    }

    public String toString() {
        return "NotEqualTo [left=" + this.left + ", right=" + this.right + "]";
    }
}

