/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.math;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.math.MathUtils;

public final class Absolute
implements Expression {
    private final Expression e;

    public Absolute(Expression e) {
        this.e = Objects.requireNonNull(e);
    }

    @Override
    public long getMin(ReadConstraintStore s) {
        long min = this.e.getMin(s);
        long max = this.e.getMax(s);
        if (min < 1L && max > -1L) {
            return 0L;
        }
        return Math.min(MathUtils.safeAbs(min), MathUtils.safeAbs(max));
    }

    @Override
    public long getMax(ReadConstraintStore s) {
        long min = this.e.getMin(s);
        long max = this.e.getMax(s);
        return Math.max(MathUtils.safeAbs(min), MathUtils.safeAbs(max));
    }

    @Override
    public ExpressionResult setMin(ConstraintStore s, long value) {
        if (value < 1L) {
            return ExpressionResult.VALID;
        }
        long min = this.e.getMin(s);
        long max = this.e.getMax(s);
        long negative = MathUtils.safeMinus(value);
        if (max < value && this.e.setMax(s, negative) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        if (min > negative && this.e.setMin(s, value) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        return ExpressionResult.VALID;
    }

    @Override
    public ExpressionResult setMax(ConstraintStore s, long value) {
        if (value < 0L) {
            return ExpressionResult.INVALID;
        }
        if (this.e.setMax(s, value) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        if (this.e.setMin(s, MathUtils.safeMinus(value)) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        return ExpressionResult.VALID;
    }

    @Override
    public void walk(Consumer<Expression> consumer) {
        consumer.accept(this);
        this.e.walk(consumer);
    }

    @Override
    public Absolute replace(Function<LeafExpression, LeafExpression> function) {
        return new Absolute(this.e.replace(function));
    }

    public String toString() {
        return "Absolute [e=" + this.e + "]";
    }
}

