/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.math;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.math.MathUtils;

public final class Add
implements Expression {
    private final Expression left;
    private final Expression right;

    public Add(Expression left, Expression right) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    public long getMin(ReadConstraintStore s) {
        return MathUtils.safeAdd(this.left.getMin(s), this.right.getMin(s));
    }

    @Override
    public long getMax(ReadConstraintStore s) {
        return MathUtils.safeAdd(this.left.getMax(s), this.right.getMax(s));
    }

    @Override
    public ExpressionResult setMin(ConstraintStore s, long min) {
        long rightMax;
        long leftMax = this.left.getMax(s);
        if (MathUtils.safeAdd(leftMax, rightMax = this.right.getMax(s)) < min) {
            return ExpressionResult.INVALID;
        }
        if (this.left.setMin(s, MathUtils.safeSubtract(min, rightMax)) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        if (this.right.setMin(s, MathUtils.safeSubtract(min, leftMax)) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        return ExpressionResult.VALID;
    }

    @Override
    public ExpressionResult setMax(ConstraintStore s, long max) {
        long rightMin;
        long leftMin = this.left.getMin(s);
        if (MathUtils.safeAdd(leftMin, rightMin = this.right.getMin(s)) > max) {
            return ExpressionResult.INVALID;
        }
        if (this.left.setMax(s, MathUtils.safeSubtract(max, rightMin)) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        if (this.right.setMax(s, MathUtils.safeSubtract(max, leftMin)) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        return ExpressionResult.VALID;
    }

    @Override
    public void walk(Consumer<Expression> r) {
        r.accept(this);
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public Add replace(Function<LeafExpression, LeafExpression> r) {
        return new Add(this.left.replace(r), this.right.replace(r));
    }

    public String toString() {
        return "Add [left=" + this.left + ", right=" + this.right + "]";
    }
}

