/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.math;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.math.MathUtils;

public final class Divide
implements Expression {
    private final Expression left;
    private final Expression right;

    public Divide(Expression left, Expression right) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    public long getMin(ReadConstraintStore s) {
        long leftMin = this.left.getMin(s);
        long leftMax = this.left.getMax(s);
        long rightMin = this.right.getMin(s);
        long rightMax = this.right.getMax(s);
        if (rightMin == 0L || rightMax == 0L) {
            return Long.MIN_VALUE;
        }
        long r = MathUtils.safeDivide(leftMin, rightMin);
        long r1 = MathUtils.safeDivide(leftMin, rightMax);
        if (r1 < r) {
            r = r1;
        }
        if ((r1 = MathUtils.safeDivide(leftMax, rightMin)) < r) {
            r = r1;
        }
        if ((r1 = MathUtils.safeDivide(leftMax, rightMax)) < r) {
            r = r1;
        }
        if (rightMin < 0L && rightMax > 0L) {
            r1 = MathUtils.safeDivide(leftMin, 1L);
            if (r1 < r) {
                r = r1;
            }
            if ((r1 = MathUtils.safeDivide(leftMin, -1L)) < r) {
                r = r1;
            }
            if ((r1 = MathUtils.safeDivide(leftMax, -1L)) < r) {
                r = r1;
            }
        }
        return r;
    }

    @Override
    public long getMax(ReadConstraintStore s) {
        long leftMin = this.left.getMin(s);
        long leftMax = this.left.getMax(s);
        long rightMin = this.right.getMin(s);
        long rightMax = this.right.getMax(s);
        if (rightMin == 0L || rightMax == 0L) {
            return Long.MAX_VALUE;
        }
        long r = MathUtils.safeDivide(leftMin, rightMin);
        long r1 = MathUtils.safeDivide(leftMin, rightMax);
        if (r1 > r) {
            r = r1;
        }
        if ((r1 = MathUtils.safeDivide(leftMax, rightMin)) > r) {
            r = r1;
        }
        if ((r1 = MathUtils.safeDivide(leftMax, rightMax)) > r) {
            r = r1;
        }
        if (rightMin < 0L && rightMax > 0L) {
            r1 = MathUtils.safeDivide(leftMin, 1L);
            if (r1 > r) {
                r = r1;
            }
            if ((r1 = MathUtils.safeDivide(leftMax, 1L)) > r) {
                r = r1;
            }
            if ((r1 = MathUtils.safeDivide(leftMin, -1L)) > r) {
                r = r1;
            }
        }
        return r;
    }

    @Override
    public ExpressionResult setMin(ConstraintStore s, long min) {
        boolean rightPositive;
        if (this.right.setNot(s, 0L) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        boolean leftNegative = this.left.getMax(s) < 0L;
        boolean leftPositive = this.left.getMin(s) > 0L;
        boolean rightNegative = this.right.getMax(s) < 0L;
        boolean bl = rightPositive = this.right.getMin(s) > 0L;
        if (min == 0L && leftNegative && rightPositive) {
            if (this.left.setMin(s, -(this.right.getMax(s) - 1L)) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (this.right.setMin(s, -(this.left.getMax(s) - 1L)) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        } else if (min == 0L && leftPositive && rightNegative) {
            if (this.left.setMax(s, -(this.right.getMin(s) + 1L)) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (this.right.setMax(s, -(this.left.getMin(s) + 1L)) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        } else if (leftPositive && rightPositive && min > 0L) {
            if (this.left.setMin(s, min * this.right.getMin(s)) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (this.right.setMax(s, this.left.getMax(s) / min) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        } else if (leftNegative && rightNegative && min > 0L) {
            if (this.right.setMin(s, -Divide.calcRightMin(-this.left.getMin(s), min)) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            long r3 = min * this.right.getMax(s);
            if (this.left.setMax(s, r3) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        } else if (leftNegative && rightPositive) {
            long x;
            if (min > 0L) {
                return ExpressionResult.INVALID;
            }
            long r = MathUtils.safeSubtract(MathUtils.safeMultiply(min, this.right.getMax(s)), MathUtils.safeSubtract(this.right.getMax(s), 1L));
            if (this.left.setMin(s, r) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (this.left.getMax(s) / this.right.getMin(s) < min && this.right.setMin(s, x = this.right.getMin(s) + 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        } else if (leftPositive && rightNegative) {
            if (min > 0L) {
                return ExpressionResult.INVALID;
            }
            if (this.right.setMax(s, -Divide.calcRightMax(this.left.getMin(s), -min)) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            long r = min * this.right.getMin(s) + (-this.right.getMin(s) - 1L);
            if (this.left.setMax(s, r) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        } else if (leftPositive && min > 0L ? this.right.setMin(s, 1L) == ExpressionResult.INVALID : (leftNegative && min > 0L ? this.right.setMax(s, -1L) == ExpressionResult.INVALID : (rightPositive && min > 0L ? this.left.setMin(s, 1L) == ExpressionResult.INVALID : rightNegative && min > 0L && this.left.setMax(s, -1L) == ExpressionResult.INVALID))) {
            return ExpressionResult.INVALID;
        }
        return ExpressionResult.VALID;
    }

    @Override
    public ExpressionResult setMax(ConstraintStore s, long max) {
        boolean rightPositive;
        if (this.right.setNot(s, 0L) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        boolean leftNegative = this.left.getMax(s) < 0L;
        boolean leftPositive = this.left.getMin(s) > 0L;
        boolean rightNegative = this.right.getMax(s) < 0L;
        boolean bl = rightPositive = this.right.getMin(s) > 0L;
        if (max == 0L && leftNegative && rightNegative) {
            if (this.left.setMin(s, this.right.getMin(s) + 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (this.right.setMax(s, this.left.getMax(s) - 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        } else if (max == 0L && leftPositive && rightPositive) {
            if (this.left.setMax(s, this.right.getMax(s) - 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (this.right.setMin(s, this.left.getMin(s) + 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        } else if (leftPositive && rightPositive) {
            if (max < 0L) {
                return ExpressionResult.INVALID;
            }
            if (this.left.setMax(s, Divide.calcLeftMax(this.right.getMax(s), max)) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (this.right.setMin(s, Divide.calcRightMax(this.left.getMin(s), max)) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        } else if (leftNegative && rightNegative) {
            if (max < 0L) {
                return ExpressionResult.INVALID;
            }
            if (this.left.setMin(s, -Divide.calcLeftMax(-this.right.getMin(s), max)) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (this.right.setMax(s, -Divide.calcRightMax(-this.left.getMax(s), max)) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        } else if (leftNegative && rightPositive && max < 0L) {
            if (this.right.setMax(s, Divide.calcRightMin(-this.left.getMin(s), -max)) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            long r = max * this.right.getMin(s);
            if (this.left.setMax(s, r) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        } else if (leftPositive && rightNegative && max < 0L) {
            long x;
            if (this.left.setMin(s, this.right.getMax(s) * max) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (this.left.getMax(s) / this.right.getMin(s) > max && this.right.setMin(s, x = this.left.getMax(s) / max) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        } else if (leftPositive && max < 0L ? this.right.setMax(s, -1L) == ExpressionResult.INVALID : (leftNegative && max < 0L ? this.right.setMin(s, 1L) == ExpressionResult.INVALID : (rightPositive && max < 0L ? this.left.setMax(s, -1L) == ExpressionResult.INVALID : rightNegative && max < 0L && this.left.setMin(s, 1L) == ExpressionResult.INVALID))) {
            return ExpressionResult.INVALID;
        }
        return ExpressionResult.VALID;
    }

    private static long calcLeftMax(long right, long target) {
        return MathUtils.safeAdd(MathUtils.safeMultiply(right, target), MathUtils.safeSubtract(right, 1L));
    }

    private static long calcRightMin(long left, long target) {
        return MathUtils.safeDivide(left, target);
    }

    private static long calcRightMax(long left, long target) {
        return MathUtils.safeAdd(MathUtils.safeDivide(left, MathUtils.safeAdd(target, 1L)), 1L);
    }

    @Override
    public void walk(Consumer<Expression> r) {
        r.accept(this);
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public Divide replace(Function<LeafExpression, LeafExpression> r) {
        return new Divide(this.left.replace(r), this.right.replace(r));
    }

    public String toString() {
        return "Divide [left=" + this.left + ", right=" + this.right + "]";
    }
}

