/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.math;

public final class MathUtils {
    private MathUtils() {
    }

    public static long safeAdd(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            return y > 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return r;
    }

    public static long safeSubtract(long x, long y) {
        long r = x - y;
        if (((x ^ y) & (x ^ r)) < 0L) {
            return y < 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return r;
    }

    public static long safeMultiply(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            return x < 0L == y < 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return r;
    }

    public static long safeDivide(long x, long y) {
        if (x == Long.MIN_VALUE && y == -1L) {
            return Long.MAX_VALUE;
        }
        return x / y;
    }

    public static long safeAbs(long v) {
        return v == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(v);
    }

    public static long safeMinus(long v) {
        if (v == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        return -v;
    }
}

