/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.math;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;

public class Maximum
implements Expression {
    private final Expression left;
    private final Expression right;

    public Maximum(Expression left, Expression right) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    public long getMin(ReadConstraintStore constraintStore) {
        return Math.max(this.left.getMin(constraintStore), this.right.getMin(constraintStore));
    }

    @Override
    public long getMax(ReadConstraintStore constraintStore) {
        return Math.max(this.left.getMax(constraintStore), this.right.getMax(constraintStore));
    }

    @Override
    public ExpressionResult setMin(ConstraintStore constraintStore, long min) {
        if (this.left.getMax(constraintStore) < min) {
            return this.right.setMin(constraintStore, min);
        }
        if (this.right.getMax(constraintStore) < min) {
            return this.left.setMin(constraintStore, min);
        }
        return ExpressionResult.VALID;
    }

    @Override
    public ExpressionResult setMax(ConstraintStore constraintStore, long max) {
        if (this.left.setMax(constraintStore, max) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        if (this.right.setMax(constraintStore, max) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        return ExpressionResult.VALID;
    }

    @Override
    public void walk(Consumer<Expression> r) {
        r.accept(this);
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public Maximum replace(Function<LeafExpression, LeafExpression> r) {
        return new Maximum(this.left.replace(r), this.right.replace(r));
    }

    public String toString() {
        return "Maximum [left=" + this.left + ", right=" + this.right + "]";
    }
}

