/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.math;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;

public class Minimum
implements Expression {
    private final Expression left;
    private final Expression right;

    public Minimum(Expression left, Expression right) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    public long getMin(ReadConstraintStore constraintStore) {
        return Math.min(this.left.getMin(constraintStore), this.right.getMin(constraintStore));
    }

    @Override
    public long getMax(ReadConstraintStore constraintStore) {
        return Math.min(this.left.getMax(constraintStore), this.right.getMax(constraintStore));
    }

    @Override
    public ExpressionResult setMin(ConstraintStore constraintStore, long min) {
        if (this.left.setMin(constraintStore, min) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        if (this.right.setMin(constraintStore, min) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        return ExpressionResult.VALID;
    }

    @Override
    public ExpressionResult setMax(ConstraintStore constraintStore, long max) {
        if (this.left.getMin(constraintStore) > max) {
            return this.right.setMax(constraintStore, max);
        }
        if (this.right.getMin(constraintStore) > max) {
            return this.left.setMax(constraintStore, max);
        }
        return ExpressionResult.VALID;
    }

    @Override
    public void walk(Consumer<Expression> r) {
        r.accept(this);
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public Minimum replace(Function<LeafExpression, LeafExpression> r) {
        return new Minimum(this.left.replace(r), this.right.replace(r));
    }

    public String toString() {
        return "Minimum [left=" + this.left + ", right=" + this.right + "]";
    }
}

