/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.math;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.math.MathUtils;

public final class Minus
implements Expression {
    private final Expression e;

    public Minus(Expression e) {
        this.e = Objects.requireNonNull(e);
    }

    @Override
    public long getMin(ReadConstraintStore s) {
        return MathUtils.safeMinus(this.e.getMax(s));
    }

    @Override
    public long getMax(ReadConstraintStore s) {
        return MathUtils.safeMinus(this.e.getMin(s));
    }

    @Override
    public ExpressionResult setMin(ConstraintStore s, long value) {
        return this.e.setMax(s, MathUtils.safeMinus(value));
    }

    @Override
    public ExpressionResult setMax(ConstraintStore s, long value) {
        return this.e.setMin(s, MathUtils.safeMinus(value));
    }

    @Override
    public void walk(Consumer<Expression> consumer) {
        consumer.accept(this);
        this.e.walk(consumer);
    }

    @Override
    public Minus replace(Function<LeafExpression, LeafExpression> function) {
        return new Minus(this.e.replace(function));
    }

    public String toString() {
        return "Minus [e=" + this.e + "]";
    }
}

