/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.math;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.math.MathUtils;

public final class Multiply
implements Expression {
    private final Expression left;
    private final Expression right;

    public Multiply(Expression left, Expression right) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    public long getMin(ReadConstraintStore s) {
        long leftMin = this.left.getMin(s);
        long leftMax = this.left.getMax(s);
        long rightMin = this.right.getMin(s);
        long rightMax = this.right.getMax(s);
        long r = MathUtils.safeMultiply(leftMin, rightMin);
        long r1 = MathUtils.safeMultiply(leftMin, rightMax);
        if (r1 < r) {
            r = r1;
        }
        if ((r1 = MathUtils.safeMultiply(leftMax, rightMin)) < r) {
            r = r1;
        }
        if ((r1 = MathUtils.safeMultiply(leftMax, rightMax)) < r) {
            r = r1;
        }
        return r;
    }

    @Override
    public long getMax(ReadConstraintStore s) {
        long leftMin = this.left.getMin(s);
        long leftMax = this.left.getMax(s);
        long rightMin = this.right.getMin(s);
        long rightMax = this.right.getMax(s);
        long r = MathUtils.safeMultiply(leftMin, rightMin);
        long r1 = MathUtils.safeMultiply(leftMin, rightMax);
        if (r1 > r) {
            r = r1;
        }
        if ((r1 = MathUtils.safeMultiply(leftMax, rightMin)) > r) {
            r = r1;
        }
        if ((r1 = MathUtils.safeMultiply(leftMax, rightMax)) > r) {
            r = r1;
        }
        return r;
    }

    @Override
    public ExpressionResult setMin(ConstraintStore s, long min) {
        if (min > this.getMax(s)) {
            return ExpressionResult.INVALID;
        }
        long leftMin = this.left.getMin(s);
        long leftMax = this.left.getMax(s);
        long rightMin = this.right.getMin(s);
        long rightMax = this.right.getMax(s);
        if (min > 0L) {
            if (leftMin > -1L && rightMax < 1L) {
                return ExpressionResult.INVALID;
            }
            if (rightMin > -1L && leftMax < 1L) {
                return ExpressionResult.INVALID;
            }
            if (leftMin == 0L && this.left.setMin(s, 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (leftMax == 0L && this.left.setMax(s, -1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (rightMin == 0L && this.right.setMin(s, 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (rightMax == 0L && this.right.setMax(s, -1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (leftMin > 0L && rightMin < 1L && this.right.setMin(s, 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (rightMin > 0L && leftMin < 1L && this.left.setMin(s, 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (leftMax < 0L && rightMax > -1L && this.right.setMax(s, -1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (rightMax < 0L && leftMax > -1L && this.left.setMax(s, -1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        }
        if (min == 0L) {
            if (leftMin > 0L && this.right.setMin(s, 0L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (rightMin > 0L && this.left.setMin(s, 0L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (leftMax < 0L && this.right.setMax(s, 0L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (rightMax < 0L && this.left.setMax(s, 0L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        }
        if (leftMax < 0L && rightMax < 0L) {
            if (Multiply.setMax(s, this.left, min, leftMax, rightMin, rightMax, Multiply::divideWhole) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (Multiply.setMax(s, this.right, min, rightMax, leftMin, leftMax, Multiply::divideWhole) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            return ExpressionResult.VALID;
        }
        if (leftMin > 0L && rightMin > 0L) {
            if (Multiply.setMin(s, this.left, min, leftMin, rightMin, rightMax, Multiply::divideWhole) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (Multiply.setMin(s, this.right, min, rightMin, leftMin, leftMax, Multiply::divideWhole) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            return ExpressionResult.VALID;
        }
        return ExpressionResult.VALID;
    }

    @Override
    public ExpressionResult setMax(ConstraintStore s, long max) {
        if (max < this.getMin(s)) {
            return ExpressionResult.INVALID;
        }
        long leftMin = this.left.getMin(s);
        long leftMax = this.left.getMax(s);
        long rightMin = this.right.getMin(s);
        long rightMax = this.right.getMax(s);
        if (max < 0L) {
            if (leftMin > -1L && rightMin > -1L) {
                return ExpressionResult.INVALID;
            }
            if (leftMax < 1L && rightMax < 1L) {
                return ExpressionResult.INVALID;
            }
            if (leftMin == 0L && this.left.setMin(s, 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (leftMax == 0L && this.left.setMax(s, -1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (rightMin == 0L && this.right.setMin(s, 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (rightMax == 0L && this.right.setMax(s, -1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (leftMin > 0L && rightMax > -1L && this.right.setMax(s, -1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (rightMin > 0L && leftMax > -1L && this.left.setMax(s, -1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (leftMax < 0L && rightMin < 1L && this.right.setMin(s, 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (rightMax < 0L && leftMin < 1L && this.left.setMin(s, 1L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        }
        if (max == 0L) {
            if (leftMin > 0L && this.right.setMax(s, 0L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (rightMin > 0L && this.left.setMax(s, 0L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (leftMax < 0L && this.right.setMin(s, 0L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (rightMax < 0L && this.left.setMin(s, 0L) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
        }
        if (leftMax < 0L && rightMax < 0L) {
            if (Multiply.setMin(s, this.left, max, leftMin, rightMin, rightMax, Multiply::divideRoundDown) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (Multiply.setMin(s, this.right, max, rightMin, leftMin, leftMax, Multiply::divideRoundDown) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            return ExpressionResult.VALID;
        }
        if (leftMin > 0L && rightMin > 0L) {
            if (Multiply.setMax(s, this.left, max, leftMax, rightMin, rightMax, Multiply::divideRoundDown) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            if (Multiply.setMax(s, this.right, max, rightMax, leftMin, leftMax, Multiply::divideRoundDown) == ExpressionResult.INVALID) {
                return ExpressionResult.INVALID;
            }
            return ExpressionResult.VALID;
        }
        return ExpressionResult.VALID;
    }

    private static ExpressionResult setMax(ConstraintStore s, Expression left, long max, long leftMax, long rightMin, long rightMax, BiFunction<Long, Long, Long> f) {
        long newMaxLeft = Math.max(f.apply(max, rightMin), f.apply(max, rightMax));
        return newMaxLeft < leftMax ? left.setMax(s, newMaxLeft) : ExpressionResult.VALID;
    }

    private static ExpressionResult setMin(ConstraintStore s, Expression left, long min, long leftMin, long rightMin, long rightMax, BiFunction<Long, Long, Long> f) {
        long newMinLeft = Math.min(f.apply(min, rightMin), f.apply(min, rightMax));
        return newMinLeft > leftMin ? left.setMin(s, newMinLeft) : ExpressionResult.VALID;
    }

    private static long divideRoundDown(long dividend, long divisor) {
        return dividend / divisor;
    }

    private static long divideWhole(long dividend, long divisor) {
        long result = dividend / divisor;
        if (divisor * result == dividend) {
            return result;
        }
        if (divisor < 0L) {
            return result - 1L;
        }
        return result + 1L;
    }

    @Override
    public void walk(Consumer<Expression> r) {
        r.accept(this);
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public Multiply replace(Function<LeafExpression, LeafExpression> r) {
        return new Multiply(this.left.replace(r), this.right.replace(r));
    }

    public String toString() {
        return "Multiply [left=" + this.left + ", right=" + this.right + "]";
    }
}

