/*
 * Decompiled with CFR 0.152.
 */
package org.projog.clp.math;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projog.clp.ConstraintStore;
import org.projog.clp.Expression;
import org.projog.clp.ExpressionResult;
import org.projog.clp.LeafExpression;
import org.projog.clp.ReadConstraintStore;
import org.projog.clp.math.MathUtils;

public final class Subtract
implements Expression {
    private final Expression left;
    private final Expression right;

    public Subtract(Expression left, Expression right) {
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    public long getMin(ReadConstraintStore s) {
        return MathUtils.safeSubtract(this.left.getMin(s), this.right.getMax(s));
    }

    @Override
    public long getMax(ReadConstraintStore s) {
        return MathUtils.safeSubtract(this.left.getMax(s), this.right.getMin(s));
    }

    @Override
    public ExpressionResult setMin(ConstraintStore s, long min) {
        long rightMin;
        long leftMax = this.left.getMax(s);
        if (MathUtils.safeSubtract(leftMax, rightMin = this.right.getMin(s)) < min) {
            return ExpressionResult.INVALID;
        }
        if (this.left.setMin(s, MathUtils.safeAdd(rightMin, min)) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        if (this.right.setMax(s, MathUtils.safeSubtract(leftMax, min)) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        return ExpressionResult.VALID;
    }

    @Override
    public ExpressionResult setMax(ConstraintStore s, long max) {
        long rightMax;
        long leftMin = this.left.getMin(s);
        if (MathUtils.safeSubtract(leftMin, rightMax = this.right.getMax(s)) > max) {
            return ExpressionResult.INVALID;
        }
        if (this.left.setMax(s, MathUtils.safeAdd(rightMax, max)) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        if (this.right.setMin(s, MathUtils.safeSubtract(leftMin, max)) == ExpressionResult.INVALID) {
            return ExpressionResult.INVALID;
        }
        return ExpressionResult.VALID;
    }

    @Override
    public void walk(Consumer<Expression> r) {
        r.accept(this);
        this.left.walk(r);
        this.right.walk(r);
    }

    @Override
    public Subtract replace(Function<LeafExpression, LeafExpression> r) {
        return new Subtract(this.left.replace(r), this.right.replace(r));
    }

    public String toString() {
        return "Subtract [left=" + this.left + ", right=" + this.right + "]";
    }
}

