/*
 * Decompiled with CFR 0.152.
 */
package org.projog.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;

class LookAheadLineReader {
    private final File file;
    private final List<String> lines;
    private int lineNumber = -1;
    private int mark;

    LookAheadLineReader(File file) throws IOException {
        this.file = file;
        this.lines = Files.readAllLines(file.toPath());
    }

    String readLine() {
        if (this.lineNumber == this.lines.size() - 1) {
            return null;
        }
        ++this.lineNumber;
        return this.lines.get(this.lineNumber);
    }

    void mark() {
        this.mark = this.lineNumber;
    }

    void reset() {
        this.lineNumber = this.mark;
    }

    File getFile() {
        return this.file;
    }

    int getLineNumber() {
        return this.lineNumber;
    }

    String getLine() {
        if (this.lineNumber < 0 || this.lineNumber >= this.lines.size()) {
            return null;
        }
        return this.lines.get(this.lineNumber);
    }
}

