/*
 * Decompiled with CFR 0.152.
 */
package org.projog.test;

enum Markup {
    TRUE,
    TRUE_NO,
    YES(true),
    NO(true),
    QUIT(true),
    FAIL,
    QUERY("?-"),
    OUTPUT,
    ERROR,
    LINK;

    private final String prefix;
    private final boolean neverHasText;

    private Markup() {
        this(false);
    }

    private Markup(boolean neverHasText) {
        this.prefix = "%" + this.toString();
        this.neverHasText = neverHasText;
    }

    private Markup(String name) {
        this.prefix = "%" + name;
        this.neverHasText = false;
    }

    boolean isMatch(String line) {
        if (line == null) {
            return false;
        }
        String trimmed = line.trim();
        if (trimmed.equals(this.prefix)) {
            return true;
        }
        if (trimmed.startsWith(this.prefix + " ")) {
            if (this.neverHasText) {
                throw new RuntimeException("Did not expect text after : " + this.prefix + " but got: " + line);
            }
            return true;
        }
        return false;
    }

    String parseText(String line) {
        if ((line = line.trim()).equals(this.prefix)) {
            return "";
        }
        if (!line.startsWith(this.prefix)) {
            throw new RuntimeException("Expected line to start with \"" + this.prefix + "\"");
        }
        if (!line.startsWith(this.prefix + " ")) {
            throw new RuntimeException("Expected line to have space after \"" + this.prefix + "\"");
        }
        int spacePos = line.indexOf(32);
        if (spacePos == -1) {
            throw new IllegalStateException();
        }
        return line.substring(spacePos + 1).trim();
    }

    static boolean isMarkup(String line) {
        for (Markup m : Markup.values()) {
            if (!m.isMatch(line)) continue;
            return true;
        }
        return false;
    }
}

