/*
 * Decompiled with CFR 0.152.
 */
package org.projog.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.projog.core.math.ArithmeticOperator;
import org.projog.core.predicate.PredicateFactory;
import org.projog.test.ProjogTestExtractorConfig;

public final class ProjogTestExtractor {
    private final ProjogTestExtractorConfig config;

    public static void extractTests() {
        ProjogTestExtractor.extractTests(new ProjogTestExtractorConfig());
    }

    public static void extractTests(ProjogTestExtractorConfig config) {
        ProjogTestExtractor.validateConfig(config);
        ProjogTestExtractor generator = new ProjogTestExtractor(config);
        List<File> javaSourceFiles = generator.getDocumentableJavaSourceFiles(config.getJavaRootDirectory());
        HashMap<String, File> alreadyProcessed = new HashMap<String, File>();
        for (File f : javaSourceFiles) {
            File previousEntry = alreadyProcessed.put(f.getName(), f);
            if (previousEntry != null) {
                throw new IllegalArgumentException("Two instances of: " + f.getName() + " first: " + previousEntry + " second: " + f);
            }
            generator.produceScriptFileFromJavaFile(f);
        }
    }

    private static void validateConfig(ProjogTestExtractorConfig config) {
        Objects.requireNonNull(config, "no ProjogTestExtractorConfig specified");
        Objects.requireNonNull(config.getJavaRootDirectory(), "no Java root directiry specified");
        Objects.requireNonNull(config.getPrologTestsDirectory(), "no Prolog tests directiry specified");
        Objects.requireNonNull(config.getFileFilter(), "no file filter specified in " + config);
        if (!config.getJavaRootDirectory().exists()) {
            throw new IllegalArgumentException("Java root directory does not exists: " + config.getJavaRootDirectory());
        }
    }

    private ProjogTestExtractor(ProjogTestExtractorConfig config) {
        this.config = config;
    }

    private List<File> getDocumentableJavaSourceFiles(File dir) {
        ArrayList<File> result = new ArrayList<File>();
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                result.addAll(this.getDocumentableJavaSourceFiles(f));
                continue;
            }
            if (!this.isJavaSourceFileOfDocumentedClass(f)) continue;
            result.add(f);
        }
        return result;
    }

    private boolean isJavaSourceFileOfDocumentedClass(File file) {
        return ProjogTestExtractor.isJavaSource(file) && this.config.getFileFilter().accept(file) && ProjogTestExtractor.isDocumentable(this.getClass(file));
    }

    private Class<?> getClass(File file) {
        try {
            String className = this.getClassName(file);
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isDocumentable(Class<?> c) {
        return ProjogTestExtractor.isConcrete(c) && ProjogTestExtractor.isPublic(c) && (ProjogTestExtractor.isPredicateFactory(c) || ProjogTestExtractor.isArithmeticOperator(c));
    }

    private static boolean isConcrete(Class<?> c) {
        return !Modifier.isAbstract(c.getModifiers());
    }

    private static boolean isPublic(Class<?> c) {
        return Modifier.isPublic(c.getModifiers());
    }

    private static boolean isPredicateFactory(Class<?> c) {
        return PredicateFactory.class.isAssignableFrom(c);
    }

    private static boolean isArithmeticOperator(Class<?> c) {
        return ArithmeticOperator.class.isAssignableFrom(c);
    }

    private static boolean isJavaSource(File f) {
        String name = f.getName();
        return name.endsWith(".java") && !"package-info.java".equals(name);
    }

    private void produceScriptFileFromJavaFile(File javaFile) {
        try (FileReader fr = new FileReader(javaFile);
             BufferedReader br = new BufferedReader(fr);){
            String line;
            boolean testRead = false;
            boolean javadocRead = false;
            while (!(testRead && javadocRead || (line = br.readLine()) == null)) {
                if ("/* TEST".equals(line = line.trim())) {
                    testRead = true;
                    this.writeScriptFile(javaFile, br);
                    continue;
                }
                if (!testRead || javadocRead || !"/**".equals(line)) continue;
                javadocRead = true;
                this.writeTextFile(javaFile, br);
            }
            if (!testRead && this.config.isRequireTest()) {
                throw new Exception("No Prolog tests found in: " + javaFile);
            }
            if (!javadocRead && this.config.isRequireJavadoc()) {
                throw new Exception("No Javadoc found in: " + javaFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot generate Prolog test script from " + javaFile + " due to " + e, e);
        }
    }

    private void writeScriptFile(File javaFile, BufferedReader br) {
        File scriptFile = this.getOutputFile(javaFile, ".pl");
        scriptFile.getParentFile().mkdirs();
        try (FileWriter fw = new FileWriter(scriptFile);
             BufferedWriter bw = new BufferedWriter(fw);){
            String line;
            while (!"*/".equals(line = br.readLine().trim())) {
                bw.write(line);
                bw.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not produce: " + scriptFile + " due to: " + e, e);
        }
    }

    private void writeTextFile(File javaFile, BufferedReader br) {
        File textFile = this.getOutputFile(javaFile, ".txt");
        textFile.getParentFile().mkdirs();
        try (FileWriter fw = new FileWriter(textFile);
             BufferedWriter bw = new BufferedWriter(fw);){
            String line;
            while (!"*/".equals(line = br.readLine().trim())) {
                if ((line = line.trim()).startsWith("*")) {
                    line = line.substring(1).trim();
                }
                if (ProjogTestExtractor.isAnnotation(line)) continue;
                bw.write(line);
                bw.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not produce: " + textFile + " due to: " + e, e);
        }
    }

    private static boolean isAnnotation(String line) {
        return line.startsWith("@");
    }

    private File getOutputFile(File javaSourceFile, String extension) {
        return new File(this.config.getPrologTestsDirectory(), this.getClassName(javaSourceFile) + extension);
    }

    private String getClassName(File javaFile) {
        String rootPath = this.config.getJavaRootDirectory().getPath();
        String pathMinusRoot = javaFile.getPath().substring(rootPath.length() + 1);
        return pathMinusRoot.replace(File.separatorChar, '.').substring(0, pathMinusRoot.lastIndexOf(46));
    }
}

