/*
 * Decompiled with CFR 0.152.
 */
package org.projog.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.projog.test.Assignment;
import org.projog.test.LookAheadLineReader;
import org.projog.test.Markup;
import org.projog.test.ProjogTestAnswer;
import org.projog.test.ProjogTestCode;
import org.projog.test.ProjogTestComment;
import org.projog.test.ProjogTestContent;
import org.projog.test.ProjogTestLink;
import org.projog.test.ProjogTestQuery;

public final class ProjogTestParser {
    private static final String COMMENT_CHARACTER = "%";
    private final LookAheadLineReader br;

    public static List<ProjogTestQuery> getQueries(File testScript) {
        boolean hasLinks = false;
        try {
            ProjogTestContent c;
            ProjogTestParser p = new ProjogTestParser(testScript);
            ArrayList<ProjogTestQuery> queries = new ArrayList<ProjogTestQuery>();
            while ((c = p.getNext()) != null) {
                if (c instanceof ProjogTestQuery) {
                    queries.add((ProjogTestQuery)c);
                    continue;
                }
                if (!(c instanceof ProjogTestLink)) continue;
                hasLinks = true;
            }
            if (queries.isEmpty() && !hasLinks) {
                throw new IllegalStateException("Could not find any tests or links");
            }
            return queries;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception parsing test script: " + testScript, e);
        }
    }

    public ProjogTestParser(File testScript) throws IOException {
        this.br = new LookAheadLineReader(testScript);
    }

    public ProjogTestContent getNext() {
        try {
            String line = this.br.readLine();
            if (line == null) {
                return null;
            }
            if (Markup.LINK.isMatch(line)) {
                return new ProjogTestLink(Markup.LINK.parseText(line));
            }
            if (Markup.TRUE_NO.isMatch(line)) {
                ProjogTestQuery query = this.createSingleCorrectAnswerWithNoAssignmentsQuery(line, Markup.TRUE_NO);
                query.setContinuesUntilFails();
                return query;
            }
            if (Markup.TRUE.isMatch(line)) {
                return this.createSingleCorrectAnswerWithNoAssignmentsQuery(line, Markup.TRUE);
            }
            if (Markup.FAIL.isMatch(line)) {
                String queryStr = Markup.FAIL.parseText(line);
                ProjogTestQuery query = new ProjogTestQuery(queryStr);
                query.setContinuesUntilFails();
                return query;
            }
            if (Markup.QUERY.isMatch(line)) {
                return this.getQuery(line);
            }
            if (this.isIllegalComment(line)) {
                throw new IllegalArgumentException("Unknown sys-test markup: " + line);
            }
            if (this.isStandardComment(line)) {
                return new ProjogTestComment(this.getComment(line));
            }
            return new ProjogTestCode(line);
        }
        catch (Exception e) {
            String message = "Line number: " + this.br.getLineNumber() + " line: " + this.br.getLine();
            throw new RuntimeException(message, e);
        }
    }

    private ProjogTestQuery createSingleCorrectAnswerWithNoAssignmentsQuery(String line, Markup markup) {
        String queryStr = markup.parseText(line);
        ProjogTestQuery queryWithSingleCorrectAnswer = new ProjogTestQuery(queryStr);
        queryWithSingleCorrectAnswer.getAnswers().add(new ProjogTestAnswer());
        return queryWithSingleCorrectAnswer;
    }

    private ProjogTestQuery getQuery(String line) throws IOException {
        String queryStr = Markup.QUERY.parseText(line);
        ProjogTestQuery query = new ProjogTestQuery(queryStr);
        query.getAnswers().addAll(this.getAnswers());
        this.br.mark();
        String nextLine = this.br.readLine();
        if (Markup.OUTPUT.isMatch(nextLine)) {
            String expectedOutput = this.readLinesUntilNextTag(nextLine, Markup.OUTPUT);
            query.setExpectedOutput(expectedOutput);
            query.setContinuesUntilFails();
            this.br.mark();
            nextLine = this.br.readLine();
        }
        if (Markup.QUIT.isMatch(nextLine)) {
            query.setQuitsBeforeFindingAllAnswers();
        } else if (Markup.NO.isMatch(nextLine)) {
            query.setContinuesUntilFails();
        } else if (Markup.ERROR.isMatch(nextLine)) {
            String expectedExceptionMessage = this.readLinesUntilNextTag(nextLine, Markup.ERROR);
            query.setExpectedExceptionMessage(expectedExceptionMessage);
        } else {
            this.br.reset();
        }
        return query;
    }

    private List<ProjogTestAnswer> getAnswers() throws IOException {
        ProjogTestAnswer answer;
        ArrayList<ProjogTestAnswer> answers = new ArrayList<ProjogTestAnswer>();
        ProjogTestAnswer first = null;
        while ((answer = this.getAnswer()) != null) {
            if (first == null) {
                first = answer;
            } else if (!answer.getVariableIds().equals(first.getVariableIds())) {
                throw new RuntimeException("Answers have different variable Ids: " + first.getVariableIds() + " versus: " + answer.getVariableIds());
            }
            answers.add(answer);
        }
        return answers;
    }

    private ProjogTestAnswer getAnswer() throws IOException {
        this.br.mark();
        String line = this.br.readLine();
        if (line == null) {
            return null;
        }
        if (line.trim().isEmpty()) {
            return null;
        }
        ProjogTestAnswer answer = new ProjogTestAnswer();
        if (Markup.OUTPUT.isMatch(line)) {
            String expectedOutput = this.readLinesUntilNextTag(line, Markup.OUTPUT);
            line = this.br.readLine();
            if (line == null) {
                this.br.reset();
                return null;
            }
            answer.setExpectedOutput(expectedOutput);
        }
        if (Markup.YES.isMatch(line)) {
            return answer;
        }
        if (this.isAssignment(line)) {
            Assignment a;
            while ((a = this.getAssignment(line)) != null && !answer.hasVariableId(a.getVariableId())) {
                answer.addAssignment(a.getVariableId(), a.getExpectedValue());
                this.br.mark();
                line = this.br.readLine();
            }
            this.br.reset();
            return answer;
        }
        this.br.reset();
        return null;
    }

    private boolean isAssignment(String line) {
        return this.getAssignment(line) != null;
    }

    private Assignment getAssignment(String line) {
        if (line == null) {
            return null;
        }
        if (!(line = line.trim()).startsWith(COMMENT_CHARACTER)) {
            return null;
        }
        if (Markup.isMarkup(line)) {
            return null;
        }
        int equalsPos = (line = line.substring(1).trim()).indexOf(61);
        if (equalsPos == -1) {
            return null;
        }
        return new Assignment(line.substring(0, equalsPos).trim(), line.substring(equalsPos + 1).trim());
    }

    private String readLinesUntilNextTag(String line, Markup markup) throws IOException {
        String textOnSameLineAsTag = markup.parseText(line);
        if (textOnSameLineAsTag.length() > 0) {
            return textOnSameLineAsTag;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (!markup.isMatch(line = this.br.readLine())) {
            if (first) {
                first = false;
            } else {
                sb.append(System.lineSeparator());
            }
            sb.append(line.substring(line.indexOf(37) + 1));
        }
        return sb.toString();
    }

    private String getComment(String line) throws IOException {
        String next;
        StringBuilder comment = new StringBuilder(line.substring(1).trim());
        this.br.mark();
        while ((next = this.br.readLine()) != null && this.isStandardComment(next)) {
            comment.append(' ');
            comment.append(next.substring(1).trim());
            this.br.mark();
        }
        this.br.reset();
        return comment.toString().trim();
    }

    private boolean isStandardComment(String line) {
        if (!line.startsWith(COMMENT_CHARACTER)) {
            return false;
        }
        if (line.length() == 1) {
            return false;
        }
        return Character.isWhitespace(line.charAt(1));
    }

    private boolean isIllegalComment(String line) {
        String trimmed = line.trim();
        if (!trimmed.startsWith(COMMENT_CHARACTER)) {
            return false;
        }
        if (trimmed.length() == 1) {
            return false;
        }
        if (!Character.isWhitespace(trimmed.charAt(1))) {
            return true;
        }
        String sanitised = COMMENT_CHARACTER + trimmed.substring(1).trim().toUpperCase();
        return Markup.isMarkup(sanitised);
    }
}

